/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.List;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.SecurityOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapperGrouping;

final class SecurityPropertyMappers
implements PropertyMapperGrouping {
    SecurityPropertyMappers() {
    }

    public List<PropertyMapper<?>> getPropertyMappers() {
        return List.of(PropertyMapper.fromOption(SecurityOptions.FIPS_MODE).transformer(SecurityPropertyMappers::resolveFipsMode).paramLabel("mode").build());
    }

    private static String resolveFipsMode(String value, ConfigSourceInterceptorContext context) {
        if (value == null) {
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS)) {
                return FipsMode.NON_STRICT.toString();
            }
            return FipsMode.DISABLED.toString();
        }
        return value;
    }
}

