/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server._private.ElytronMessages;
import org.wildfly.security.authz.RegexRoles;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;

public class RegexRoleMapper
implements RoleMapper {
    private Pattern pattern;
    private String replacement;
    private boolean keepNonMapped;
    private boolean replaceAll;

    private RegexRoleMapper(Builder builder) {
        Assert.checkNotNullParam((String)"pattern", (Object)builder.pattern);
        Assert.checkNotNullParam((String)"replacement", (Object)builder.replacement);
        if (builder.pattern.length() < 1) {
            throw ElytronMessages.log.invalidPatternInRegexRoleMapper();
        }
        if (builder.replacement.length() < 1) {
            throw ElytronMessages.log.invalidReplacementInRegexRoleMapper();
        }
        try {
            this.pattern = Pattern.compile(builder.pattern);
        }
        catch (PatternSyntaxException ex) {
            throw ElytronMessages.log.invalidPatternInRegexRoleMapper();
        }
        this.replacement = builder.replacement;
        this.keepNonMapped = builder.keepNonMapped;
        this.replaceAll = builder.replaceAll;
    }

    @Override
    public Roles mapRoles(Roles rolesToMap) {
        return new RegexRoles(rolesToMap, this.pattern, this.replacement, this.keepNonMapped, this.replaceAll);
    }

    public static class Builder {
        private String pattern;
        private String replacement;
        private boolean keepNonMapped = true;
        private boolean replaceAll = false;

        public RegexRoleMapper build() {
            return new RegexRoleMapper(this);
        }

        public Builder setPattern(String pattern) {
            Assert.checkNotNullParam((String)"pattern", (Object)pattern);
            this.pattern = pattern;
            return this;
        }

        public Builder setReplacement(String replacement) {
            Assert.checkNotNullParam((String)"replacement", (Object)replacement);
            this.replacement = replacement;
            return this;
        }

        public Builder setKeepNonMapped(boolean keepNonMapped) {
            this.keepNonMapped = keepNonMapped;
            return this;
        }

        public Builder setReplaceAll(boolean replaceAll) {
            this.replaceAll = replaceAll;
            return this;
        }
    }
}

