/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class DaysFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "DAYS";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Date date1 = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        Date date2 = typeRegistry.convertToDate(parameters.getType(1), parameters.getValue(1));
        if (date1 == null || date2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        TimeZone timeZone = localizationContext.getTimeZone();
        Locale locale = localizationContext.getLocale();
        GregorianCalendar calandar1 = new GregorianCalendar(timeZone, locale);
        calandar1.setTime(date1);
        GregorianCalendar calandar2 = new GregorianCalendar(timeZone, locale);
        calandar2.setTime(date2);
        int dayOfYear1 = calandar1.get(6);
        int dayOfYear2 = calandar2.get(6);
        int year1 = calandar1.get(1);
        int year2 = calandar2.get(1);
        GregorianCalendar workingCalandar = new GregorianCalendar(timeZone, locale);
        int res = dayOfYear2 - dayOfYear1;
        int targetYear = Math.max(year1, year2);
        for (int i = Math.min(year1, year2); i < targetYear; ++i) {
            workingCalandar.set(1, i);
            res += workingCalandar.getActualMaximum(6);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal((double)res));
    }
}

