/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;

public class StringNameTable
extends Name.Table {
    private final HashMap<String, Name> nameMap;
    private final boolean intern;

    public static StringNameTable create(Names names, boolean intern) {
        return new StringNameTable(names, intern);
    }

    public StringNameTable(Names names, boolean intern) {
        this(names, 32768, intern);
    }

    public StringNameTable(Names names, int initialCapacity, boolean intern) {
        super(names);
        this.nameMap = new HashMap(initialCapacity);
        this.intern = intern;
    }

    @Override
    public Name fromString(String string) {
        Name name = this.nameMap.get(string);
        if (name == null) {
            if (this.intern) {
                string = string.intern();
            }
            name = new NameImpl(this, string);
            this.nameMap.put(string, name);
        }
        return name;
    }

    @Override
    public Name fromChars(char[] buf, int off, int len) {
        return this.fromString(new String(buf, off, len));
    }

    @Override
    public Name fromUtf(byte[] buf, int off, int len, Convert.Validation validation) throws InvalidUtfException {
        return this.fromString(Convert.utf2string(buf, off, len, validation));
    }

    @Override
    public void dispose() {
        this.nameMap.clear();
    }

    private static final class NameImpl
    extends Name {
        private final String string;

        NameImpl(StringNameTable table, String string) {
            super(table);
            this.string = string;
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public boolean contentEquals(CharSequence cs) {
            return this.string.contentEquals(cs);
        }

        @Override
        protected boolean nameEquals(Name that) {
            return ((NameImpl)that).string.equals(this.string);
        }

        @Override
        public int hashCode() {
            return this.string.hashCode();
        }

        @Override
        public int getUtf8Length() {
            int slen = this.string.length();
            int extra = 0;
            for (int i = 0; i < slen; ++i) {
                char ch = this.string.charAt(i);
                if (ch <= '\u007f' && ch != '\u0000') continue;
                ++extra;
                if (ch <= '\u07ff') continue;
                ++extra;
            }
            return slen + extra;
        }

        @Override
        public void getUtf8Bytes(byte[] buf, int off) {
            Convert.chars2utf(this.string.toCharArray(), 0, buf, off, this.string.length());
        }
    }
}

