/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public final class EqualsHashCodeGenerator
extends CodeActionsProvider {
    private static final String GENERATE_EQUALS_HASHCODE = "nbls.java.generate.equals.hashCode";
    private static final String KIND = "kind";
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String FIELDS = "fields";
    private static final int EQUALS_ONLY = 1;
    private static final int HASH_CODE_ONLY = 2;
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = EqualsHashCodeGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(Tree.Kind.CLASS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(tp);
        if (type == null || type.getKind() != ElementKind.CLASS) {
            return Collections.emptyList();
        }
        ExecutableElement[] equalsHashCode = org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)info, (Element)type, null);
        if (equalsHashCode[0] != null && equalsHashCode[1] != null) {
            return Collections.emptyList();
        }
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if ("<error>".contentEquals(variableElement.getSimpleName()) || variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            QuickPickItem item = new QuickPickItem(EqualsHashCodeGenerator.createLabel((CompilationInfo)info, variableElement));
            item.setUserData(new CodeActionsProvider.ElementData(variableElement));
            fields.add(item);
        }
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        String uri = Utils.toUri(info.getFileObject());
        if (equalsHashCode[0] == null) {
            if (equalsHashCode[1] == null) {
                return Collections.singletonList(this.createCodeAction(client, Bundle.DN_GenerateEqualsHashCode(), "source.generate", null, "nbls.generate.code", Utils.encodeCommand(GENERATE_EQUALS_HASHCODE, client.getNbCodeCapabilities()), EqualsHashCodeGenerator.data(0, uri, offset, fields)));
            }
            return Collections.singletonList(this.createCodeAction(client, Bundle.DN_GenerateEquals(), "source.generate", null, "nbls.generate.code", Utils.encodeCommand(GENERATE_EQUALS_HASHCODE, client.getNbCodeCapabilities()), EqualsHashCodeGenerator.data(1, uri, offset, fields)));
        }
        return Collections.singletonList(this.createCodeAction(client, Bundle.DN_GenerateHashCode(), "source.generate", null, "nbls.generate.code", Utils.encodeCommand(GENERATE_EQUALS_HASHCODE, client.getNbCodeCapabilities()), EqualsHashCodeGenerator.data(2, uri, offset, fields)));
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(GENERATE_EQUALS_HASHCODE);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        JsonObject data = (JsonObject)arguments.get(0);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            String text;
            String title;
            int kind = data.getAsJsonPrimitive(KIND).getAsInt();
            String uri = data.getAsJsonPrimitive(URI).getAsString();
            int offset = data.getAsJsonPrimitive(OFFSET).getAsInt();
            List<QuickPickItem> fields = Arrays.asList((QuickPickItem[])this.gson.fromJson(data.get(FIELDS), QuickPickItem[].class));
            boolean generateEquals = 2 != kind;
            boolean generateHashCode = 1 != kind;
            switch (kind) {
                case 1: {
                    title = Bundle.DN_GenerateEquals();
                    text = Bundle.DN_SelectEquals();
                    break;
                }
                case 2: {
                    title = Bundle.DN_GenerateHashCode();
                    text = Bundle.DN_SelectHashCode();
                    break;
                }
                default: {
                    title = Bundle.DN_GenerateEqualsHashCode();
                    text = Bundle.DN_SelectEqualsHashCode();
                }
            }
            client.showQuickPick(new ShowQuickPickParams(title, text, true, fields)).thenAccept(selected -> {
                try {
                    if (selected != null) {
                        FileObject file = Utils.fromUri(uri);
                        JavaSource js = JavaSource.forFileObject((FileObject)file);
                        if (js == null) {
                            throw new IOException("Cannot get JavaSource for: " + uri);
                        }
                        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                            wc.toPhase(JavaSource.Phase.RESOLVED);
                            TreePath tp = wc.getTreeUtilities().pathFor(offset);
                            tp = wc.getTreeUtilities().getPathElementOfKind(Tree.Kind.CLASS, tp);
                            if (tp != null) {
                                List selectedFields = selected.stream().map(item -> {
                                    CodeActionsProvider.ElementData userData = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                                    return (VariableElement)userData.resolve((CompilationInfo)wc);
                                }).collect(Collectors.toList());
                                org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator.generateEqualsAndHashCode((WorkingCopy)wc, (TreePath)tp, generateEquals ? selectedFields : null, generateHashCode ? selectedFields : null, (int)-1);
                            }
                        }));
                        future.complete(edits.isEmpty() ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits)));
                    } else {
                        future.complete(null);
                    }
                }
                catch (IOException | IllegalArgumentException ex) {
                    future.completeExceptionally(ex);
                }
            });
        }
        catch (JsonSyntaxException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private static Map<String, Object> data(int kind, String uri, int offset, List<QuickPickItem> fields) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KIND, kind);
        data.put(URI, uri);
        data.put(OFFSET, offset);
        data.put(FIELDS, fields);
        return data;
    }
}

