/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import org.netbeans.api.lexer.TokenId;

public enum HCLTokenId implements TokenId
{
    LINE_COMMENT(null, "comment"),
    BLOCK_COMMENT(null, "comment"),
    TRUE("true", "boolean"),
    FALSE("false", "boolean"),
    NULL("null", "keyword"),
    LEGACY_INDEX(null, "number"),
    NUMERIC_LIT(null, "number"),
    IDENTIFIER(null, "identifier"),
    FOR("for", "keyword"),
    IF("if", "keyword"),
    IN("in", "keyword"),
    LBRACE("{", "group-separator"),
    RBRACE("}", "group-separator"),
    LBRACK("[", "group-separator"),
    RBRACK("]", "group-separator"),
    LPAREN("(", "separator"),
    RPAREN(")", "separator"),
    COLON(":", "separator"),
    COMMA(",", "separator"),
    DOT(".", "separator"),
    EQUAL("=", "separator"),
    INTERPOLATION_START("${", "separator"),
    INTERPOLATION_END("}", "separator"),
    RARROW("=>", "separator"),
    SCOPE("::", "separator"),
    TEMPLATE_START("%{", "separator"),
    TEMPLATE_END("}", "separator"),
    AND("&&", "operator"),
    ELLIPSIS("...", "operator"),
    EQUALS("--", "operator"),
    GT(">", "operator"),
    GTE(">=", "operator"),
    LT("<", "operator"),
    LTE("<=", "operator"),
    MINUS("-", "operator"),
    NOT("!", "operator"),
    NOT_EQUALS("!=", "operator"),
    OR("||", "operator"),
    PERCENT("%", "operator"),
    PLUS("+", "operator"),
    QUESTION("?", "operator"),
    SLASH("/", "operator"),
    STAR("*", "operator"),
    QUOTE("\"", "string"),
    HEREDOC_START(null, "heredoc-guard"),
    HEREDOC_END(null, "heredoc-guard"),
    HEREDOC(null, "heredoc"),
    STRING(null, "string"),
    INTERPOLATION(null, "interpolation"),
    TEMPLATE(null, "interpolation"),
    WS(null, "whitespace"),
    NL(null, "whitespace"),
    ERROR(null, "error");

    private final String fixedText;
    private final String category;

    private HCLTokenId(String fixedText, String category) {
        this.fixedText = fixedText;
        this.category = category;
    }

    public String getFixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.category;
    }

    public static boolean isGroupOpen(HCLTokenId id) {
        return id == LBRACE || id == LBRACK || id == LPAREN;
    }

    public static boolean isGroupClose(HCLTokenId id) {
        return id == RBRACE || id == RBRACK || id == RPAREN;
    }
}

