/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.utils;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.Methods;

public final class FindMethodUtils {
    private FindMethodUtils() {
    }

    public static boolean isDynamicCall(AstPath path, MethodCallExpression methodCall) {
        return FindMethodUtils.findMethodType(path, methodCall) == null;
    }

    public static ClassNode findMethodType(AstPath path, MethodCallExpression methodCall) {
        Expression expression = methodCall.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            Variable variable = variableExpression.getAccessedVariable();
            if (variable != null) {
                if (variable.isDynamicTyped()) {
                    return null;
                }
                return variable.getOriginType();
            }
            if (methodCall.isImplicitThis()) {
                String methodName;
                ClassNode owner = ASTUtils.getOwningClass((AstPath)path);
                List methods = owner.getMethods(methodName = methodCall.getMethodAsString());
                if (methods.size() > 0) {
                    return ((MethodNode)methods.get(0)).getDeclaringClass();
                }
                return null;
            }
            return ASTUtils.getOwningClass((AstPath)path);
        }
        if (expression instanceof ClassExpression) {
            return ((ClassExpression)expression).getType();
        }
        if (expression instanceof ConstructorCallExpression) {
            return ((ConstructorCallExpression)expression).getType();
        }
        assert (false);
        return null;
    }

    public static MethodNode findMethod(AstPath path, MethodCallExpression methodCall) {
        ClassNode methodType = FindMethodUtils.findMethodType(path, methodCall);
        if (methodType != null) {
            return FindMethodUtils.findMethod(methodType, methodCall);
        }
        return FindMethodUtils.findDynamicMethodType();
    }

    private static MethodNode findMethod(ClassNode type, MethodCallExpression methodCall) {
        MethodNode method;
        String findingMethod = methodCall.getMethodAsString();
        Expression arguments = methodCall.getArguments();
        if (!type.isResolved()) {
            type = type.redirect();
        }
        if ((method = type.tryFindPossibleMethod(findingMethod, arguments)) != null) {
            return method;
        }
        return FindMethodUtils.findMostAccurateMethod(methodCall, type.getMethods(findingMethod));
    }

    private static MethodNode findMostAccurateMethod(MethodCallExpression methodCall, List<MethodNode> methods) {
        ArrayList<MethodNode> possibleMethods = new ArrayList<MethodNode>();
        for (MethodNode methodNode : methods) {
            if (!Methods.isSameMethod((MethodNode)methodNode, (MethodCallExpression)methodCall)) continue;
            possibleMethods.add(methodNode);
        }
        if (possibleMethods.size() > 0) {
            return (MethodNode)possibleMethods.get(0);
        }
        return null;
    }

    private static MethodNode findDynamicMethodType() {
        return null;
    }
}

