/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.netbeans.modules.web.monitor.data.ClientData;
import org.netbeans.modules.web.monitor.data.ContextAttributes;
import org.netbeans.modules.web.monitor.data.ContextData;
import org.netbeans.modules.web.monitor.data.CookieIn;
import org.netbeans.modules.web.monitor.data.CookieOut;
import org.netbeans.modules.web.monitor.data.CookiesData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.DispatchData;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestAttributesIn;
import org.netbeans.modules.web.monitor.data.RequestAttributesOut;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.netbeans.modules.web.monitor.data.SessionData;
import org.netbeans.modules.web.monitor.data.SessionIn;
import org.netbeans.modules.web.monitor.data.SessionOut;
import org.netbeans.modules.web.monitor.server.Logger;
import org.netbeans.modules.web.monitor.server.MonitorRequestWrapper;
import org.netbeans.modules.web.monitor.server.MonitorResponseWrapper;
import org.netbeans.modules.web.monitor.server.NotifyUtil;

public class MonitorFilter
extends Logger
implements Filter {
    public static final String REPLAY = "netbeans.replay";
    public static final String PORT = "netbeans.replay.port";
    public static final String REPLAYSTATUS = "netbeans.replay.status";
    public static final String REPLAYSESSION = "netbeans.replay.session";
    private String attribute = null;
    public static final String PREFIX = "netbeans.monitor";
    private static final String attNameRequest = "netbeans.monitor.request";
    private static final String attNameResponse = "netbeans.monitor.response";
    private static final String attNameFilter = "netbeans.monitor.filter";
    private static final String attNameMonData = "netbeans.monitor.monData";
    public static final String IDE = "netbeans.monitor.ide";
    public static final String IDES = "netbeans.monitor.register";
    private static boolean collectData = true;
    private FilterConfig filterConfig = null;
    private static final String className = "org.netbeans.modules.web.monitor.server.Monitor";
    private static ResourceBundle statusmsgs = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.MonitorBundle");
    private static NotifyUtil notifyUtil = null;
    private static final String[] APPSERVER_SYSTEM_WEB_MODULES = new String[]{"/com_sun_web_ui", "/asadmin", "/web1"};
    private static final String NETBEANS_INTERNAL_REQUEST_URI = "/netbeans-tomcat-status-test";
    private static final boolean debug = false;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object obj = this.getFilterConfig().getServletContext().getAttribute("org.apache.catalina.MBeanServer");
        boolean internalAppServerRequest = false;
        boolean internalIDERequest = false;
        if (request instanceof HttpServletRequest) {
            String requestURI = ((HttpServletRequest)request).getRequestURI();
            for (int i = 0; i < APPSERVER_SYSTEM_WEB_MODULES.length; ++i) {
                if (!requestURI.startsWith(APPSERVER_SYSTEM_WEB_MODULES[i])) continue;
                internalAppServerRequest = true;
                break;
            }
            if (requestURI.startsWith(NETBEANS_INTERNAL_REQUEST_URI)) {
                internalIDERequest = true;
            }
        }
        if (!collectData || !(request instanceof HttpServletRequest) || obj != null || internalAppServerRequest || internalIDERequest) {
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable t) {
                this.rethrow(t);
            }
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        boolean outermost = true;
        MonitorRequestWrapper requestWrapper = null;
        HttpServletResponseWrapper responseWrapper = null;
        DataRecord dr = null;
        if (request instanceof HttpServletRequestWrapper && response instanceof HttpServletResponseWrapper) {
            Object o = req.getAttribute(attNameRequest);
            if (o instanceof MonitorRequestWrapper) {
                outermost = false;
                requestWrapper = (HttpServletRequestWrapper)req;
                responseWrapper = (HttpServletResponseWrapper)response;
                dr = this.setupDispatchDataRecord((MonitorRequestWrapper)((Object)o));
                if (dr == null) {
                    try {
                        chain.doFilter(request, response);
                    }
                    catch (Throwable t) {
                        this.rethrow(t);
                    }
                    return;
                }
            }
            if (requestWrapper == null) {
                this.log(ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Deploy_first"));
            }
        }
        if (requestWrapper == null) {
            String query = req.getQueryString();
            if (query != null && query.startsWith(REPLAY)) {
                try {
                    requestWrapper = this.getReplayRequest(req);
                }
                catch (IOException ioex) {
                    try {
                        chain.doFilter(request, response);
                    }
                    catch (Throwable t) {
                        this.rethrow(t);
                    }
                    return;
                }
            }
            requestWrapper = new MonitorRequestWrapper(req);
            requestWrapper.setAttribute(attNameRequest, (Object)requestWrapper);
            dr = this.setupDataRecord((ServletRequest)requestWrapper);
            HttpServletResponse res = (HttpServletResponse)response;
            responseWrapper = new MonitorResponseWrapper(res, (HttpServletRequest)requestWrapper);
            requestWrapper.setAttribute(attNameResponse, responseWrapper);
            requestWrapper.setAttribute(attNameFilter, this);
        }
        Throwable processingError = null;
        boolean cntnue = true;
        try {
            this.getDataBefore(dr, (HttpServletRequest)requestWrapper);
        }
        catch (StackOverflowError soe) {
            processingError = soe;
            cntnue = false;
        }
        catch (Throwable soe) {
            // empty catch block
        }
        if (cntnue) {
            try {
                chain.doFilter((ServletRequest)requestWrapper, responseWrapper);
            }
            catch (StackOverflowError soe) {
                processingError = soe;
                cntnue = false;
            }
            catch (Throwable t) {
                processingError = t;
            }
        }
        if (cntnue) {
            try {
                this.getDataAfter(dr, (HttpServletRequest)requestWrapper);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (outermost) {
            this.disposeDataRecord((ServletRequest)requestWrapper);
        } else {
            this.disposeDispatchedDataRecord((ServletRequest)requestWrapper);
            ((MonitorRequestWrapper)((Object)requestWrapper.getAttribute(attNameRequest))).popExtraParameters();
        }
        if (processingError != null) {
            this.rethrow(processingError);
        }
    }

    private DataRecord setupDataRecord(ServletRequest req) {
        MonitorData md = new MonitorData();
        Stack<MonitorData> dataStack = new Stack<MonitorData>();
        dataStack.push(md);
        req.setAttribute(attNameMonData, dataStack);
        return md;
    }

    private DataRecord setupDispatchDataRecord(MonitorRequestWrapper req) {
        req.pushExtraParameters();
        Stack dataStack = null;
        try {
            dataStack = (Stack)req.getAttribute(attNameMonData);
        }
        catch (Throwable t) {
            return null;
        }
        if (dataStack.empty()) {
            return null;
        }
        Object obj = dataStack.peek();
        Dispatches disp = null;
        if (!(obj instanceof DataRecord)) {
            return null;
        }
        DataRecord dr = (DataRecord)obj;
        disp = dr.getDispatches();
        if (disp == null) {
            disp = new Dispatches();
            dr.setDispatches(disp);
        }
        DispatchData disData = new DispatchData();
        disp.addDispatchData(disData);
        dataStack.push(disData);
        return disData;
    }

    private void disposeDataRecord(ServletRequest req) {
        Object o;
        req.removeAttribute(attNameRequest);
        req.removeAttribute(attNameResponse);
        req.removeAttribute(attNameFilter);
        MonitorData monData = null;
        Stack stack = (Stack)req.getAttribute(attNameMonData);
        req.removeAttribute(attNameMonData);
        if (stack != null && !stack.empty() && (o = stack.pop()) instanceof MonitorData) {
            monData = (MonitorData)o;
        }
        if (monData == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(monData.getAttributeValue("id"));
        buf.append("|");
        buf.append(monData.getAttributeValue("method"));
        buf.append("|");
        buf.append(monData.getAttributeValue("resource"));
        notifyUtil.sendRecord(monData, buf.toString());
    }

    private DataRecord disposeDispatchedDataRecord(ServletRequest req) {
        Stack stack = (Stack)req.getAttribute(attNameMonData);
        Object o = null;
        if (stack != null && !stack.empty()) {
            o = stack.pop();
        }
        if (o instanceof DataRecord) {
            return o;
        }
        return null;
    }

    public void handleDispatchedBefore(ServletRequest req) {
        Object w = req.getAttribute(attNameRequest);
        if (!(w instanceof MonitorRequestWrapper)) {
            return;
        }
        DataRecord dr = this.setupDispatchDataRecord((MonitorRequestWrapper)((Object)w));
        if (dr == null) {
            return;
        }
        this.getDataBefore(dr, (HttpServletRequest)req);
    }

    public void handleDispatchedAfter(ServletRequest req) {
        Object w = req.getAttribute(attNameRequest);
        if (!(w instanceof MonitorRequestWrapper)) {
            return;
        }
        DataRecord dr = this.disposeDispatchedDataRecord((ServletRequest)((MonitorRequestWrapper)((Object)w)));
        if (dr == null) {
            return;
        }
        this.getDataAfter(dr, (HttpServletRequest)req);
        ((MonitorRequestWrapper)((Object)w)).popExtraParameters();
    }

    private void getDataBefore(DataRecord dataRecord, HttpServletRequest request) {
        if (dataRecord instanceof MonitorData) {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String method = request.getMethod();
            String uri = request.getRequestURI();
            String resource = new String(uri);
            String id = new String(timestamp);
            dataRecord.setAttributeValue("id", id);
            dataRecord.setAttributeValue("timestamp", timestamp);
            dataRecord.setAttributeValue("resource", resource);
            dataRecord.setAttributeValue("method", method);
        } else if (dataRecord instanceof DispatchData) {
            String resource = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (resource == null || resource.equals("")) {
                resource = request.getRequestURI();
            }
            dataRecord.setAttributeValue("resource", resource);
        }
        ClientData cd = new ClientData();
        this.recordClientData(cd, request);
        dataRecord.setClientData(cd);
        ContextData cond = new ContextData();
        this.recordContextData(cond, request);
        dataRecord.setContextData(cond);
        EngineData ed = new EngineData();
        this.recordEngineData(ed, request);
        dataRecord.setEngineData(ed);
        SessionData sd = new SessionData();
        this.getSessionIn(sd, request);
        dataRecord.setSessionData(sd);
        RequestData rd = new RequestData();
        this.recordRequestData(rd, request);
        dataRecord.setRequestData(rd);
        CookiesData cookiesData = new CookiesData();
        this.recordCookiesIn(cookiesData, request);
        dataRecord.setCookiesData(cookiesData);
    }

    private void getDataAfter(DataRecord dataRecord, HttpServletRequest request) {
        MonitorResponseWrapper monResponse = (MonitorResponseWrapper)((Object)request.getAttribute(attNameResponse));
        int status = monResponse.getStatus();
        RequestData rd = dataRecord.getRequestData();
        if (status == 0) {
            rd.setAttributeValue("status", ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Unknown_exit_status"));
        } else {
            String statusStr = "sc".concat(String.valueOf(status));
            rd.setAttributeValue("status", statusmsgs.getString(statusStr));
        }
        RequestAttributesOut reqattrout = new RequestAttributesOut();
        reqattrout.setParam(this.recordRequestAttributes(request));
        rd.setRequestAttributesOut(reqattrout);
        this.addRequestParameters(rd, request);
        this.recordCookiesOut(dataRecord.getCookiesData(), monResponse);
        this.addSessionOut(dataRecord.getSessionData(), request);
    }

    private void recordClientData(ClientData cd, HttpServletRequest request) {
        String protocol = request.getProtocol();
        while (protocol.endsWith("\n")) {
            protocol = protocol.substring(0, protocol.length() - 2);
        }
        cd.setAttributeValue("protocol", protocol);
        cd.setAttributeValue("remoteAddress", request.getRemoteAddr());
        StringBuffer valueBuf = new StringBuffer(128);
        int counter = 0;
        Enumeration hvals = request.getHeaders("user-agent");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("software", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept-language");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("locale", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("formatsAccepted", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept-encoding");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("encodingsAccepted", valueBuf.toString());
        valueBuf = new StringBuffer(128);
        counter = 0;
        hvals = request.getHeaders("accept-charset");
        if (hvals != null) {
            while (hvals.hasMoreElements()) {
                if (counter > 0) {
                    valueBuf.append(", ");
                }
                valueBuf.append((String)hvals.nextElement());
                ++counter;
            }
        }
        cd.setAttributeValue("charsetsAccepted", valueBuf.toString());
    }

    private void recordCookiesIn(CookiesData cd, HttpServletRequest request) {
        Cookie[] cks = null;
        try {
            cks = request.getCookies();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cks == null || cks.length == 0) {
            cd.setCookieIn(new CookieIn[0]);
            return;
        }
        CookieIn[] theCookies = new CookieIn[cks.length];
        for (int i = 0; i < theCookies.length; ++i) {
            theCookies[i] = new CookieIn(cks[i].getName(), cks[i].getValue());
        }
        cd.setCookieIn(theCookies);
    }

    private void recordCookiesOut(CookiesData cd, MonitorResponseWrapper response) {
        Enumeration e = response.getCookies();
        int numCookies = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++numCookies;
        }
        if (numCookies == 0) {
            cd.setCookieOut(new CookieOut[0]);
            return;
        }
        e = response.getCookies();
        CookieOut[] theCookies = null;
        try {
            theCookies = new CookieOut[numCookies];
            for (int i = 0; i < theCookies.length; ++i) {
                Cookie c = (Cookie)e.nextElement();
                theCookies[i] = new CookieOut(c.getName(), c.getValue(), c.getMaxAge(), c.getVersion(), c.getDomain(), c.getPath(), c.getComment(), c.getSecure());
            }
        }
        catch (NullPointerException ne) {
            theCookies = new CookieOut[]{};
        }
        cd.setCookieOut(theCookies);
    }

    private void getSessionIn(SessionData sess, HttpServletRequest request) {
        HttpSession sessIn = null;
        try {
            sessIn = request.getSession(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sessIn == null) {
            sess.setAttributeValue("before", "false");
            return;
        }
        sess.setAttributeValue("before", "true");
        sess.setAttributeValue("id", sessIn.getId());
        DateFormat df = DateFormat.getDateTimeInstance(0, 3);
        Date date = new Date(sessIn.getCreationTime());
        sess.setAttributeValue("created", df.format(date));
        SessionIn si = new SessionIn();
        int maxint = 0;
        try {
            maxint = sessIn.getMaxInactiveInterval();
            if (maxint != 0) {
                si.setAttributeValue("inactiveInterval", String.valueOf(maxint));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            date = new Date(sessIn.getLastAccessedTime());
            si.setAttributeValue("lastAccessed", df.format(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        si.setParam(this.getSessionAttributes(sessIn));
        sess.setSessionIn(si);
    }

    private void addSessionOut(SessionData sess, HttpServletRequest request) {
        HttpSession sessOut = null;
        try {
            sessOut = request.getSession(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sessOut == null) {
            sess.setAttributeValue("after", "false");
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance(0, 3);
        sess.setAttributeValue("after", "true");
        Date date = null;
        if (sess.getAttributeValue("before").equals("false")) {
            sess.setAttributeValue("id", sessOut.getId());
            date = new Date(sessOut.getCreationTime());
            sess.setAttributeValue("created", df.format(date));
        }
        SessionOut so = new SessionOut();
        int maxint = 0;
        try {
            maxint = sessOut.getMaxInactiveInterval();
            if (maxint != 0) {
                so.setAttributeValue("inactiveInterval", String.valueOf(maxint));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            date = new Date(sessOut.getLastAccessedTime());
            so.setAttributeValue("lastAccessed", df.format(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Param[] params = this.getSessionAttributes(sessOut);
        so.setParam(params);
        sess.setSessionOut(so);
    }

    private Param[] getSessionAttributes(HttpSession session) {
        Enumeration names = null;
        try {
            names = session.getAttributeNames();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (names == null || !names.hasMoreElements()) {
            return new Param[0];
        }
        Vector<Param> v = new Vector<Param>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = session.getAttribute(name);
            String valueRep = null;
            try {
                if (value == null) {
                    valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_attributes");
                } else {
                    valueRep = value.toString();
                    if (valueRep == null) {
                        valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_toString_null");
                    }
                }
            }
            catch (Throwable t) {
                valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_toString_exception");
            }
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", valueRep);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        for (int i = 0; i < size; ++i) {
            params[i] = (Param)((Object)v.elementAt(i));
        }
        return params;
    }

    private void recordRequestData(RequestData rd, HttpServletRequest request) {
        String method = request.getMethod();
        rd.setAttributeValue("uri", request.getRequestURI());
        rd.setAttributeValue("method", method);
        String protocol = request.getProtocol();
        while (protocol.endsWith("\n")) {
            protocol = protocol.substring(0, protocol.length() - 2);
        }
        rd.setAttributeValue("protocol", protocol);
        rd.setAttributeValue("ipaddress", request.getRemoteAddr());
        String queryString = request.getQueryString();
        if (queryString == null || queryString.trim().equals("")) {
            queryString = "";
        }
        rd.setAttributeValue("queryString", queryString);
        rd.setAttributeValue("scheme", request.getScheme());
        Headers headers = new Headers();
        headers.setParam(this.recordHeaders(request));
        rd.setHeaders(headers);
        RequestAttributesIn reqattrin = new RequestAttributesIn();
        reqattrin.setParam(this.recordRequestAttributes(request));
        rd.setRequestAttributesIn(reqattrin);
    }

    private void recordContextData(ContextData cd, HttpServletRequest request) {
        ServletContext context = this.filterConfig.getServletContext();
        cd.setAttributeValue("absPath", context.getRealPath("/"));
        cd.setAttributeValue("contextName", context.getServletContextName());
        ContextAttributes ctxtattr = new ContextAttributes();
        ctxtattr.setParam(this.recordContextAttributes(context));
        cd.setContextAttributes(ctxtattr);
        Enumeration e = context.getInitParameterNames();
        Vector<Param> v = new Vector<Param>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = context.getInitParameter(name);
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", value);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        for (int i = 0; i < size; ++i) {
            params[i] = (Param)((Object)v.elementAt(i));
        }
        cd.setParam(params);
    }

    private void recordEngineData(EngineData ed, HttpServletRequest request) {
        ServletContext context = this.filterConfig.getServletContext();
        ed.setAttributeValue("serverName", request.getServerName());
        ed.setAttributeValue("serverPort", String.valueOf(request.getServerPort()));
        ed.setAttributeValue("jre", System.getProperty("java.version"));
        ed.setAttributeValue("platform", context.getServerInfo());
    }

    private Param[] recordHeaders(HttpServletRequest request) {
        Vector<Param> v = new Vector<Param>();
        Vector<String> names = new Vector<String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (names.contains(name)) continue;
            Enumeration value = request.getHeaders(name);
            int counter = 0;
            while (value.hasMoreElements()) {
                v.add(new Param(name, (String)value.nextElement()));
                ++counter;
            }
            if (counter <= true) continue;
            names.add(name);
        }
        int size = v.size();
        Param[] params = new Param[size];
        for (int i = 0; i < size; ++i) {
            params[i] = (Param)((Object)v.elementAt(i));
        }
        return params;
    }

    private void addRequestParameters(RequestData rd, HttpServletRequest request) {
        String[] vals;
        String name;
        Enumeration e2;
        String method = rd.getAttributeValue("method");
        boolean urlencoded = true;
        if (method.equals("POST")) {
            Headers headers = rd.getHeaders();
            String urlencodedS = "application/x-www-form-urlencoded";
            String typeS = "Content-type";
            if (headers.containsHeader(typeS) && !headers.getHeader(typeS).equalsIgnoreCase(urlencodedS)) {
                urlencoded = false;
            }
        }
        rd.setAttributeValue("urlencoded", String.valueOf(urlencoded));
        if (method.equals("GET")) {
            try {
                e2 = request.getParameterNames();
                while (e2.hasMoreElements()) {
                    name = (String)e2.nextElement();
                    vals = request.getParameterValues(name);
                    for (int i = 0; i < vals.length; ++i) {
                        rd.addParam(new Param(name, vals[i]));
                    }
                }
            }
            catch (Exception e2) {}
        } else if (method.equals("POST") && urlencoded) {
            e2 = null;
            try {
                e2 = request.getParameterNames();
                while (e2.hasMoreElements()) {
                    name = (String)e2.nextElement();
                    vals = request.getParameterValues(name);
                    for (int i = 0; i < vals.length; ++i) {
                        rd.addParam(new Param(name, vals[i]));
                    }
                }
            }
            catch (Exception ex) {
                rd.setAttributeValue("urlencoded", "bad");
            }
        }
    }

    private Param[] recordRequestAttributes(HttpServletRequest request) {
        Vector<Param> v = new Vector<Param>();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = request.getAttribute(name);
            String valueRep = null;
            try {
                valueRep = value.toString();
                if (valueRep == null) {
                    valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_toString_null");
                }
            }
            catch (Throwable t) {
                valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_toString_exception");
            }
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", valueRep);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        for (int i = 0; i < size; ++i) {
            params[i] = (Param)((Object)v.elementAt(i));
        }
        return params;
    }

    private Param[] recordContextAttributes(ServletContext context) {
        Vector<Param> v = new Vector<Param>();
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = context.getAttribute(name);
            String valueRep = null;
            try {
                if (value == null) {
                    valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_attributes");
                } else if (value.getClass().isArray()) {
                    Object[] valueItems = (Object[])value;
                    StringBuffer sb = new StringBuffer(valueItems.length * 16);
                    if (valueItems.length > 0) {
                        sb.append(valueItems[0]);
                    }
                    for (int i = 1; i < valueItems.length; ++i) {
                        sb.append(", ");
                        sb.append(valueItems[i]);
                    }
                    valueRep = sb.toString();
                } else {
                    valueRep = value.toString();
                    if (valueRep == null) {
                        valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_toString_null");
                    }
                }
            }
            catch (Throwable t) {
                valueRep = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_toString_exception");
            }
            Param p = new Param();
            p.setAttributeValue("name", name);
            p.setAttributeValue("value", valueRep);
            v.add(p);
        }
        int size = v.size();
        Param[] params = new Param[size];
        for (int i = 0; i < size; ++i) {
            params[i] = (Param)((Object)v.elementAt(i));
        }
        return params;
    }

    private MonitorRequestWrapper getReplayRequest(HttpServletRequest req) throws IOException {
        String status = req.getParameter(REPLAYSTATUS);
        if (status == null) {
            String msg = " replay request corrupted";
            throw new IOException(msg);
        }
        String id = req.getParameter(REPLAY);
        String portS = req.getParameter(PORT);
        int port = 0;
        try {
            port = Integer.parseInt(portS);
        }
        catch (NumberFormatException nfe) {
            String msg = " Request did not provide a port number";
            throw new IOException(msg);
        }
        String ipaddress = req.getRemoteAddr();
        RequestData rd = notifyUtil.getRecord(id, status, ipaddress, port);
        if (rd == null) {
            String msg = "Failed to get the request";
            throw new IOException(msg);
        }
        boolean replaceSessionID = false;
        try {
            String sessionID = req.getParameter(REPLAYSESSION);
            if (sessionID != null) {
                replaceSessionID = true;
            }
        }
        catch (NullPointerException npe) {
            this.log("NPE when getting netbeans.replay.session");
        }
        MonitorRequestWrapper requestWrapper = new MonitorRequestWrapper(req);
        requestWrapper.populate(rd, replaceSessionID);
        return requestWrapper;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.attribute = filterConfig != null ? filterConfig.getInitParameter("attribute") : null;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        notifyUtil = new NotifyUtil();
        boolean noIDE = true;
        String ide = filterConfig.getInitParameter(IDE);
        if (ide != null && !ide.equals("")) {
            try {
                notifyUtil.setIDE(ide);
                collectData = true;
            }
            catch (MalformedURLException mux) {
                this.log("IDE init parameter has an invalid value:");
                this.log(ide);
                this.log("starting anyway");
            }
        } else {
            this.log("IDE init parameter has an invalid value:");
            this.log(ide);
            this.log("starting anyway");
        }
        String ides = filterConfig.getInitParameter(IDES);
        if (ides != null && !ides.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(ides, ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                try {
                    notifyUtil.setIDE(name.trim());
                    collectData = true;
                }
                catch (MalformedURLException mux) {
                    this.log("additional IDE includes an invalid server declaration:");
                    this.log(name);
                    this.log("starting anyway");
                }
            }
        }
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "MonitorFilter()";
        }
        StringBuffer sb = new StringBuffer("MonitorFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    public static boolean getCollectData() {
        return collectData;
    }

    public static void setCollectData(boolean v) {
        collectData = v;
    }

    private void rethrow(Throwable t) throws IOException, ServletException {
        if (t instanceof StackOverflowError) {
            String message = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_overflow");
            this.filterConfig.getServletContext().log(message);
            System.out.println(message);
            throw new ServletException(message, t);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        String message = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Rethrow");
        throw new ServletException(message, t);
    }

    @Override
    public void log(String msg) {
        System.out.println("MonitorFilter::" + msg);
    }

    @Override
    public void log(Throwable t) {
        this.log(MonitorFilter.getStackTrace(t));
    }
}

