/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.netbeans.insane.model.HeapModel;
import org.netbeans.insane.model.Item;

class BinaryHeapModel
implements HeapModel {
    private Map<Integer, Item> createdObjects = new HashMap<Integer, Item>();
    private Map<Integer, Cls> createdClasses = new HashMap<Integer, Cls>();
    ByteBuffer buffer;
    int refsOffset;
    int objsOffset;

    public static HeapModel open(File file) throws Exception {
        BinaryHeapModel model = new BinaryHeapModel(file);
        return model;
    }

    BinaryHeapModel(File data) throws Exception {
        long len = data.length();
        this.buffer = new FileInputStream(data).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
        System.err.println("magic=" + this.buffer.getInt(0));
        this.refsOffset = this.buffer.getInt(4);
        this.objsOffset = this.buffer.getInt(8);
        System.err.println("refs=" + this.refsOffset);
        System.err.println("objs=" + this.objsOffset);
    }

    @Override
    public Iterator<Item> getAllItems() {
        ArrayList<HItem> all = new ArrayList<HItem>();
        int actOffset = this.objsOffset;
        while (actOffset < this.buffer.limit()) {
            HItem act = (HItem)this.getItem(actOffset);
            all.add(act);
            actOffset = act.getNextOffset();
        }
        return all.iterator();
    }

    @Override
    public Collection<Item> getObjectsOfType(String type) {
        Cls cls = this.getClsByName(type);
        return cls == null ? Collections.emptyList() : cls.getInstances();
    }

    @Override
    public Collection<String> getRoots() {
        ArrayList<String> all = new ArrayList<String>();
        int actOffset = this.refsOffset;
        while (actOffset < this.objsOffset) {
            RefType act = new RefType(actOffset);
            if (act.isStatic()) {
                all.add(act.getReferenceName());
            }
            actOffset = act.getNextOffset();
        }
        return all;
    }

    @Override
    public Item getObjectAt(String staticRefName) {
        RefType type = this.getRefTypeByName(staticRefName);
        return type.getInstance();
    }

    @Override
    public Item getItem(int id) {
        Integer key = id;
        Item ret = this.createdObjects.get(key);
        if (ret == null) {
            ret = new HItem(id);
            this.createdObjects.put(key, ret);
        }
        return ret;
    }

    private Cls getClsByName(String name) {
        int actOffset = 12;
        while (actOffset < this.refsOffset) {
            Cls act = this.getCls(actOffset);
            if (name.equals(act.getClassName())) {
                return act;
            }
            actOffset = act.getNextOffset();
        }
        return null;
    }

    private Cls getCls(int offset) {
        Integer key = offset;
        Cls ret = this.createdClasses.get(key);
        if (ret == null) {
            ret = new Cls(offset);
            this.createdClasses.put(key, ret);
        }
        return ret;
    }

    private RefType getRefTypeByName(String name) {
        int actOffset = this.refsOffset;
        while (actOffset < this.objsOffset) {
            RefType act = new RefType(actOffset);
            if (name.equals(act.getReferenceName())) {
                return act;
            }
            actOffset = act.getNextOffset();
        }
        return null;
    }

    private class Cls {
        int offset;

        private Cls(int offset) {
            this.offset = offset;
        }

        public String getClassName() {
            ByteBuffer local = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            int len = local.getInt();
            byte[] data = new byte[len];
            local.get(data);
            return new String(data);
        }

        public Collection<Item> getInstances() {
            ByteBuffer local = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            local.position(local.getInt() + local.position());
            int count = local.getInt();
            ArrayList<Item> list = new ArrayList<Item>(count);
            while (--count >= 0) {
                list.add(BinaryHeapModel.this.getItem(local.getInt()));
            }
            return list;
        }

        private int getNextOffset() {
            ByteBuffer local = ((ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset)).slice();
            int strLen = local.getInt();
            return this.offset + 4 + strLen + 4 + 4 * local.getInt(4 + strLen);
        }
    }

    public class HItem
    implements Item {
        int offset;

        private HItem(int offset) {
            this.offset = offset;
        }

        private ByteBuffer prepareBuffer() {
            return ((ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset)).slice();
        }

        @Override
        public String getType() {
            return BinaryHeapModel.this.getCls(this.prepareBuffer().getInt()).getClassName();
        }

        @Override
        public int getSize() {
            return this.prepareBuffer().getInt(4);
        }

        @Override
        public String getValue() {
            return "unknown";
        }

        @Override
        public Enumeration<Object> incomming() {
            ByteBuffer buff = this.prepareBuffer();
            buff.position(8);
            int out = buff.getInt();
            int inc = buff.getInt();
            buff.position(16 + 8 * out);
            Vector<Object> v = new Vector<Object>(inc);
            while (--inc >= 0) {
                int refOffset = buff.getInt();
                int objOffset = buff.getInt();
                if (objOffset != 0) {
                    v.add(BinaryHeapModel.this.getItem(objOffset));
                    continue;
                }
                v.add(new RefType(refOffset).getReferenceName());
            }
            return v.elements();
        }

        @Override
        public Enumeration<Item> outgoing() {
            ByteBuffer buff = this.prepareBuffer();
            int out = buff.getInt(8);
            buff.position(16);
            Vector<Item> v = new Vector<Item>(out);
            while (--out >= 0) {
                int refOffset = buff.getInt();
                int objOffset = buff.getInt();
                v.add(BinaryHeapModel.this.getItem(objOffset));
            }
            return v.elements();
        }

        public String toString() {
            return this.getType() + "@" + Integer.toHexString(this.getId());
        }

        @Override
        public int getId() {
            return this.offset;
        }

        private int getNextOffset() {
            ByteBuffer buff = this.prepareBuffer();
            return this.offset + 16 + 8 * buff.getInt(8) + 8 * buff.getInt(12);
        }
    }

    private class RefType {
        int offset;

        private RefType(int offset) {
            this.offset = offset;
        }

        public String getReferenceName() {
            ByteBuffer local = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            int len = local.getInt();
            byte[] data = new byte[len];
            local.get(data);
            return new String(data);
        }

        public boolean isStatic() {
            ByteBuffer local = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            local.position(local.getInt() + local.position());
            int instOffset = local.getInt();
            return instOffset != -1;
        }

        public Item getInstance() {
            ByteBuffer local = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            local.position(local.getInt() + local.position());
            int instOffset = local.getInt();
            if (instOffset > 0) {
                return BinaryHeapModel.this.getItem(instOffset);
            }
            return null;
        }

        private int getNextOffset() {
            ByteBuffer local = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            int strLen = local.getInt();
            return this.offset + 4 + strLen + 4;
        }
    }
}

