/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.VolumeBackupSchedule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateVolumeBackupPolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="destinationRegion")
    private final String destinationRegion;
    @JsonProperty(value="schedules")
    private final List<VolumeBackupSchedule> schedules;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "displayName", "destinationRegion", "schedules", "definedTags", "freeformTags"})
    public CreateVolumeBackupPolicyDetails(String compartmentId, String displayName, String destinationRegion, List<VolumeBackupSchedule> schedules, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.destinationRegion = destinationRegion;
        this.schedules = schedules;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    public List<VolumeBackupSchedule> getSchedules() {
        return this.schedules;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateVolumeBackupPolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", destinationRegion=").append(String.valueOf(this.destinationRegion));
        sb.append(", schedules=").append(String.valueOf(this.schedules));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVolumeBackupPolicyDetails)) {
            return false;
        }
        CreateVolumeBackupPolicyDetails other = (CreateVolumeBackupPolicyDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.destinationRegion, other.destinationRegion) && Objects.equals(this.schedules, other.schedules) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.destinationRegion == null ? 43 : this.destinationRegion.hashCode());
        result = result * 59 + (this.schedules == null ? 43 : this.schedules.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="destinationRegion")
        private String destinationRegion;
        @JsonProperty(value="schedules")
        private List<VolumeBackupSchedule> schedules;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            this.__explicitlySet__.add("destinationRegion");
            return this;
        }

        public Builder schedules(List<VolumeBackupSchedule> schedules) {
            this.schedules = schedules;
            this.__explicitlySet__.add("schedules");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public CreateVolumeBackupPolicyDetails build() {
            CreateVolumeBackupPolicyDetails model = new CreateVolumeBackupPolicyDetails(this.compartmentId, this.displayName, this.destinationRegion, this.schedules, this.definedTags, this.freeformTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateVolumeBackupPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("destinationRegion")) {
                this.destinationRegion(model.getDestinationRegion());
            }
            if (model.wasPropertyExplicitlySet("schedules")) {
                this.schedules(model.getSchedules());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            return this;
        }
    }
}

