/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.commands;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.phpunit.commands.Bundle;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptions;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferences;
import org.netbeans.modules.php.phpunit.ui.UiUtils;
import org.netbeans.modules.php.phpunit.util.PhpUnitUtils;
import org.netbeans.modules.php.phpunit.util.VersionOutputProcessorFactory;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.InputOutput;

public final class SkeletonGenerator {
    private static final Logger LOGGER = Logger.getLogger(SkeletonGenerator.class.getName());
    public static final String SCRIPT_NAME = "phpunit-skelgen";
    public static final String SCRIPT_NAME_LONG = "phpunit-skelgen" + FileUtils.getScriptExtension((boolean)true);
    public static final String SCRIPT_NAME_PHAR = "phpunit-skelgen.phar";
    static final String VERSION_PATTERN = "(?:phpunit\\-skelgen|PHPUnit\\s+Skeleton\\s+Generator)\\s+(\\d+(?:\\.\\d+)*)";
    private static volatile String version;
    private static final String VERSION_PARAM = "--version";
    private static final String BOOTSTRAP_PARAM_V1 = "--bootstrap";
    private static final String TEST_PARAM = "--test";
    private static final String SEPARATOR_PARAM = "--";
    private static final String ANSI_PARAM = "--ansi";
    private static final String GENERATE_TEST_PARAM = "generate-test";
    private static final String BOOTSTRAP_PARAM_V2 = "--bootstrap=%s";
    private final String skelGenPath;

    private SkeletonGenerator(String skelGenPath) {
        assert (skelGenPath != null);
        this.skelGenPath = skelGenPath;
    }

    public static SkeletonGenerator getDefault() throws InvalidPhpExecutableException {
        String script = PhpUnitOptions.getInstance().getSkeletonGeneratorPath();
        String error = SkeletonGenerator.validate(script);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new SkeletonGenerator(script);
    }

    public static String validate(String command) {
        return PhpExecutableValidator.validateCommand((String)command, (String)Bundle.SkeletonGenerator_script_label());
    }

    public static void resetVersion() {
        version = null;
    }

    @CheckForNull
    private static String getVersion() {
        block8: {
            assert (!EventQueue.isDispatchThread());
            if (version != null) {
                return version;
            }
            VersionOutputProcessorFactory versionOutputProcessorFactory = new VersionOutputProcessorFactory(VERSION_PATTERN);
            try {
                SkeletonGenerator skeletonGenerator = SkeletonGenerator.getDefault();
                skeletonGenerator.getExecutable("Skeleton Generator version", PhpUnitUtils.TMP_DIR).additionalParameters(Collections.singletonList(VERSION_PARAM)).runAndWait(SkeletonGenerator.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)versionOutputProcessorFactory, "Detecting Skeleton Generator version...");
                String detectedVersion = versionOutputProcessorFactory.getVersion();
                if (detectedVersion != null) {
                    version = detectedVersion;
                    return version;
                }
            }
            catch (CancellationException ex) {
                assert (false);
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (InvalidPhpExecutableException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return null;
    }

    @CheckForNull
    public FileObject generateTest(PhpModule phpModule, FileObject sourceClassFile, String sourceClassName) throws ExecutionException {
        FileObject sourceDir = phpModule.getSourceDirectory();
        assert (sourceDir != null);
        FileObject testDir = phpModule.getTestDirectory(sourceClassFile);
        assert (testDir != null);
        FileObject commonRoot = FileUtils.getCommonRoot((FileObject)sourceClassFile, (FileObject)testDir);
        if (commonRoot == null || !FileUtil.isParentOf((FileObject)sourceDir, (FileObject)commonRoot)) {
            commonRoot = sourceDir;
        }
        assert (commonRoot != null);
        String relativePath = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)commonRoot), (File)FileUtil.toFile((FileObject)sourceClassFile));
        assert (relativePath != null);
        assert (!relativePath.startsWith("../")) : "Unexpected relative path: " + relativePath + " for " + commonRoot + " and " + sourceClassFile;
        String relativeTestPath = relativePath.substring(0, relativePath.length() - sourceClassFile.getExt().length() - 1);
        File testFile = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)testDir), (String)PhpUnit.makeTestFile(relativeTestPath));
        FileObject testFo = FileUtil.toFileObject((File)testFile);
        if (testFo != null && testFo.isValid()) {
            return testFo;
        }
        if (!this.ensureTestFolderExists(testFile)) {
            return null;
        }
        String testClassName = PhpUnit.makeTestClass(sourceClassName);
        List<String> params = this.getParams(phpModule, sourceClassName, sourceClassFile, testClassName, testFile);
        PhpExecutable skelGen = this.getExecutable(phpModule, params);
        if (skelGen == null) {
            return null;
        }
        try {
            Integer status = skelGen.runAndWait(this.getDescriptor(), "Generating test...");
            if (status != null && status == 0) {
                FileUtil.refreshFor((File[])new File[]{testFile.getParentFile()});
                testFo = FileUtil.toFileObject((File)testFile);
                if (testFo == null) {
                    boolean testFileExists = testFile.exists();
                    LOGGER.log(testFileExists ? Level.WARNING : Level.INFO, "FileObject for generated test not found (java.io.File for test file exists: {0})", testFileExists);
                    return null;
                }
                return testFo;
            }
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Test creating cancelled", ex);
        }
        return null;
    }

    private List<String> getParams(PhpModule phpModule, String sourceClassName, FileObject sourceClassFile, String testClassName, File testFile) {
        String ver;
        ArrayList<String> params = new ArrayList<String>();
        String bootstrap = null;
        if (PhpUnitPreferences.isBootstrapEnabled(phpModule) && PhpUnitPreferences.isBootstrapForCreateTests(phpModule)) {
            bootstrap = PhpUnitPreferences.getBootstrapPath(phpModule);
        }
        if ((ver = SkeletonGenerator.getVersion()) != null && ver.startsWith("1.")) {
            if (bootstrap != null) {
                params.add(BOOTSTRAP_PARAM_V1);
                params.add(bootstrap);
            }
            params.add(TEST_PARAM);
            params.add(SEPARATOR_PARAM);
        } else {
            params.add(ANSI_PARAM);
            params.add(GENERATE_TEST_PARAM);
            if (bootstrap != null) {
                params.add(String.format(BOOTSTRAP_PARAM_V2, bootstrap));
            }
        }
        params.add(this.sanitizeClassName(sourceClassName));
        params.add(FileUtil.toFile((FileObject)sourceClassFile).getAbsolutePath());
        params.add(this.sanitizeClassName(testClassName));
        params.add(testFile.getAbsolutePath());
        return params;
    }

    @CheckForNull
    private PhpExecutable getExecutable(PhpModule phpModule, List<String> params) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            UiUtils.warnNoSources(phpModule.getDisplayName());
            return null;
        }
        return this.getExecutable(Bundle.SkeletonGenerator_run_title(phpModule.getDisplayName()), FileUtil.toFile((FileObject)sourceDirectory)).optionsSubcategory("FrameworksAndTools/PhpUnit").additionalParameters(params);
    }

    private PhpExecutable getExecutable(String title, File workDir) {
        return new PhpExecutable(this.skelGenPath).workDir(workDir).displayName(title);
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/PhpUnit").inputVisible(false);
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false);
    }

    private String sanitizeClassName(String className) {
        if (className.startsWith("\\")) {
            className = className.substring(1);
        }
        return className;
    }

    private boolean ensureTestFolderExists(File testClassFile) {
        File parent = testClassFile.getParentFile();
        if (!parent.isDirectory()) {
            if (!parent.mkdirs()) {
                return false;
            }
            FileUtil.refreshFor((File[])new File[]{parent});
        }
        return true;
    }
}

