/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.spi.actions.ContextAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

final class IndirectAction<T extends Lookup.Provider, R>
extends ContextAction<T> {
    final ContextAction<R> delegate;
    private final PCL pcl = new PCL();
    private final boolean all;

    public IndirectAction(Class<T> toLookupType, ContextAction<R> delegate, boolean all) {
        super(toLookupType);
        this.delegate = delegate;
        this.all = all;
    }

    @Override
    void internalAddNotify() {
        super.internalAddNotify();
        this.delegate.addPropertyChangeListener(this.pcl);
    }

    @Override
    void internalRemoveNotify() {
        super.internalRemoveNotify();
        this.delegate.removePropertyChangeListener(this.pcl);
    }

    @Override
    public Object getValue(String key) {
        Object result = super.getValue(key);
        if (result == null) {
            result = this.delegate.getValue(key);
        }
        return result;
    }

    private Lookup delegateLookup(Collection<? extends T> targets) {
        LinkedList<Lookup> lookups = new LinkedList<Lookup>();
        for (Lookup.Provider provider : targets) {
            Lookup lkp = provider.getLookup();
            if (this.all && lkp.lookupResult(this.delegate.type).allItems().size() == 0) {
                return Lookup.EMPTY;
            }
            lookups.add(provider.getLookup());
        }
        ProxyLookup proxy = new ProxyLookup(lookups.toArray(new Lookup[0]));
        return proxy;
    }

    @Override
    protected void actionPerformed(Collection<? extends T> targets) {
        Action delegateStub = this.delegate.createContextAwareInstance(this.delegateLookup(targets));
        delegateStub.actionPerformed(null);
    }

    @Override
    protected boolean isEnabled(Collection<? extends T> targets) {
        Action delegateStub = this.delegate.createContextAwareInstance(this.delegateLookup(targets));
        return delegateStub.isEnabled();
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o.getClass() == IndirectAction.class && this.delegate.equals(((IndirectAction)o).delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private final class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndirectAction.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

