/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ClassPathListCellRenderer
extends DefaultListCellRenderer {
    private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
    private static final Pattern UNKNOWN_FILE_REFERENCE = Pattern.compile("\\$\\{([^${}]+)\\}");
    private static Icon ICON_FOLDER = null;
    private static Icon ICON_BROKEN_JAR;
    private static Icon ICON_BROKEN_LIBRARY;
    private static Icon ICON_BROKEN_ARTIFACT;
    private PropertyEvaluator evaluator;
    private FileObject projectFolder;
    private static final Map<String, String> WELL_KNOWN_PATHS_NAMES;

    private ClassPathListCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        this.evaluator = evaluator;
        this.projectFolder = projectFolder;
    }

    public static ListCellRenderer createClassPathListRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        return new ClassPathListCellRenderer(evaluator, projectFolder);
    }

    public static TableCellRenderer createClassPathTableRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        return new ClassPathTableCellRenderer(evaluator, projectFolder);
    }

    public static TreeCellRenderer createClassPathTreeRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        return new ClassPathTreeCellRenderer(evaluator, projectFolder);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (" ".equals(value)) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        if (value != null) assert (value instanceof ClassPathSupport.Item) : value.getClass().toString();
        ClassPathSupport.Item item = (ClassPathSupport.Item)value;
        super.getListCellRendererComponent((JList<?>)list, this.getDisplayName(item), index, isSelected, cellHasFocus);
        this.setIcon(ClassPathListCellRenderer.getIcon(item));
        this.setToolTipText(this.getToolTipText(item));
        return this;
    }

    private String getDisplayName(ClassPathSupport.Item item) {
        switch (item.getType()) {
            case 1: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_LIBRARY", (Object)Integer.toHexString(ClassPathListCellRenderer.getErrorForeground().getRGB() & 0xFFFFFF), (Object)ClassPathListCellRenderer.toHtml(this.getLibraryName(item)));
                }
                return item.getLibrary().getDisplayName();
            }
            case 3: {
                String name = WELL_KNOWN_PATHS_NAMES.get(CommonProjectUtils.getAntPropertyName(item.getReference()));
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_FILE", (Object)Integer.toHexString(ClassPathListCellRenderer.getErrorForeground().getRGB() & 0xFFFFFF), (Object)ClassPathListCellRenderer.toHtml(name == null ? CommonProjectUtils.getAntPropertyName(item.getReference()) : name));
                }
                return name == null ? CommonProjectUtils.getAntPropertyName(item.getReference()) : name;
            }
            case 2: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_PROJECT", (Object)Integer.toHexString(ClassPathListCellRenderer.getErrorForeground().getRGB() & 0xFFFFFF), (Object)ClassPathListCellRenderer.toHtml(this.getProjectName(item)));
                }
                Project p = item.getArtifact().getProject();
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                String projectName = pi.getDisplayName();
                return MessageFormat.format(NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"MSG_ProjectArtifactFormat"), projectName, item.getArtifactURI().toString());
            }
            case 0: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_FILE", (Object)Integer.toHexString(ClassPathListCellRenderer.getErrorForeground().getRGB() & 0xFFFFFF), (Object)ClassPathListCellRenderer.toHtml(this.getFileRefName(item)));
                }
                if (item.getVariableBasedProperty() != null) {
                    String s = item.getVariableBasedProperty();
                    return s.substring(6, s.indexOf("}")) + s.substring(s.indexOf("}") + 1);
                }
                return item.getFilePath();
            }
        }
        return item.getReference();
    }

    @NonNull
    private static Color getErrorForeground() {
        Color result = UIManager.getDefaults().getColor("nb.errorForeground");
        if (result == null) {
            result = Color.RED;
        }
        return result;
    }

    static Icon getIcon(ClassPathSupport.Item item) {
        switch (item.getType()) {
            case 1: {
                if (item.isBroken()) {
                    if (ICON_BROKEN_LIBRARY == null) {
                        ICON_BROKEN_LIBRARY = ImageUtilities.mergeIcons((Icon)ProjectProperties.ICON_LIBRARY, (Icon)ProjectProperties.ICON_BROKEN_BADGE, (int)7, (int)7);
                    }
                    return ICON_BROKEN_LIBRARY;
                }
                return ProjectProperties.ICON_LIBRARY;
            }
            case 2: {
                if (item.isBroken()) {
                    if (ICON_BROKEN_ARTIFACT == null) {
                        ICON_BROKEN_ARTIFACT = ImageUtilities.mergeIcons((Icon)ProjectProperties.ICON_ARTIFACT, (Icon)ProjectProperties.ICON_BROKEN_BADGE, (int)7, (int)7);
                    }
                    return ICON_BROKEN_ARTIFACT;
                }
                Project p = item.getArtifact().getProject();
                if (p != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    return pi.getIcon();
                }
                return ProjectProperties.ICON_ARTIFACT;
            }
            case 0: {
                Icon icn;
                if (item.isBroken()) {
                    if (ICON_BROKEN_JAR == null) {
                        ICON_BROKEN_JAR = ImageUtilities.mergeIcons((Icon)ProjectProperties.ICON_JAR, (Icon)ProjectProperties.ICON_BROKEN_BADGE, (int)7, (int)7);
                    }
                    return ICON_BROKEN_JAR;
                }
                File file = item.getResolvedFile();
                Icon icon = icn = file.isDirectory() ? ClassPathListCellRenderer.getFolderIcon() : ProjectProperties.ICON_JAR;
                if (item.getSourceFilePath() != null) {
                    icn = ImageUtilities.mergeIcons((Icon)icn, (Icon)ProjectProperties.ICON_SOURCE_BADGE, (int)8, (int)8);
                }
                if (item.getJavadocFilePath() != null) {
                    icn = ImageUtilities.mergeIcons((Icon)icn, (Icon)ProjectProperties.ICON_JAVADOC_BADGE, (int)8, (int)0);
                }
                return icn;
            }
            case 3: {
                return ProjectProperties.ICON_CLASSPATH;
            }
        }
        return null;
    }

    private String getToolTipText(ClassPathSupport.Item item) {
        if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
            return this.evaluator.evaluate(item.getReference());
        }
        switch (item.getType()) {
            case 0: {
                File f = item.getResolvedFile();
                if (f.getPath().equals(item.getFilePath()) && item.getVariableBasedProperty() == null) break;
                return f.getPath();
            }
            case 2: {
                FileObject projDir;
                AntArtifact artifact = item.getArtifact();
                if (artifact == null || (projDir = artifact.getProject().getProjectDirectory()) == null) break;
                return FileUtil.getFileDisplayName((FileObject)projDir);
            }
        }
        return null;
    }

    private static Icon getFolderIcon() {
        if (ICON_FOLDER == null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
            ICON_FOLDER = ImageUtilities.image2Icon((Image)dataFolder.getNodeDelegate().getIcon(1));
        }
        return ICON_FOLDER;
    }

    private String getProjectName(ClassPathSupport.Item item) {
        String ID = item.getReference();
        return ID.substring(12, ID.indexOf(46, 12));
    }

    private String getLibraryName(ClassPathSupport.Item item) {
        String ID = item.getReference();
        if (ID == null) {
            if (item.getLibrary() != null) {
                return item.getLibrary().getName();
            }
            return "XXX";
        }
        return ID.substring(7, ID.indexOf(".classpath"));
    }

    private String getFileRefName(ClassPathSupport.Item item) {
        String ID = item.getReference();
        Matcher m = FOREIGN_PLAIN_FILE_REFERENCE.matcher(ID);
        if (m.matches()) {
            return m.group(1);
        }
        m = UNKNOWN_FILE_REFERENCE.matcher(ID);
        if (m.matches()) {
            return m.group(1);
        }
        return ID;
    }

    private static String toHtml(@NonNull String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                sb.append("&nbsp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        WELL_KNOWN_PATHS_NAMES = new HashMap<String, String>();
        WELL_KNOWN_PATHS_NAMES.put("javac.modulepath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacModulepath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("javac.test.modulepath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacTestModulepath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacTestClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.modulepath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunModulepath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.test.modulepath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunTestModulepath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunTestClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildClassesDir_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.modules.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildModulesDir_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.test.modules.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildTestModulesDir_DisplayName"));
    }

    static class ClassPathTableCellRenderer
    extends DefaultTableCellRenderer {
        private ClassPathListCellRenderer renderer;

        ClassPathTableCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
            this.renderer = new ClassPathListCellRenderer(evaluator, projectFolder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                assert (value instanceof ClassPathSupport.Item) : value.getClass().toString();
                ClassPathSupport.Item item = (ClassPathSupport.Item)value;
                this.setIcon(ClassPathListCellRenderer.getIcon(item));
                this.setToolTipText(this.renderer.getToolTipText(item));
                return super.getTableCellRendererComponent(table, this.renderer.getDisplayName(item), isSelected, false, row, column);
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, null, isSelected, false, row, column);
        }
    }

    static class ClassPathTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ClassPathListCellRenderer renderer;

        ClassPathTreeCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
            this.renderer = new ClassPathListCellRenderer(evaluator, projectFolder);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj;
            if (value instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ClassPathSupport.Item) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)obj;
                super.getTreeCellRendererComponent(tree, this.renderer.getDisplayName(item), sel, expanded, leaf, row, false);
                this.setIcon(ClassPathListCellRenderer.getIcon(item));
                this.setToolTipText(this.renderer.getToolTipText(item));
                return this;
            }
            super.getTreeCellRendererComponent(tree, null, sel, expanded, leaf, row, false);
            this.setIcon(null);
            return this;
        }
    }
}

