/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.xtext.ide.server.IMultiRootWorkspaceConfigFactory;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.WorkspaceConfig;

public class MultiRootWorkspaceConfigFactory
implements IMultiRootWorkspaceConfigFactory {
    @Inject
    UriExtensions uriExtensions;

    @Override
    public IWorkspaceConfig getWorkspaceConfig(List<WorkspaceFolder> workspaceFolders) {
        WorkspaceConfig workspaceConfig = new WorkspaceConfig(new IProjectConfig[0]);
        HashSet<String> existingProjectNames = new HashSet<String>();
        for (WorkspaceFolder workspaceFolder : workspaceFolders) {
            this.addProjectsForWorkspaceFolder(workspaceConfig, workspaceFolder, existingProjectNames);
        }
        return workspaceConfig;
    }

    protected void addProjectsForWorkspaceFolder(WorkspaceConfig workspaceConfig, WorkspaceFolder workspaceFolder, Set<String> existingNames) {
        if (workspaceFolder != null && workspaceFolder.getUri() != null) {
            FileProjectConfig project = new FileProjectConfig(this.uriExtensions.toUri(workspaceFolder.getUri()), this.getUniqueProjectName(workspaceFolder.getName(), existingNames));
            project.addSourceFolder(".");
            workspaceConfig.addProject((IProjectConfig)project);
        }
    }

    protected String getUniqueProjectName(String proposal, Set<String> existingNames) {
        if (existingNames.add(proposal)) {
            return proposal;
        }
        int count = 1;
        while (!existingNames.add(proposal + count)) {
            ++count;
        }
        return proposal + count;
    }

    protected UriExtensions getUriExtensions() {
        return this.uriExtensions;
    }
}

