/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.Arrays;
import java.util.Date;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;

public class Random
extends Bytes {
    public Random() {
        this(Random.createBytes());
    }

    public Random(byte[] randomBytes) {
        super(randomBytes);
        if (randomBytes.length != 32) {
            throw new IllegalArgumentException("Random bytes array's length must be 32");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        byte[] randomBytes = this.getBytes();
        byte b0 = randomBytes[0];
        byte b1 = randomBytes[1];
        byte b2 = randomBytes[2];
        byte b3 = randomBytes[3];
        long gmtUnixTime = (0xFF & b0) << 24 | (0xFF & b1) << 16 | (0xFF & b2) << 8 | 0xFF & b3;
        Date date = new Date(gmtUnixTime * 1000L);
        sb.append("\t\t\tGMT Unix Time: ").append(date).append(StringUtil.lineSeparator());
        byte[] rand = Arrays.copyOfRange(randomBytes, 4, 32);
        sb.append("\t\t\tRandom Bytes: ").append(StringUtil.byteArray2Hex((byte[])rand)).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public static byte[] createBytes() {
        byte[] randomBytes = Bytes.createBytes((java.util.Random)RandomManager.currentSecureRandom(), (int)32);
        int gmtUnixTime = (int)(System.currentTimeMillis() / 1000L);
        randomBytes[0] = (byte)(gmtUnixTime >> 24);
        randomBytes[1] = (byte)(gmtUnixTime >> 16);
        randomBytes[2] = (byte)(gmtUnixTime >> 8);
        randomBytes[3] = (byte)gmtUnixTime;
        return randomBytes;
    }
}

