/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.io.PrintStream;
import org.apache.karaf.log.command.DisplayLog;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Command(scope="log", name="tail", description="Continuously display log entries. Use ctrl-c to quit this command")
@Service
public class LogTail
extends DisplayLog {
    @Reference
    Session session;
    @Reference
    BundleContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() throws Exception {
        if (this.entries == 0) {
            this.entries = 50;
        }
        int minLevel = LogTail.getMinLevel(this.level);
        PrintStream out = this.session.getConsole();
        this.display(out, minLevel);
        out.flush();
        PaxAppender appender = event -> this.printEvent(out, event, minLevel);
        tracker.open();
        try (LogServiceTracker tracker = new LogServiceTracker(this.context, LogService.class, null, appender);){
            LogTail logTail = this;
            synchronized (logTail) {
                this.wait();
            }
            out.println("Stopping tail as log.core bundle was stopped.");
        }
        out.println();
        return null;
    }

    private synchronized void stopTail() {
        this.notifyAll();
    }

    private final class LogServiceTracker
    extends ServiceTracker<LogService, LogService> {
        private static final String SSHD_LOGGER = "org.apache.sshd";
        private final PaxAppender appender;
        private String sshdLoggerLevel;

        private LogServiceTracker(BundleContext context, Class<LogService> clazz, ServiceTrackerCustomizer<LogService, LogService> customizer, PaxAppender appender) {
            super(context, clazz, customizer);
            this.appender = appender;
        }

        public LogService addingService(ServiceReference<LogService> reference) {
            LogService service = (LogService)super.addingService(reference);
            this.sshdLoggerLevel = service.getLevel(SSHD_LOGGER).get(SSHD_LOGGER);
            service.setLevel(SSHD_LOGGER, "ERROR");
            service.addAppender(this.appender);
            return service;
        }

        public void removedService(ServiceReference<LogService> reference, LogService service) {
            if (this.sshdLoggerLevel != null) {
                service.setLevel(SSHD_LOGGER, this.sshdLoggerLevel);
            }
            service.removeAppender(this.appender);
            LogTail.this.stopTail();
        }
    }
}

