/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.ErrorCode;
import com.gitlab.pdftk_java.InputPdf;
import com.gitlab.pdftk_java.PageRef;
import com.gitlab.pdftk_java.PdfBookmark;
import com.gitlab.pdftk_java.TK_Session;
import com.gitlab.pdftk_java.bookmarks;
import com.gitlab.pdftk_java.com.lowagie.text.Document;
import com.gitlab.pdftk_java.com.lowagie.text.DocumentException;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfCopy;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfDictionary;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfImportedPage;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfIndirectReference;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfName;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfNumber;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfObject;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfReader;
import com.gitlab.pdftk_java.filter;
import com.gitlab.pdftk_java.keyword;
import com.gitlab.pdftk_java.pdftk;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class cat {
    TK_Session session;
    String m_output_filename;
    ArrayList<InputPdf> m_input_pdf;
    ArrayList<ArrayList<PageRef>> m_page_seq;
    boolean m_output_keep_first_id_b;
    boolean m_output_keep_final_id_b;

    cat(TK_Session session) {
        this.session = session;
        this.m_output_filename = session.m_output_filename;
        this.m_input_pdf = session.m_input_pdf;
        this.m_page_seq = session.m_page_seq;
        this.m_output_keep_first_id_b = session.m_output_keep_first_id_b;
        this.m_output_keep_final_id_b = session.m_output_keep_final_id_b;
    }

    static char GetPdfVersionChar(PdfObject version_p) {
        int version_cc = 52;
        if (version_p == null) {
            return (char)version_cc;
        }
        if (!version_p.isName()) {
            try {
                version_p = new PdfName(version_p.toString());
            }
            catch (Exception e) {
                return (char)version_cc;
            }
        }
        if (version_p.equals(PdfName.VERSION_1_4)) {
            version_cc = 52;
        } else if (version_p.equals(PdfName.VERSION_1_5)) {
            version_cc = 53;
        } else if (version_p.equals(PdfName.VERSION_1_6)) {
            version_cc = 54;
        } else if (version_p.equals(PdfName.VERSION_1_7)) {
            version_cc = 55;
        } else if (version_p.equals(PdfName.VERSION_1_3)) {
            version_cc = 51;
        } else if (version_p.equals(PdfName.VERSION_1_2)) {
            version_cc = 50;
        } else if (version_p.equals(PdfName.VERSION_1_1)) {
            version_cc = 49;
        } else if (version_p.equals(PdfName.VERSION_1_0)) {
            version_cc = 48;
        }
        return (char)version_cc;
    }

    ErrorCode create_output_page(PdfCopy writer_p, PageRef page_ref, int output_page_count) {
        ErrorCode ret_val = ErrorCode.NO_ERROR;
        if (page_ref.m_input_pdf_index < this.m_input_pdf.size()) {
            InputPdf page_pdf = this.m_input_pdf.get(page_ref.m_input_pdf_index);
            if (this.session.m_verbose_reporting_b) {
                System.out.print("   Adding page " + page_ref.m_page_num + " X" + (Object)((Object)page_ref.m_page_rot) + "X ");
                System.out.println(" from " + page_pdf.m_filename);
            }
            PdfReader input_reader_p = null;
            for (InputPdf.PagesReader mt : page_pdf.m_readers) {
                if (!mt.first.contains(page_ref.m_page_num)) continue;
                input_reader_p = mt.second;
                mt.first.remove(page_ref.m_page_num);
                break;
            }
            if (input_reader_p != null) {
                if (this.session.m_output_uncompress_b) {
                    filter.add_mark_to_page(input_reader_p, page_ref.m_page_num, output_page_count + 1);
                } else if (this.session.m_output_compress_b) {
                    filter.remove_mark_from_page(input_reader_p, page_ref.m_page_num);
                }
                TK_Session.apply_rotation_to_page(input_reader_p, page_ref.m_page_num, page_ref.m_page_rot.value, page_ref.m_page_abs);
                try {
                    PdfImportedPage page_p = writer_p.getImportedPage(input_reader_p, page_ref.m_page_num);
                    try {
                        writer_p.addPage(page_p);
                    }
                    catch (DocumentException e) {
                        System.err.print("Internal Error: addPage() failed for: ");
                        System.err.println(page_ref.m_page_num + " in file: " + page_pdf.m_filename);
                        ret_val = ErrorCode.BUG;
                    }
                }
                catch (IOException e) {
                    System.err.print("Internal Error: getImportedPage() failed for: ");
                    System.err.println(page_ref.m_page_num + " in file: " + page_pdf.m_filename);
                    ret_val = ErrorCode.BUG;
                }
            } else {
                System.err.print("Internal Error: no reader found for page: ");
                System.err.println(page_ref.m_page_num + " in file: " + page_pdf.m_filename);
                ret_val = ErrorCode.BUG;
            }
        } else {
            System.err.println("Internal Error: Unable to find handle in m_input_pdf.");
            ret_val = ErrorCode.BUG;
        }
        return ret_val;
    }

    /*
     * WARNING - void declaration
     */
    ErrorCode create_output_cat() throws DocumentException, IOException {
        Document output_doc_p = new Document();
        OutputStream ofs_p = pdftk.get_output_stream(this.m_output_filename, this.session.m_ask_about_warnings_b);
        if (ofs_p == null) {
            return ErrorCode.ERROR;
        }
        PdfCopy writer_p = new PdfCopy(output_doc_p, ofs_p);
        output_doc_p.addCreator("pdftk-java 3.3.3");
        char max_version_cc = this.session.prepare_writer(writer_p);
        if (this.m_output_keep_first_id_b || this.m_output_keep_final_id_b) {
            PdfReader input_reader_p = this.m_output_keep_first_id_b ? this.m_input_pdf.get((int)0).m_readers.get((int)0).second : this.m_input_pdf.get((int)(this.m_input_pdf.size() - 1)).m_readers.get((int)0).second;
            PdfDictionary trailer_p = input_reader_p.getTrailer();
            PdfObject file_id_p = PdfReader.getPdfObject(trailer_p.get(PdfName.ID));
            if (file_id_p != null && file_id_p.isArray()) {
                writer_p.setFileID(file_id_p);
            }
        }
        HashMap<PdfName, PdfName> ext_base_versions = new HashMap<PdfName, PdfName>();
        HashMap<PdfName, Integer> ext_levels = new HashMap<PdfName, Integer>();
        for (InputPdf it : this.m_input_pdf) {
            PdfDictionary pdfDictionary;
            PdfReader reader_p = it.m_readers.get((int)0).second;
            if (max_version_cc < reader_p.getPdfVersion()) {
                max_version_cc = reader_p.getPdfVersion();
            }
            if ((pdfDictionary = reader_p.getCatalog()).contains(PdfName.VERSION)) {
                PdfObject version_p = PdfReader.getPdfObject(pdfDictionary.get(PdfName.VERSION));
                char version_cc = cat.GetPdfVersionChar(version_p);
                if (max_version_cc < version_cc) {
                    max_version_cc = version_cc;
                }
            }
            if (!pdfDictionary.contains(PdfName.EXTENSIONS)) continue;
            PdfObject extensions_po = PdfReader.getPdfObject(pdfDictionary.get(PdfName.EXTENSIONS));
            if (extensions_po == null || !extensions_po.isDictionary()) continue;
            PdfDictionary extensions_p = (PdfDictionary)extensions_po;
            Set keys_p = extensions_p.getKeys();
            for (PdfObject kit : keys_p) {
                PdfDictionary dev_exts_p;
                PdfObject dev_exts_po;
                PdfObject developer_po = PdfReader.getPdfObject(kit);
                PdfName developer_p = null;
                if (developer_po.isName()) {
                    developer_p = (PdfName)developer_po;
                } else {
                    try {
                        developer_p = new PdfName(developer_po.toString());
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if ((dev_exts_po = PdfReader.getPdfObject(extensions_p.get(developer_p))) == null || !dev_exts_po.isDictionary() || !(dev_exts_p = (PdfDictionary)dev_exts_po).contains(PdfName.BASEVERSION) || !dev_exts_p.contains(PdfName.EXTENSIONLEVEL)) continue;
                PdfObject base_version_po = PdfReader.getPdfObject(dev_exts_p.get(PdfName.BASEVERSION));
                PdfName base_version_p = null;
                if (!base_version_po.isName()) {
                    try {
                        base_version_p = new PdfName(base_version_po.toString());
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                PdfObject ext_level_po = PdfReader.getPdfObject(dev_exts_p.get(PdfName.EXTENSIONLEVEL));
                Integer ext_level_i = null;
                if (ext_level_po.isNumber()) {
                    ext_level_i = ((PdfNumber)ext_level_po).intValue();
                } else {
                    try {
                        ext_level_i = Integer.valueOf(ext_level_i.toString());
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (!ext_base_versions.containsKey(developer_p) || cat.GetPdfVersionChar((PdfObject)ext_base_versions.get(developer_p)) < cat.GetPdfVersionChar(base_version_po)) {
                    ext_base_versions.put(developer_p, base_version_p);
                    ext_levels.put(developer_p, ext_level_i);
                    continue;
                }
                if (cat.GetPdfVersionChar((PdfObject)ext_base_versions.get(developer_p)) != cat.GetPdfVersionChar(base_version_po) || (Integer)ext_levels.get(developer_p) >= ext_level_i) continue;
                ext_levels.put(developer_p, ext_level_i);
            }
        }
        writer_p.setPdfVersion(max_version_cc);
        output_doc_p.open();
        if (!ext_base_versions.isEmpty()) {
            PdfDictionary extensions_dict_p = new PdfDictionary();
            PdfIndirectReference extensions_ref_p = writer_p.getPdfIndirectReference();
            for (Map.Entry entry : ext_base_versions.entrySet()) {
                PdfDictionary ext_dict_p = new PdfDictionary();
                ext_dict_p.put(PdfName.BASEVERSION, (PdfObject)entry.getValue());
                ext_dict_p.put(PdfName.EXTENSIONLEVEL, new PdfNumber((Integer)ext_levels.get(entry.getKey())));
                extensions_dict_p.put((PdfName)entry.getKey(), ext_dict_p);
            }
            writer_p.addToBody((PdfObject)extensions_dict_p, extensions_ref_p);
            writer_p.setExtensions(extensions_ref_p);
        }
        if (this.session.m_operation == keyword.shuffle_k) {
            int max_seq_length = 0;
            for (ArrayList<PageRef> jt : this.m_page_seq) {
                max_seq_length = max_seq_length < jt.size() ? jt.size() : max_seq_length;
            }
            int output_page_count = 0;
            for (int ii = 0; ii < max_seq_length; ++ii) {
                for (ArrayList<PageRef> jt : this.m_page_seq) {
                    if (ii >= jt.size()) continue;
                    ErrorCode ret_val = this.create_output_page(writer_p, jt.get(ii), output_page_count);
                    if (ret_val != ErrorCode.NO_ERROR) {
                        return ret_val;
                    }
                    ++output_page_count;
                }
            }
        } else {
            int output_page_count = 0;
            for (ArrayList<PageRef> jt : this.m_page_seq) {
                for (PageRef it : jt) {
                    ErrorCode ret_val = this.create_output_page(writer_p, it, output_page_count);
                    if (ret_val != ErrorCode.NO_ERROR) {
                        return ret_val;
                    }
                    ++output_page_count;
                }
            }
            if (this.session.m_cat_full_pdfs_b) {
                void var10_22;
                PdfDictionary output_outlines_p = new PdfDictionary(PdfName.OUTLINES);
                PdfIndirectReference output_outlines_ref_p = writer_p.getPdfIndirectReference();
                Object var10_21 = null;
                PdfIndirectReference after_child_ref_p = null;
                int page_count = 1;
                int num_bookmarks_total = 0;
                for (ArrayList<PageRef> jt : this.m_page_seq) {
                    PdfReader reader_p = this.m_input_pdf.get((int)jt.get((int)0).m_input_pdf_index).m_readers.get((int)0).second;
                    long reader_page_count = this.m_input_pdf.get((int)jt.get((int)0).m_input_pdf_index).m_num_pages;
                    PdfDictionary catalog_p = reader_p.getCatalog();
                    PdfObject outlines_p = PdfReader.getPdfObject(catalog_p.get(PdfName.OUTLINES));
                    if (outlines_p != null && outlines_p.isDictionary()) {
                        ArrayList<PdfBookmark> bookmark_data;
                        int rr;
                        PdfObject top_outline_p = PdfReader.getPdfObject(((PdfDictionary)outlines_p).get(PdfName.FIRST));
                        if (top_outline_p != null && top_outline_p.isDictionary() && (rr = bookmarks.ReadOutlines(bookmark_data = new ArrayList<PdfBookmark>(), (PdfDictionary)top_outline_p, 0, reader_p, true)) == 0 && !bookmark_data.isEmpty()) {
                            bookmarks.BuildBookmarksState state = new bookmarks.BuildBookmarksState();
                            state.final_child_p = var10_22;
                            state.final_child_ref_p = after_child_ref_p;
                            state.num_bookmarks_total = num_bookmarks_total;
                            bookmarks.BuildBookmarks(writer_p, bookmark_data.listIterator(), output_outlines_p, output_outlines_ref_p, (PdfDictionary)var10_22, after_child_ref_p, 0, page_count - 1, 0, true, state);
                            PdfDictionary pdfDictionary = state.final_child_p;
                            after_child_ref_p = state.final_child_ref_p;
                            num_bookmarks_total = state.num_bookmarks_total;
                        }
                    }
                    page_count = (int)((long)page_count + reader_page_count);
                }
                if (num_bookmarks_total != 0) {
                    if (var10_22 != null && after_child_ref_p != null) {
                        writer_p.addToBody((PdfObject)var10_22, after_child_ref_p);
                    }
                    writer_p.addToBody((PdfObject)output_outlines_p, output_outlines_ref_p);
                    writer_p.setOutlines(output_outlines_ref_p);
                }
            }
        }
        output_doc_p.close();
        writer_p.close();
        return ErrorCode.NO_ERROR;
    }
}

