/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.AbstractReporter;
import dotty.tools.dotc.reporting.CodeAction;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.xsbt.PositionBridge;
import dotty.tools.xsbt.Problem;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.javaapi.CollectionConverters;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.Severity;

public final class DelegatingReporter
extends AbstractReporter {
    private Reporter delegate;
    private final Function<SourceFile, String> lookupVirtualFileId;

    public DelegatingReporter(Reporter reporter, Function<SourceFile, String> function) {
        this.delegate = reporter;
        this.lookupVirtualFileId = function;
    }

    public void dropDelegate() {
        this.delegate = null;
    }

    public void printSummary(Contexts.Context context) {
        this.delegate.printSummary();
    }

    public void doReport(Diagnostic diagnostic, Contexts.Context context) {
        Severity severity = DelegatingReporter.severityOf(diagnostic.level());
        Position position = this.positionOf(diagnostic.pos().nonInlined());
        Message message = diagnostic.msg();
        String string = Diagnostic.shouldExplain((Diagnostic)diagnostic, (Contexts.Context)context) && !message.explanation().isEmpty() ? message.message() + System.lineSeparator() + this.explanation(message, context) : message.message();
        String string2 = this.messageAndPos(diagnostic, context);
        String string3 = String.valueOf(message.errorId().errorNumber());
        List list = CollectionConverters.asJava((Seq)message.actions(context));
        Problem problem = new Problem(position, string, severity, string2, string3, list, this.lookupVirtualFileId);
        this.delegate.log((xsbti.Problem)problem);
    }

    public void reportBasicWarning(String string) {
        Position position = PositionBridge.noPosition;
        Severity severity = Severity.Warn;
        String string2 = "-1";
        List<CodeAction> list = Collections.emptyList();
        this.delegate.log((xsbti.Problem)new Problem(position, string, severity, string, string2, list, this.lookupVirtualFileId));
    }

    private static Severity severityOf(int n) {
        Severity severity;
        switch (n) {
            case 2: {
                severity = Severity.Error;
                break;
            }
            case 1: {
                severity = Severity.Warn;
                break;
            }
            case 0: {
                severity = Severity.Info;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Bad diagnostic level: %s", n));
            }
        }
        return severity;
    }

    private Position positionOf(SourcePosition sourcePosition) {
        if (sourcePosition.exists()) {
            return new PositionBridge(sourcePosition, this.lookupVirtualFileId.apply(sourcePosition.source()));
        }
        return PositionBridge.noPosition;
    }

    public HashMap<Tuple2<SourceFile, Integer>, Diagnostic> dotty$tools$dotc$reporting$UniqueMessagePositions$$positions() {
        return super.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions();
    }
}

