/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.MessageFilter;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.List;

public class Suppression {
    private final SourcePosition annotPos;
    private final List<MessageFilter> filters;
    private final int start;
    private final int end;
    private final boolean verbose;
    private int _used;

    public Suppression(SourcePosition annotPos, List<MessageFilter> filters, int start, int end, boolean verbose) {
        this.annotPos = annotPos;
        this.filters = filters;
        this.start = start;
        this.end = end;
        this.verbose = verbose;
        this._used = 0;
    }

    public SourcePosition annotPos() {
        return this.annotPos;
    }

    public List<MessageFilter> filters() {
        return this.filters;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public boolean used() {
        return this._used == 1;
    }

    public boolean superseded() {
        return this._used == 2;
    }

    public void markUsed() {
        this._used = 1;
    }

    public void markSuperseded() {
        this._used = 2;
    }

    public boolean matches(Diagnostic dia) {
        SourcePosition pos = dia.pos();
        return pos.exists() && this.start() <= pos.start() && pos.end() <= this.end() && this.filters().forall((Function1 & Serializable)_$4 -> _$4.matches(dia));
    }

    public String toString() {
        return new StringBuilder(18).append("Suppress in ").append(this.annotPos().source()).append(" ").append(this.start()).append("..").append(this.end()).append(" [").append(this.filters().mkString(", ")).append("]").toString();
    }
}

