/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlCache;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.InterpreterBase;
import org.apache.commons.jexl3.internal.introspection.MethodExecutor;
import org.apache.commons.jexl3.internal.introspection.MethodKey;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.JexlNode;

public final class Operator
implements JexlOperator.Uberspect {
    private static final String METHOD_IS_EMPTY = "isEmpty";
    private static final String METHOD_SIZE = "size";
    private static final String METHOD_CONTAINS = "contains";
    private static final String METHOD_STARTS_WITH = "startsWith";
    private static final String METHOD_ENDS_WITH = "endsWith";
    private static final Set<JexlOperator> CMP_OPS = EnumSet.of(JexlOperator.GT, JexlOperator.LT, JexlOperator.EQ, JexlOperator.GTE, JexlOperator.LTE);
    private static final Set<JexlOperator> POSTFIX_OPS = EnumSet.of(JexlOperator.GET_AND_INCREMENT, JexlOperator.GET_AND_DECREMENT);
    private final JexlUberspect uberspect;
    private final JexlArithmetic arithmetic;
    private final Set<JexlOperator> overloads;
    private final JexlArithmetic.Uberspect delegate;
    private volatile int caching = -1;

    public Operator(JexlUberspect theUberspect, JexlArithmetic theArithmetic) {
        this.uberspect = theUberspect;
        this.arithmetic = theArithmetic;
        this.overloads = Collections.emptySet();
        this.delegate = theUberspect.getArithmetic(theArithmetic);
    }

    public Operator(JexlUberspect theUberspect, JexlArithmetic theArithmetic, Set<JexlOperator> theOverloads) {
        this(theUberspect, theArithmetic, theOverloads, -1);
    }

    public Operator(JexlUberspect theUberspect, JexlArithmetic theArithmetic, Set<JexlOperator> theOverloads, int theCache) {
        this.uberspect = theUberspect;
        this.arithmetic = theArithmetic;
        this.overloads = theOverloads;
        this.delegate = null;
        this.caching = theCache;
    }

    @Override
    public JexlMethod getOperator(JexlOperator operator, Object ... args) {
        if (this.delegate != null) {
            return this.delegate.getOperator(operator, args);
        }
        if (this.overloads.contains((Object)operator) && args != null && args.length == operator.getArity()) {
            return this.uberspectOperator(this.arithmetic, operator, args);
        }
        return null;
    }

    @Override
    public boolean overloads(JexlOperator operator) {
        return this.delegate != null ? this.delegate.overloads(operator) : this.overloads.contains((Object)operator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCaching() {
        int c = this.caching;
        if (c < 0) {
            Operator operator = this;
            synchronized (operator) {
                c = this.caching;
                if (c < 0) {
                    JexlEngine jexl = JexlEngine.getThreadEngine();
                    c = jexl instanceof Engine && ((Engine)jexl).cache != null ? 1 : 0;
                    this.caching = c;
                }
            }
        }
        return c > 0;
    }

    private Object[] arguments(JexlOperator operator, Object ... args) {
        Object[] objectArray;
        if (operator.getArity() == 1 && args.length > 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = args[0];
        } else {
            objectArray = args;
        }
        return objectArray;
    }

    private Boolean booleanDuckCall(String methodName, Object left, Object right) throws Exception {
        JexlMethod vm = this.uberspect.getMethod(left, methodName, right);
        if (this.returnsBoolean(vm)) {
            return (Boolean)vm.invoke(left, right);
        }
        Object[] argv = new Object[]{right};
        if (this.arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = this.uberspect.getMethod(left, methodName, argv))) {
            return (Boolean)vm.invoke(left, argv);
        }
        return null;
    }

    private void controlNullOperands(JexlArithmetic arithmetic, JexlOperator operator, Object ... args) {
        for (Object arg : args) {
            if (arg != null) continue;
            if (!arithmetic.isStrict(operator)) break;
            throw new JexlArithmetic.NullOperand();
        }
    }

    private <T> T operatorError(JexlCache.Reference ref, JexlOperator operator, Throwable cause, T alt) {
        JexlNode node = ref instanceof JexlNode ? (JexlNode)ref : null;
        Engine engine = (Engine)JexlEngine.getThreadEngine();
        if (engine == null || engine.isStrict()) {
            throw new JexlException.Operator(node, operator.getOperatorSymbol(), cause);
        }
        if (engine.logger.isDebugEnabled()) {
            engine.logger.debug((Object)JexlException.operatorError(node, operator.getOperatorSymbol()), cause);
        }
        return alt;
    }

    private JexlMethod uberspectOperator(JexlArithmetic arithmetic, JexlOperator operator, Object ... args) {
        JexlMethod me = this.uberspect.getMethod(arithmetic, operator.getMethodName(), args);
        if (!(me instanceof MethodExecutor) || !JexlArithmetic.class.equals(((MethodExecutor)me).getMethod().getDeclaringClass())) {
            return me;
        }
        return null;
    }

    private boolean returnsBoolean(JexlMethod vm) {
        if (vm != null) {
            Class<?> rc = vm.getReturnType();
            return Boolean.TYPE.equals(rc) || Boolean.class.equals(rc);
        }
        return false;
    }

    private boolean returnsInteger(JexlMethod vm) {
        if (vm != null) {
            Class<?> rc = vm.getReturnType();
            return Integer.TYPE.equals(rc) || Integer.class.equals(rc);
        }
        return false;
    }

    @Override
    public Object empty(JexlCache.Reference node, Object object) {
        Object result;
        if (object == null) {
            return true;
        }
        Object object2 = result = this.overloads(JexlOperator.EMPTY) ? this.tryOverload(node, JexlOperator.EMPTY, object) : JexlEngine.TRY_FAILED;
        if (result == JexlEngine.TRY_FAILED && (result = this.arithmetic.isEmpty(object, null)) == null) {
            result = false;
            JexlMethod vm = this.uberspect.getMethod(object, METHOD_IS_EMPTY, InterpreterBase.EMPTY_PARAMS);
            if (this.returnsBoolean(vm)) {
                try {
                    result = vm.invoke(object, InterpreterBase.EMPTY_PARAMS);
                }
                catch (Exception any) {
                    return this.operatorError(node, JexlOperator.EMPTY, any, false);
                }
            }
        }
        return result;
    }

    @Override
    public Object size(JexlCache.Reference node, Object object) {
        JexlMethod vm;
        Object result;
        if (object == null) {
            return 0;
        }
        Object object2 = result = this.overloads(JexlOperator.SIZE) ? this.tryOverload(node, JexlOperator.SIZE, object) : JexlEngine.TRY_FAILED;
        if (result == JexlEngine.TRY_FAILED && (result = this.arithmetic.size(object, null)) == null && this.returnsInteger(vm = this.uberspect.getMethod(object, METHOD_SIZE, InterpreterBase.EMPTY_PARAMS))) {
            try {
                result = vm.invoke(object, InterpreterBase.EMPTY_PARAMS);
            }
            catch (Exception any) {
                return this.operatorError(node, JexlOperator.SIZE, any, 0);
            }
        }
        return result instanceof Number ? ((Number)result).intValue() : 0;
    }

    @Override
    public boolean contains(JexlCache.Reference node, JexlOperator operator, Object left, Object right) {
        try {
            Boolean duck;
            Boolean matched;
            Object result;
            Object object = result = this.overloads(JexlOperator.CONTAINS) ? this.tryOverload(node, JexlOperator.CONTAINS, left, right) : null;
            boolean contained = result instanceof Boolean ? (Boolean)result : ((matched = this.arithmetic.contains(left, right)) != null ? matched : ((duck = this.booleanDuckCall(METHOD_CONTAINS, left, right)) != null ? duck.booleanValue() : this.arithmetic.equals(left, right)));
            return JexlOperator.CONTAINS == operator == contained;
        }
        catch (Exception any) {
            return this.operatorError(node, operator, any, false);
        }
    }

    @Override
    public boolean startsWith(JexlCache.Reference node, JexlOperator operator, Object left, Object right) {
        try {
            Boolean duck;
            Boolean matched;
            Object result;
            Object object = result = this.overloads(JexlOperator.STARTSWITH) ? this.tryOverload(node, JexlOperator.STARTSWITH, left, right) : null;
            boolean starts = result instanceof Boolean ? (Boolean)result : ((matched = this.arithmetic.startsWith(left, right)) != null ? matched : ((duck = this.booleanDuckCall(METHOD_STARTS_WITH, left, right)) != null ? duck.booleanValue() : this.arithmetic.equals(left, right)));
            return JexlOperator.STARTSWITH == operator == starts;
        }
        catch (Exception any) {
            return this.operatorError(node, operator, any, false);
        }
    }

    @Override
    public boolean endsWith(JexlCache.Reference node, JexlOperator operator, Object left, Object right) {
        try {
            Boolean duck;
            Boolean matched;
            Object result;
            Object object = result = this.overloads(JexlOperator.ENDSWITH) ? this.tryOverload(node, JexlOperator.ENDSWITH, left, right) : null;
            boolean ends = result instanceof Boolean ? (Boolean)result : ((matched = this.arithmetic.endsWith(left, right)) != null ? matched : ((duck = this.booleanDuckCall(METHOD_ENDS_WITH, left, right)) != null ? duck.booleanValue() : this.arithmetic.equals(left, right)));
            return JexlOperator.ENDSWITH == operator == ends;
        }
        catch (Exception any) {
            return this.operatorError(node, operator, any, false);
        }
    }

    @Override
    public Object tryAssignOverload(JexlCache.Reference node, JexlOperator operator, Consumer<Object> assignFun, Object ... args) {
        if (args.length < operator.getArity()) {
            return JexlEngine.TRY_FAILED;
        }
        Object result = JexlEngine.TRY_FAILED;
        try {
            this.controlNullOperands(this.arithmetic, operator, args[0]);
            if (this.overloads(operator) && (result = this.tryOverload(node, operator, this.arguments(operator, args))) != JexlEngine.TRY_FAILED) {
                return result;
            }
            JexlOperator base = operator.getBaseOperator();
            if (base != null && this.overloads(base)) {
                result = this.tryOverload(node, base, this.arguments(base, args));
            }
            if (result == JexlEngine.TRY_FAILED) {
                result = this.performBaseOperation(operator, args);
            }
            if (result != JexlEngine.TRY_FAILED) {
                assignFun.accept(result);
                if (POSTFIX_OPS.contains((Object)operator)) {
                    result = args[0];
                }
            }
            return result;
        }
        catch (Exception any) {
            return this.operatorError(node, operator, any, JexlEngine.TRY_FAILED);
        }
    }

    private Object performBaseOperation(JexlOperator operator, Object ... args) {
        switch (operator) {
            case SELF_ADD: {
                return this.arithmetic.add(args[0], args[1]);
            }
            case SELF_SUBTRACT: {
                return this.arithmetic.subtract(args[0], args[1]);
            }
            case SELF_MULTIPLY: {
                return this.arithmetic.multiply(args[0], args[1]);
            }
            case SELF_DIVIDE: {
                return this.arithmetic.divide(args[0], args[1]);
            }
            case SELF_MOD: {
                return this.arithmetic.mod(args[0], args[1]);
            }
            case SELF_AND: {
                return this.arithmetic.and(args[0], args[1]);
            }
            case SELF_OR: {
                return this.arithmetic.or(args[0], args[1]);
            }
            case SELF_XOR: {
                return this.arithmetic.xor(args[0], args[1]);
            }
            case SELF_SHIFTLEFT: {
                return this.arithmetic.shiftLeft(args[0], args[1]);
            }
            case SELF_SHIFTRIGHT: {
                return this.arithmetic.shiftRight(args[0], args[1]);
            }
            case SELF_SHIFTRIGHTU: {
                return this.arithmetic.shiftRightUnsigned(args[0], args[1]);
            }
            case INCREMENT_AND_GET: 
            case GET_AND_INCREMENT: {
                return this.arithmetic.increment(args[0]);
            }
            case DECREMENT_AND_GET: 
            case GET_AND_DECREMENT: {
                return this.arithmetic.decrement(args[0]);
            }
        }
        throw new UnsupportedOperationException(operator.getOperatorSymbol());
    }

    @Override
    public Object tryOverload(JexlCache.Reference node, JexlOperator operator, Object ... args) {
        this.controlNullOperands(this.arithmetic, operator, args);
        try {
            return this.tryEval(this.isCaching() ? node : null, operator, args);
        }
        catch (Exception any) {
            return this.operatorError(node, operator, any, JexlEngine.TRY_FAILED);
        }
    }

    private Object tryEval(JexlCache.Reference node, JexlOperator operator, Object ... args) {
        JexlMethod vm;
        if (node != null) {
            Object cached = node.getCache();
            if (cached instanceof JexlMethod) {
                JexlMethod me = (JexlMethod)cached;
                Object eval = me.tryInvoke(operator.getMethodName(), this.arithmetic, args);
                if (!me.tryFailed(eval)) {
                    return eval;
                }
            } else if (cached instanceof MethodKey) {
                MethodKey cachedKey = (MethodKey)cached;
                MethodKey key = new MethodKey(operator.getMethodName(), args);
                if (key.equals(cachedKey)) {
                    return JexlEngine.TRY_FAILED;
                }
            }
        }
        if ((vm = this.getOperator(operator, args)) == null) {
            vm = this.getAlternateOverload(operator, args);
        }
        if (vm != null) {
            Object result = vm.tryInvoke(operator.getMethodName(), this.arithmetic, args);
            if (node != null && !vm.tryFailed(result)) {
                node.setCache(vm);
            }
            return result;
        }
        if (node != null) {
            MethodKey key = new MethodKey(operator.getMethodName(), args);
            node.setCache(key);
        }
        return JexlEngine.TRY_FAILED;
    }

    private JexlMethod getAlternateOverload(JexlOperator operator, Object ... args) {
        if (CMP_OPS.contains((Object)operator) && args.length == 2) {
            JexlMethod cmp = this.getOperator(JexlOperator.COMPARE, args);
            if (cmp != null) {
                return new CompareMethod(operator, cmp);
            }
            cmp = this.getOperator(JexlOperator.COMPARE, args[1], args[0]);
            if (cmp != null) {
                return new AntiCompareMethod(operator, cmp);
            }
        }
        return null;
    }

    private static class CompareMethod
    implements JexlMethod {
        protected final JexlOperator operator;
        protected final JexlMethod compare;

        CompareMethod(JexlOperator op, JexlMethod m) {
            this.operator = op;
            this.compare = m;
        }

        @Override
        public Class<?> getReturnType() {
            return Boolean.TYPE;
        }

        @Override
        public Object invoke(Object arithmetic, Object ... params) throws Exception {
            return this.operate((Integer)this.compare.invoke(arithmetic, params));
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean tryFailed(Object rval) {
            return rval == JexlEngine.TRY_FAILED;
        }

        @Override
        public Object tryInvoke(String name, Object arithmetic, Object ... params) throws JexlException.TryFailed {
            Object cmp = this.compare.tryInvoke(JexlOperator.COMPARE.getMethodName(), arithmetic, params);
            return cmp instanceof Integer ? Boolean.valueOf(this.operate((Integer)cmp)) : JexlEngine.TRY_FAILED;
        }

        protected boolean operate(int cmp) {
            switch (this.operator) {
                case EQ: {
                    return cmp == 0;
                }
                case LT: {
                    return cmp < 0;
                }
                case LTE: {
                    return cmp <= 0;
                }
                case GT: {
                    return cmp > 0;
                }
                case GTE: {
                    return cmp >= 0;
                }
            }
            throw new ArithmeticException("unexpected operator " + (Object)((Object)this.operator));
        }
    }

    private static class AntiCompareMethod
    extends CompareMethod {
        AntiCompareMethod(JexlOperator op, JexlMethod m) {
            super(op, m);
        }

        @Override
        public Object invoke(Object arithmetic, Object ... params) throws Exception {
            return this.operate(-((Integer)this.compare.invoke(arithmetic, params[1], params[0])).intValue());
        }

        @Override
        public Object tryInvoke(String name, Object arithmetic, Object ... params) throws JexlException.TryFailed {
            Object cmp = this.compare.tryInvoke(JexlOperator.COMPARE.getMethodName(), arithmetic, params[1], params[0]);
            return cmp instanceof Integer ? Boolean.valueOf(this.operate(-Integer.signum((Integer)cmp))) : JexlEngine.TRY_FAILED;
        }
    }
}

