/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonIntrospectionStrategy;
import org.assertj.core.util.introspection.ClassUtils;
import org.assertj.core.util.introspection.PropertySupport;

public class ComparingProperties
implements RecursiveComparisonIntrospectionStrategy {
    public static final ComparingProperties COMPARING_PROPERTIES = new ComparingProperties();
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final Map<Class<?>, Set<String>> propertiesNamesPerClass = new ConcurrentHashMap();

    @Override
    public Set<String> getChildrenNodeNamesOf(Object node) {
        if (node == null) {
            return new HashSet<String>();
        }
        return this.propertiesNamesPerClass.computeIfAbsent(node.getClass(), ComparingProperties::getPropertiesNamesOf);
    }

    @Override
    public Object getChildNodeValue(String childNodeName, Object instance) {
        return PropertySupport.instance().propertyValueOf(childNodeName, Object.class, instance);
    }

    @Override
    public String getDescription() {
        return "comparing properties";
    }

    static Set<String> getPropertiesNamesOf(Class<?> clazz) {
        return ComparingProperties.gettersIncludingInheritedOf(clazz).stream().map(Method::getName).map(ComparingProperties::toPropertyName).collect(Collectors.toSet());
    }

    private static String toPropertyName(String methodName) {
        String propertyWithCapitalLetter = methodName.startsWith(GET_PREFIX) ? methodName.substring(GET_PREFIX.length()) : methodName.substring(IS_PREFIX.length());
        return propertyWithCapitalLetter.toLowerCase().charAt(0) + propertyWithCapitalLetter.substring(1);
    }

    public static Set<Method> gettersIncludingInheritedOf(Class<?> clazz) {
        return ComparingProperties.gettersOf(clazz);
    }

    private static Set<Method> gettersOf(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(method -> !ClassUtils.isInJavaLangPackage(method.getDeclaringClass())).filter(method -> !ComparingProperties.isStatic(method)).filter(ComparingProperties::isGetter).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    private static boolean isGetter(Method method) {
        if (ComparingProperties.hasParameters(method)) {
            return false;
        }
        return ComparingProperties.isRegularGetter(method) || ComparingProperties.isBooleanProperty(method);
    }

    private static boolean isRegularGetter(Method method) {
        return method.getName().startsWith(GET_PREFIX);
    }

    private static boolean hasParameters(Method method) {
        return method.getParameters().length > 0;
    }

    private static boolean isBooleanProperty(Method method) {
        Class<?> returnType = method.getReturnType();
        return method.getName().startsWith(IS_PREFIX) && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class));
    }
}

