/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service.util;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.GeneralKt;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.util.NotebookHighlightingUtilityObject;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.util.UtilKt;
import com.intellij.kotlin.jupyter.core.notifications.NotificationsKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/InjectedFileHighlightingHelper;", "", "injectedFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "targetHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "injectedManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "kotlin.jvm.PlatformType", "completeAnalysisRange", "Lcom/intellij/openapi/util/TextRange;", "topLevelFile", "getTopLevelFile", "()Lcom/intellij/psi/PsiFile;", "shouldHighlightErrors", "", "tryUpdateCurrentInjectedFileTarget", "getCompleteAnalysisRangeForWholeNotebook", "checkIfHostIsTargetManually", "isCurrentFileTarget", "()Z", "markTargetHost", "", "applyReceivedHighlightInfos", "foundData", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "shouldAcceptDiagnostic", "psiElement", "Lcom/intellij/psi/PsiElement;", "factoryName", "", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nInjectedFileHighlightingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectedFileHighlightingHelper.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/InjectedFileHighlightingHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class InjectedFileHighlightingHelper {
    @NotNull
    private final PsiFile injectedFile;
    @NotNull
    private final Project project;
    private PsiLanguageInjectionHost targetHost;
    private final InjectedLanguageManager injectedManager;
    @Nullable
    private TextRange completeAnalysisRange;
    @Nullable
    private final PsiFile topLevelFile;
    private boolean shouldHighlightErrors;

    public InjectedFileHighlightingHelper(@NotNull PsiFile injectedFile) {
        Intrinsics.checkNotNullParameter((Object)injectedFile, (String)"injectedFile");
        this.injectedFile = injectedFile;
        Project project = this.injectedFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.injectedManager = InjectedLanguageManager.getInstance((Project)this.project);
        this.topLevelFile = this.injectedManager.getTopLevelFile((PsiElement)this.injectedFile);
        boolean bl = this.tryUpdateCurrentInjectedFileTarget();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Nullable
    public final PsiFile getTopLevelFile() {
        return this.topLevelFile;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean tryUpdateCurrentInjectedFileTarget() {
        var2_1 = this.topLevelFile;
        if (var2_1 == null || (var3_2 = var2_1.getVirtualFile()) == null) ** GOTO lbl-1000
        var5_3 = var3_2;
        var6_4 = BackedNotebookVirtualFile.Companion;
        p0 = var5_3;
        $i$a$-let-InjectedFileHighlightingHelper$tryUpdateCurrentInjectedFileTarget$highlightingManager$1 = false;
        var4_8 = var6_4.takeIfBacked(p0);
        if (var4_8 != null) {
            it = var4_8;
            $i$a$-let-InjectedFileHighlightingHelper$tryUpdateCurrentInjectedFileTarget$highlightingManager$2 = false;
            v0 = NotebookHighlightingService.Companion.getForFile(this.project, it);
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        if (((v1 = (highlightingManager = v0)) == null || (v1 = v1.tryGetKnownHostFor(this.injectedFile)) == null) && (v1 = this.injectedManager.getInjectionHost((PsiElement)this.injectedFile)) == null) {
            return false;
        }
        this.targetHost = v1;
        v2 = highlightingManager;
        this.shouldHighlightErrors = v2 != null ? v2.isFileTarget(this.injectedFile) : this.checkIfHostIsTargetManually();
        return true;
    }

    private final TextRange getCompleteAnalysisRangeForWholeNotebook(PsiFile injectedFile) {
        TextRange textRange;
        Project project = injectedFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project2);
        PsiFile topLevelFile = manager.getTopLevelFile((PsiElement)injectedFile);
        VirtualFile virtualFile = topLevelFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        com.intellij.kotlin.jupyter.core.util.UtilKt.toBackedNotebookFile(virtualFile);
        VirtualFile virtualFile2 = topLevelFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = com.intellij.kotlin.jupyter.core.util.UtilKt.toBackedNotebookFile(virtualFile2);
        if (backedNotebookVirtualFile != null) {
            BackedNotebookVirtualFile it = backedNotebookVirtualFile;
            boolean bl = false;
            textRange = NotebookHighlightingService.Companion.getForFile(project2, it).getDataController().getCompleteHighlightingRange();
        } else {
            textRange = null;
        }
        return textRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkIfHostIsTargetManually() {
        PsiLanguageInjectionHost psiLanguageInjectionHost;
        TextRange textRange = this.completeAnalysisRange = this.getCompleteAnalysisRangeForWholeNotebook(this.injectedFile);
        if (textRange != null) {
            psiLanguageInjectionHost = this.targetHost;
            if (psiLanguageInjectionHost == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetHost");
                psiLanguageInjectionHost = null;
            }
        } else {
            if (this.completeAnalysisRange == null) return false;
            TextRange textRange2 = this.completeAnalysisRange;
            Intrinsics.checkNotNull((Object)textRange2);
            PsiLanguageInjectionHost psiLanguageInjectionHost2 = this.targetHost;
            if (psiLanguageInjectionHost2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetHost");
                psiLanguageInjectionHost2 = null;
            }
            TextRange textRange3 = psiLanguageInjectionHost2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"getTextRange(...)");
            if (!GeneralKt.isEitherSymmetricallyContainedRange(textRange2, textRange3)) return false;
            return true;
        }
        boolean bl = textRange.contains(psiLanguageInjectionHost.getTextRange());
        return bl;
    }

    public final boolean isCurrentFileTarget() {
        return this.shouldHighlightErrors;
    }

    public final void markTargetHost() {
        this.injectedFile.putUserData(NotebookHighlightingUtilityObject.INSTANCE.getNonTargetHostErrorMark(), (Object)(this.shouldHighlightErrors ? null : Boolean.valueOf(true)));
    }

    public final void applyReceivedHighlightInfos(@NotNull Collection<? extends HighlightInfo> foundData, @NotNull HighlightInfoHolder holder) {
        Object object;
        Intrinsics.checkNotNullParameter(foundData, (String)"foundData");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.targetHost;
        if (psiLanguageInjectionHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetHost");
            psiLanguageInjectionHost = null;
        }
        if ((object = UtilKt.getErrorPresenceIndicator(psiLanguageInjectionHost)) == null) {
            AtomicReference<Boolean> atomicReference = new AtomicReference<Boolean>(!foundData.isEmpty());
            AtomicReference<Boolean> atomicReference2 = atomicReference;
            boolean bl = false;
            PsiLanguageInjectionHost psiLanguageInjectionHost2 = this.targetHost;
            if (psiLanguageInjectionHost2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetHost");
                psiLanguageInjectionHost2 = null;
            }
            psiLanguageInjectionHost2.putUserData(NotebookHighlightingUtilityObject.INSTANCE.getInjectedHostHasErrors$intellij_kotlin_jupyter_core(), atomicReference2);
            object = atomicReference;
        }
        AtomicReference<Boolean> errorRef = object;
        Set seenInfosOffsets = new LinkedHashSet();
        if (!foundData.isEmpty()) {
            errorRef.set(true);
        } else {
            errorRef.compareAndSet(true, false);
        }
        for (HighlightInfo highlightInfo : foundData) {
            if (!seenInfosOffsets.add(highlightInfo.startOffset) || !seenInfosOffsets.add(highlightInfo.endOffset)) continue;
            holder.add(highlightInfo);
        }
    }

    public final boolean shouldAcceptDiagnostic(@NotNull PsiElement psiElement, @NotNull String factoryName) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)factoryName, (String)"factoryName");
        if (StringsKt.startsWith$default((String)factoryName, (String)"[MISSING_SCRIPT_BASE_CLASS]", (boolean)false, (int)2, null)) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            NotificationsKt.getNotebookNotifications(project).showAbsentInitialBaseDependenciesInfo();
            return false;
        }
        return !Intrinsics.areEqual((Object)factoryName, (Object)"MISSING_SCRIPT_RECEIVER_CLASS");
    }
}

