/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.auth.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.jose4j.base64url.Base64Url;
import org.openhab.core.auth.ManagedUser;
import org.openhab.core.auth.PendingToken;
import org.openhab.core.auth.User;
import org.openhab.core.auth.UserApiToken;
import org.openhab.core.auth.UserRegistry;
import org.openhab.core.auth.UserSession;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.auth.internal.JwtHelper;
import org.openhab.core.io.rest.auth.internal.TokenEndpointException;
import org.openhab.core.io.rest.auth.internal.TokenResponseDTO;
import org.openhab.core.io.rest.auth.internal.UserApiTokenDTO;
import org.openhab.core.io.rest.auth.internal.UserSessionDTO;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="auth")
@Tag(name="auth")
@Component(service={RESTResource.class, TokenResource.class})
@JaxrsResource
@JaxrsName(value="auth")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class TokenResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(TokenResource.class);
    public static final String PATH_AUTH = "auth";
    public static final String SESSIONID_COOKIE_NAME = "X-OPENHAB-SESSIONID";
    private static final String SESSIONID_COOKIE_FORMAT = "X-OPENHAB-SESSIONID=%s; Domain=%s; Path=/; Max-Age=2147483647; HttpOnly; SameSite=Strict";
    public static final int TOKEN_LIFETIME = 60;
    private final UserRegistry userRegistry;
    private final JwtHelper jwtHelper;

    @Activate
    public TokenResource(@Reference UserRegistry userRegistry, @Reference JwtHelper jwtHelper) {
        this.userRegistry = userRegistry;
        this.jwtHelper = jwtHelper;
    }

    @POST
    @Path(value="/token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(operationId="getOAuthToken", summary="Get access and refresh tokens.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TokenResponseDTO.class))}), @ApiResponse(responseCode="400", description="Invalid request parameters")})
    public Response getToken(@FormParam(value="grant_type") String grantType, @FormParam(value="code") String code, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="client_id") String clientId, @FormParam(value="refresh_token") String refreshToken, @FormParam(value="code_verifier") String codeVerifier, @QueryParam(value="useCookie") boolean useCookie, @CookieParam(value="X-OPENHAB-SESSIONID") @Nullable Cookie sessionCookie) {
        try {
            switch (grantType) {
                case "authorization_code": {
                    return this.processAuthorizationCodeGrant(code, redirectUri, clientId, codeVerifier, useCookie);
                }
                case "refresh_token": {
                    return this.processRefreshTokenGrant(clientId, refreshToken, sessionCookie);
                }
            }
            throw new TokenEndpointException(TokenEndpointException.ErrorType.UNSUPPORTED_GRANT_TYPE);
        }
        catch (TokenEndpointException e) {
            this.logger.warn("Token issuing failed: {}", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getErrorDTO()).build();
        }
        catch (Exception e) {
            this.logger.error("Error while authenticating", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/sessions")
    @Operation(operationId="getSessionsForCurrentUser", summary="List the sessions associated to the authenticated user.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserSessionDTO.class)))}), @ApiResponse(responseCode="401", description="User is not authenticated"), @ApiResponse(responseCode="404", description="User not found")})
    @Produces(value={"application/json"})
    public Response getSessions(@Context SecurityContext securityContext) {
        if (securityContext.getUserPrincipal() == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (String)"User is not authenticated");
        }
        ManagedUser user = (ManagedUser)this.userRegistry.get((Object)securityContext.getUserPrincipal().getName());
        if (user == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"User not found");
        }
        Stream<UserSessionDTO> sessions = user.getSessions().stream().map(this::toUserSessionDTO);
        return Response.ok((Object)new Stream2JSONInputStream(sessions)).build();
    }

    @GET
    @Path(value="/apitokens")
    @Operation(operationId="getApiTokens", summary="List the API tokens associated to the authenticated user.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserApiTokenDTO.class)))}), @ApiResponse(responseCode="401", description="User is not authenticated"), @ApiResponse(responseCode="404", description="User not found")})
    @Produces(value={"application/json"})
    public Response getApiTokens(@Context SecurityContext securityContext) {
        if (securityContext.getUserPrincipal() == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (String)"User is not authenticated");
        }
        ManagedUser user = (ManagedUser)this.userRegistry.get((Object)securityContext.getUserPrincipal().getName());
        if (user == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"User not found");
        }
        Stream<UserApiTokenDTO> sessions = user.getApiTokens().stream().map(this::toUserApiTokenDTO);
        return Response.ok((Object)new Stream2JSONInputStream(sessions)).build();
    }

    @DELETE
    @Path(value="/apitokens/{name}")
    @Operation(operationId="removeApiToken", summary="Revoke a specified API token associated to the authenticated user.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="User is not authenticated"), @ApiResponse(responseCode="404", description="User or API token not found")})
    public Response removeApiToken(@Context SecurityContext securityContext, @PathParam(value="name") String name) {
        if (securityContext.getUserPrincipal() == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (String)"User is not authenticated");
        }
        ManagedUser user = (ManagedUser)this.userRegistry.get((Object)securityContext.getUserPrincipal().getName());
        if (user == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"User not found");
        }
        Optional<UserApiToken> userApiToken = user.getApiTokens().stream().filter(apiToken -> apiToken.getName().equals(name)).findAny();
        if (userApiToken.isEmpty()) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"No API token found with that name");
        }
        this.userRegistry.removeUserApiToken((User)user, userApiToken.get());
        return Response.ok().build();
    }

    @POST
    @Path(value="/logout")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(operationId="deleteSession", summary="Delete the session associated with a refresh token.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="User is not authenticated"), @ApiResponse(responseCode="404", description="User or refresh token not found")})
    public Response deleteSession(@FormParam(value="refresh_token") @Nullable String refreshToken, @FormParam(value="id") @Nullable String id, @CookieParam(value="X-OPENHAB-SESSIONID") @Nullable Cookie sessionCookie, @Context SecurityContext securityContext) {
        Optional<UserSession> session;
        if (securityContext.getUserPrincipal() == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (String)"User is not authenticated");
        }
        ManagedUser user = (ManagedUser)this.userRegistry.get((Object)securityContext.getUserPrincipal().getName());
        if (user == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"User not found");
        }
        if (refreshToken != null) {
            session = user.getSessions().stream().filter(s -> s.getRefreshToken().equals(refreshToken)).findAny();
        } else if (id != null) {
            session = user.getSessions().stream().filter(s -> s.getSessionId().startsWith(id + "-")).findAny();
        } else {
            throw new IllegalArgumentException("no refresh_token or id specified");
        }
        if (session.isEmpty()) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Session not found");
        }
        Response.ResponseBuilder response = Response.ok();
        if (sessionCookie != null && sessionCookie.getValue().equals(session.get().getSessionId())) {
            try {
                URI domainUri = new URI(session.get().getRedirectUri());
                response.header("Set-Cookie", (Object)SESSIONID_COOKIE_FORMAT.formatted(UUID.randomUUID(), domainUri.getHost()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.userRegistry.removeUserSession((User)user, session.get());
        return response.build();
    }

    private UserSessionDTO toUserSessionDTO(UserSession session) {
        return new UserSessionDTO(session.getSessionId().split("-")[0], session.getCreatedTime(), session.getLastRefreshTime(), session.getClientId(), session.getScope());
    }

    private UserApiTokenDTO toUserApiTokenDTO(UserApiToken apiToken) {
        return new UserApiTokenDTO(apiToken.getName(), apiToken.getCreatedTime(), apiToken.getScope());
    }

    private Response processAuthorizationCodeGrant(String code, String redirectUri, String clientId, @Nullable String codeVerifier, boolean useCookie) throws TokenEndpointException, NoSuchAlgorithmException {
        String scope;
        String newRefreshToken;
        String sessionId;
        ManagedUser managedUser;
        block19: {
            Optional<User> user = this.userRegistry.getAll().stream().filter(u -> {
                ManagedUser managedUser = (ManagedUser)u;
                @Nullable PendingToken pendingToken = managedUser.getPendingToken();
                return pendingToken != null && pendingToken.getAuthorizationCode().equals(code);
            }).findAny();
            if (user.isEmpty()) {
                this.logger.warn("Couldn't find a user with the provided authentication code pending");
                throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
            }
            managedUser = (ManagedUser)user.get();
            PendingToken pendingToken = managedUser.getPendingToken();
            if (pendingToken == null) {
                throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
            }
            if (!pendingToken.getClientId().equals(clientId)) {
                this.logger.warn("client_id '{}' doesn't match pending token information '{}'", (Object)clientId, (Object)pendingToken.getClientId());
                throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
            }
            if (!pendingToken.getRedirectUri().equals(redirectUri)) {
                this.logger.warn("redirect_uri '{}' doesn't match pending token information '{}'", (Object)redirectUri, (Object)pendingToken.getRedirectUri());
                throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
            }
            sessionId = UUID.randomUUID().toString();
            newRefreshToken = UUID.randomUUID().toString().replace("-", "");
            scope = pendingToken.getScope();
            String codeChallengeMethod = pendingToken.getCodeChallengeMethod();
            if (codeChallengeMethod == null) break block19;
            String codeChallenge = pendingToken.getCodeChallenge();
            if (codeChallenge == null || codeVerifier == null) {
                this.logger.warn("the PKCE code challenge or code verifier information is missing");
                throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
            }
            switch (codeChallengeMethod) {
                case "plain": {
                    if (codeVerifier.equals(codeChallenge)) break;
                    this.logger.warn("PKCE verification failed");
                    throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
                }
                case "S256": {
                    MessageDigest sha256Digest = MessageDigest.getInstance("SHA-256");
                    String computedCodeChallenge = Base64Url.encode((byte[])sha256Digest.digest(codeVerifier.getBytes()));
                    if (computedCodeChallenge.equals(codeChallenge)) break;
                    this.logger.warn("PKCE verification failed");
                    throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
                }
                default: {
                    this.logger.warn("PKCE transformation algorithm '{}' not supported", (Object)codeChallengeMethod);
                    throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_REQUEST);
                }
            }
        }
        String accessToken = this.jwtHelper.getJwtAccessToken((User)managedUser, clientId, scope, 60);
        UserSession newSession = new UserSession(sessionId, newRefreshToken, clientId, redirectUri, scope);
        Response.ResponseBuilder response = Response.ok((Object)new TokenResponseDTO(accessToken, "bearer", 3600, newRefreshToken, scope, (User)managedUser));
        if (useCookie) {
            try {
                URI domainUri = new URI(redirectUri);
                if (!"".equals(domainUri.getPath()) && !"/".equals(domainUri.getPath())) {
                    throw new IllegalArgumentException("Will not honor the request to set a session cookie for this client, because it's only allowed for root redirect URIs");
                }
                response.header("Set-Cookie", (Object)SESSIONID_COOKIE_FORMAT.formatted(sessionId, domainUri.getHost()));
                newSession.setSessionCookie(true);
            }
            catch (Exception e) {
                this.logger.warn("Error while setting a session cookie: {}", (Object)e.getMessage());
                throw new TokenEndpointException(TokenEndpointException.ErrorType.UNAUTHORIZED_CLIENT);
            }
        }
        managedUser.getSessions().add(newSession);
        managedUser.setPendingToken(null);
        this.userRegistry.update((Identifiable)managedUser);
        return response.build();
    }

    private Response processRefreshTokenGrant(String clientId, @Nullable String refreshToken, @Nullable Cookie sessionCookie) throws TokenEndpointException {
        if (refreshToken == null) {
            throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_REQUEST);
        }
        Optional<User> refreshTokenUser = this.userRegistry.getAll().stream().filter(u -> ((ManagedUser)u).getSessions().stream().anyMatch(s -> refreshToken.equals(s.getRefreshToken()))).findAny();
        if (refreshTokenUser.isEmpty()) {
            this.logger.warn("Couldn't find a user with a session matching the provided refresh_token");
            throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
        }
        ManagedUser refreshTokenManagedUser = (ManagedUser)refreshTokenUser.get();
        UserSession session = refreshTokenManagedUser.getSessions().stream().filter(s -> s.getRefreshToken().equals(refreshToken)).findAny().get();
        if (session.hasSessionCookie() && (sessionCookie == null || !sessionCookie.getValue().equals(session.getSessionId()))) {
            this.logger.warn("Not refreshing token for session {} of user {}, missing or invalid session cookie", (Object)session.getSessionId(), (Object)refreshTokenManagedUser.getName());
            throw new TokenEndpointException(TokenEndpointException.ErrorType.INVALID_GRANT);
        }
        String refreshedAccessToken = this.jwtHelper.getJwtAccessToken((User)refreshTokenManagedUser, clientId, session.getScope(), 60);
        this.logger.debug("Refreshing session {} of user {}", (Object)session.getSessionId(), (Object)refreshTokenManagedUser.getName());
        Response.ResponseBuilder refreshResponse = Response.ok((Object)new TokenResponseDTO(refreshedAccessToken, "bearer", 3600, refreshToken, session.getScope(), (User)refreshTokenManagedUser));
        session.setLastRefreshTime(new Date());
        this.userRegistry.update((Identifiable)refreshTokenManagedUser);
        return refreshResponse.build();
    }
}

