<?php

return [
    'config:clear' => [
        'description' => 'კონფიგურაციის კეშის გასუფთავება.ეს საშუალებას მოგცემთ, გამოიყენოთ ცვლილებები, რომლებიც კონფიგურაციის ბოლო სრული ჩატვირთვის შემდეგ გაკეთდა.',
    ],
    'config:get' => [
        'description' => 'კონფიგურაციის მნიშვნელობის მიღება',
        'arguments' => [
            'setting' => 'პარამეტრი, რომლის მნიშვნელობის მიღებაც გნებავთ, წერტილიანი ნოტაციით notation (მაგ: snmp.community.0)',
        ],
        'options' => [
            'dump' => 'მთლიანი კონფიგურაციის გამოტანა JSON ფორმატში',
        ],
    ],
    'config:set' => [
        'description' => 'კონფიგურაციის მნიშვნელობის დაყენება (ან დაყენების გაუქმება)',
        'arguments' => [
            'setting' => 'დასაყენებელი პარამეტრი წერტილიანი ნოტაციით (მაგ: snmp.community.0) ბოლოში მისამატებლად მასივის სუფიქსისთვის .+-ით',
            'value' => 'დასაყენებელი მნიშვნელობა. დაყენების გაუქმება, თუ მითითებული არაა',
        ],
        'options' => [
            'ignore-checks' => 'ყველა უსაფრთხოების შემოწმების იგნორი',
        ],
        'confirm' => ':setting-ის ჩამოყრა ნაგულისხმევზე?',
        'forget_from' => 'დავივიწყო :path მშობლიდან :parent?',
        'errors' => [
            'append' => 'არა მასივის ტიპის პარამეტრს ბოლოში ვერ მიაწერთ',
            'failed' => ':setting-ის დაყენების შეცდომა',
            'invalid' => 'ეს არასწორი პარამეტრია. შეამოწმეთ, რა შეიყვანეთ',
            'invalid_os' => 'მითითებული ოს-ი (:os) არ არსებობს',
            'nodb' => 'მონაცემთა ბაზა დაკავშირებული არაა',
            'no-validation' => 'პარამეტრის :setting დაყენება შეუძლებელია. მას ვალიდაციის აღწერა არ აქვს.',
        ],
    ],
    'db:seed' => [
        'existing_config' => 'მონაცემთა ბაზა შეიცავს არსებულ პარამეტრებს. გავაგრძელო?',
    ],
    'dev:check' => [
        'description' => 'LibreNMS-ის კოდის შემოწმებები. პარამეტრების გარეშე გაშვება ყველა შემოწმებას გაუშვებს',
        'arguments' => [
            'check' => 'მითითებული შემოწმებების გაშვება :checks',
        ],
        'options' => [
            'commands' => 'ბრძანებების და არა შემოწმებების, გამოტანა',
            'db' => 'იმ ტესტების გაშვება, რომლებსაც მონაცემთა ბაზასთან კავშირი სჭირდებათ',
            'fail-fast' => 'შემოწმებების გაჩერებ პირველივე ჩავარდნისას',
            'full' => 'ყველა შემოწმების გაშვება შეცვლილი ფაილების გაფილტვრის გამოტოვებით',
            'module' => 'მოდული, რომლებზეც ტესტები გაეშვება. იგულისხმება ერთეულის ტესტები, --db და --snmpsim',
            'os' => 'ოს-ი, რომელზეც ტესტები გაეშვება. შეიძლება იყოს რეგგამოსი, ან მძიმით გამოყოფილი სია იგულისხმება ერთეულის ტესტები, --db და --snmpsim',
            'os-modules-only' => 'ოს-ის დადგენის ტესტის გამოტოვება ვერსიის ხელით მითითებისას. ააჩქარებს ტესტის დროს როცა დაუდგენელ ცვლილებებს ამოწმებთ.',
            'quiet' => 'გამოტანის დამალვა, თუ შეცდომა არაა',
            'snmpsim' => 'snmpsim-ის გამოყენება ერთეულის ტესტებისთვის',
        ],
    ],
    'dev:simulate' => [
        'description' => 'მოწყობილობების სიმულაცია სატესტო მონაცემებით',
        'arguments' => [
            'file' => 'snmprec ფაილის სახელი (მხოლოდ სახელი) განახლებისთვის, ან LibreNMS-ში დასამატებლად. თუ ფაილი მითითებული არაა, მოწყობილობები არც დაემატება, არც განახლდება.',
        ],
        'options' => [
            'multiple' => 'ზაგოგადოების სახელის გამოყენება ჰოსტის სახელისტვის snmpsim-ის მაგიერ',
            'remove' => 'ამ მოწყობილობის წაშლა გაჩერების შემდეგ',
        ],
        'added' => 'დაემატა მოწყობილობა :hostname (:id)',
        'exit' => 'Ctrl-C გასაჩერებლად',
        'removed' => 'მოწყობილობა :id წაიშალა',
        'updated' => 'მოწყობილობა :hostname (:id) განახლდა',
        'setup' => 'snmpsim-ის venv-ის აწყობა საქაღალდეში :dir',
    ],
    'device:add' => [
        'description' => 'ახალი მოწყობილობის დამატება',
        'arguments' => [
            'device spec' => 'ჰოსტის სახელი ან IP დასამატებლად',
        ],
        'options' => [
            'v1' => 'SNMP v1-ის გამოყენება',
            'v2c' => 'SNMP v2c-ის გამოყენება',
            'v3' => 'SNMP v3-ის გამოყენება',
            'display-name' => 'სტრიქონი, რომელიც ამ მოწყობილობის სახელად გამოჩნდება. ნაგულისხმევია მისი ჰოსტის სახელი.\nშეიძლება იყოს მარტივი ნიმუში შემდეგი ჩანაცვლებებით: {{ \$hostname }}, {{ \$sysName }}, {{ \$sysName_fallback }}, {{ \$ip }}',
            'force' => 'მოწყობილობის უბრალოდ დამატება, უსაფრთხოების შემოწმებების გარეშე',
            'group' => 'მომთხოვნების ჯგუფი (განაწილებული მოთხოვნისთვის)',
            'ping-fallback' => 'მოწყობილობის მხოლოდ-პინგის სახით დამატება, თუ ის SNMP-ს არ პასუხობს',
            'port-association-mode' => 'აღწერს, როგორ ხდება პორტების ასახვა. ifName მოგეწოდებათ სისტემებისთვის Linux/Unix',
            'community' => 'SNMP v1-ის, ან v2-ის საზოგადოება',
            'transport' => 'ტრანსპორტი მოწყობილობასტან მისაერთებლად',
            'port' => 'SNMP ტრანსპორტის პორტი',
            'security-name' => 'SNMPv3 უსაფრთხოების მომხმარებლის სახელი',
            'auth-password' => 'SNMPv3 ავთენტიკაციის პაროლი',
            'auth-protocol' => 'SNMPv3 ავთენტიკაციის პროტოკოლი',
            'privacy-protocol' => 'SNMPv3 კონფიდენციალობის პროტოლი',
            'privacy-password' => 'SNMPv3 კონფიდენციალობის პაროლი',
            'ping-only' => 'მხოლოდ-დასაპინგი მოწყობილობის დამატება',
            'os' => 'მხოლოდ პინგი: მიუთითეთ ოს-ი',
            'hardware' => 'მხოლოდ პინგი: მიუთითეთ აპარატურა',
            'sysName' => 'მხოლოდ პინგი: მიუთითეთ sysName',
        ],
        'validation-errors' => [
            'port.between' => 'პორტი უნდა იყოს შუალედიდან 1-65535',
            'poller-group.in' => 'მითითებული მომთხოვნების ჯგუფი არ არსებობს',
        ],
        'messages' => [
            'save_failed' => 'ჩავარდა შენახვა მოწყობილობისთვის :hostname',
            'try_force' => 'უსაფრთხოების შემოწმებების გამოსატოვებლად გამოიყენეთ პარამეტრი  --force',
            'added' => 'დაემატა მოწყობილობა :hostname (:device_id)',
        ],
    ],
    'device:ping' => [
        'description' => 'მოწყობილობის დაპინგვა და მონაცემების ჩაწერა პასუხისთვის',
        'arguments' => [
            'device spec' => 'მოწყობილობა დასაპინგად. ერთ-ერთი: <მოწყობილობის ID>, <ჰოსტის სახელი/IP>, all',
        ],
    ],
    'device:poll' => [
        'description' => 'მონაცემების აღება მოწყობილობებიდან ისე, როგორც ეს აღმოჩენისას დადგინდა',
        'arguments' => [
            'device spec' => 'მოწყობილობის სპეციფიკაცია გამოსათხოვად: device_id, hostname, wildcard (*), odd, even, all',
        ],
        'options' => [
            'modules' => 'მიუთითეთ ერთი მოდული გასაშვებად. მძიმით გამოყოფილი მოდულებისა და ქვემოდულების დამატება /-ით შეგიძლიათ',
            'no-data' => 'არ განაახლო მონაცემთა საცავი (RRD, InfluxDB, etc)',
        ],
        'errors' => [
            'db_connect' => 'მონაცემთა ბაზასთან დაკავშირება ჩავარდა. გადაამოწმეთ, გაშვებულია თუ არა ბაზის სერვისი და დაამატეთ კავშირის პარამეტრები.',
            'db_auth' => 'მონაცემთა ბაზასთან დაკავშირება ჩავარდა. გადაამოწმეთ ავტორიზაციის დეტალები: :error',
            'no_devices' => 'მითითებული მოწყობილობის სპეიციფიკაციით მოწყობილობები აღმოჩენილი არაა.',
            'none_up' => 'მოწყობილობა გამორთული იყო. გამოთხოვა შეუძლებელია.|ყველა მოწყობილობა გამორთული იყო. გამოთხოვა შეუძლებელია.',
            'none_polled' => 'მოწყობილობებიდან გამოთხოვა არ მომხდარა.',
        ],
        'polled' => 'გამოთხოვილია :count მოწყობილობიდან. დრო: :time',
    ],
    'key:rotate' => [
        'description' => 'APP_KEY-ის შეცვლა. ეს გაშიფრავს ყველა დაშიფრულ მონაცემს ძველი გასაღებით და დაიმახსოვრებს ახალი გასაღებით APP_KEY.',
        'arguments' => [
            'old_key' => 'ძველი APP_KEY რომელიც სწორია დაშიფრული მონაცემებისთვის',
        ],
        'options' => [
            'generate-new-key' => 'თუ არ გაქვთ ახალი გასაღები ფაილში .env, გამოიყენეთ the APP_KEY ფაილიდან .env მონაცემების გასაშიფრად და ახალი გასაღების გენერაციისთვის და დააყენეთ ის ფაილში .env',
            'forgot-key' => 'თუ თქვენ არ გაქვთ ძველი გასაღები, ყველა დაშიფრული მონაცემები უნდა წაშალოთ, რომ LibreNMS-ის ზოგიერთი ფუნქცია გამოიყენოთ',
        ],
        'destroy' => 'გავანადგურო დაშიფრული კონფიგურაციის მონაცემები მთლიანად?',
        'destroy_confirm' => 'დაშიფრული მონაცემები სრულად, მხოლოდ, მაშინ წაშალეთ, თუ ძველ APP_KEY-ს ვეღარ პოულობთ!',
        'cleared-cache' => 'კონფიგურაცია დაკეშილია. გაასუფთავეთ კეში და დარწმუნდით, რომ APP_KEY სწორია. შემდეგ კი თავიდან გაუშვით lnms key:rotate',
        'backup_keys' => 'ჩაიწერეთ ორივე გასაღები! იმ შემთხვევაში, თუ რამე მოხდება, დააყენეთ ახალი გასაღები ფაილში .env და გამოიყენეთ ძელი გასაღები არგუმენტად ამ ბრძანებისთვის',
        'backup_key' => 'ჩაიწერეთ ეს გასაღები! ეს გასაღები აუცილებელია დაშიფრულ მონაცემეთან წვდომისთვის',
        'backups' => 'ამ ბრძანებას შეუძლია, მონაცემების შეუქცევადი კარგვა გამოიწვიოს და ის ყველა ბრაუზერის სესიას გააუქმებს. დარწმუნდით, რომ ყველაფერი დაამარქაფეთ.',
        'confirm' => 'მე მაქვს მარქაფები და მინდა, გავაგრძელო',
        'decrypt-failed' => ':item-ის გაშიფვრის შეცდომა. გამოტოვება',
        'failed' => 'ელემენტ(ებ)-ის გაშიფვა ჩავარდა. დააყენეთ ახალი გასაღები, როგორც APP_KEY და გაუშვითა თავიდან ძველი გასაღებით არგუმენტის სახით.',
        'current_key' => 'მიმდინარე APP_KEY: :key',
        'new_key' => 'ახალი APP_KEY: :key',
        'old_key' => 'ძველი APP_KEY: :key',
        'save_key' => 'შევინახო ახალი გასაღების ფაილში .env?',
        'success' => 'გასაღებები წარმატებით შეიცვალა!',
        'validation-errors' => [
            'not_in' => ':attribute არ უნდა ემთხვეოდეს გასაღებს APP_KEY',
            'required' => 'აუცილებელია, ან ძველი გასაღეიბ, ან --generate-new-key.',
        ],
    ],
    'lnms' => [
        'validation-errors' => [
            'optionValue' => 'მონიშნული :option არასწორი. უნდა იყოს ერთ-ერთი სიიდან: :values',
        ],
    ],
    'maintenance:fetch-ouis' => [
        'description' => 'MAC OUI-ების და კეშის გამოთხოვადა დაკეშვა მათი MAC მისამართებისთვის მწარმოებლის საჩვენებლად',
        'options' => [
            'force' => 'გამოტოვება პარამეტრების და დაბლოკვის, რომელიც ამ ბრძანების გაშვებას ხელს უშლის',
            'wait' => 'შემთხვევითი დროით მოლოდინი. გამოიყენება დამგეგმავის მიერ სერვერის გადატვირთვის თავიდან ასაცილებლად',
        ],
        'disabled' => 'Mac OUI-ის ინტეგრაცია გამორთულია (:setting)',
        'enable_question' => 'Mac OUI-ის ინტეგრაცია და დაგეგმილი გამოთხოვა?',
        'recently_fetched' => 'MAC OUI-ის მონაცემთა ბაზის გამოთხოვა ახლახან მოხდა. განახლება გამოტოვებული იქნება.',
        'waiting' => 'ვიცდი :minutes წუთს MAC OUI-ის განახლებამდე|ვიცდი :minutes წუთს MAC OUI-ის განახლებამდე',
        'starting' => 'Mac OUI-ის შენახვა მონაცემთა ბაზაში',
        'downloading' => 'მიმდინარეობს გადმოწერა',
        'processing' => 'მიმდინარეობს CSV-ის გადმოწერა',
        'saving' => 'მიმდინარეობს შედეგების შენახვა',
        'success' => 'წარმატებით განახლდა OUI/მწარმოებლის ასახვები. :count შეცვლილი OUI| წარმატებით განახლდა. :count შეცვლილი OUI',
        'error' => 'Mac OUI-ის დამუშავების შეცდომა:',
        'vendor_update' => 'OUI-ის დამატება :oui მომწოდებლისთვის :vendor',
    ],
    'plugin:disable' => [
        'description' => 'ამ სახელის მქონე ყველა დამატების გამორთვა',
        'arguments' => [
            'plugin' => 'გასათიში დამატების გარეშე, ან "all", ყველა დამატების გასათიშად',
        ],
        'already_disabled' => 'დამატება უკვე გამორთულია',
        'disabled' => ':count დამატება გამორთულია|:count დამატება გამორთულია',
        'failed' => 'დამატებ(ებ)-ის გამორთვა ჩავარდა',
    ],
    'plugin:enable' => [
        'description' => 'მითითებული სახელის მქონე უახლესი დამატების ჩართვა',
        'arguments' => [
            'plugin' => 'ჩასართავი დამატების გარეშე, ან "all", ყველა დამატების გასათიშად',
        ],
        'already_enabled' => 'დამატება უკვე ჩართულია',
        'enabled' => ':count დამატება ჩართულია|:count დამატება ჩართულია',
        'failed' => 'დამატებ(ებ)-ის ჩართვა ჩავარდა',
    ],
    'report:devices' => [
        'description' => 'მოწყობილობებიდან მიღებული მონაცემების გამოტანა',
        'columns' => 'მონაცემთა ბაზის სვეტები:',
        'synthetic' => 'დამატებითი ველები:',
        'counts' => 'ურთიერთობების რაოდენობა:',
        'arguments' => [
            'device spec' => 'გამოსათხოვი მოწყობილობის სპეციფიკაცია: device_id, hostname, wildcard (*), odd, even, all',
        ],
        'options' => [
            'list-fields' => 'სწორი ველების სიის გამოტანა',
            'fields' => 'საჩვენებელლი ველების მძიმით გამოყოფილი სია. სწორი პარამეტრებია: მოწყობილობის სვეტების სახელი მონაცემთა ბაზიდან, ურთიერთობების რაოდენობა, (ports_count) ან/და displayName. არ გამოიყენება JSON ფორმატში გასატანად.',
            'output' => 'გამოტანის ფორმატი მონაცემების საჩვენებლად :types',
            'no-header' => 'არ დაამატო თავსართი',
            'relationships' => 'ჩასასმელი ურთიერთობების მძიმით გამოყოფილი სია. გამოიყენება, მხოლოდ, JSON-ში გატანისას.',
            'list-relationships' => 'ურთიერთობების სიის/აღწერის გამოტანა',
            'all-relationships' => 'ყველა ურთიერთობის ცასმა. პარამეტრები -r, --relationships ნაგულისხმევია.',
            'devices-as-array' => 'აბრუნებს JSON მასივს JSON ჩანაწერის მაგიერ თითოეული მოწყობილობისთვის თითოეულ ხაზზე',
        ],
    ],
    'smokeping:generate' => [
        'args-nonsense' => 'გამოიყენეთ ერთ-ერთი: --probes ან --targets',
        'config-insufficient' => 'smokeping-ის კონფიგურაციის გენერაციისთვის, უნდა გქონდეთ დაყენებული "smokeping.probes", "fping", და "fping6" თქვენს კონფიგურაციაში',
        'dns-fail' => 'was not resolvable and was omitted from the configuration',
        'description' => 'smokeping-თან თავსებადი კონფიგურაციის გენერაცია',
        'header-first' => 'ეს ფაილი ავტომატურად იქნა შექმნილი ბრძანებით "lnms smokeping:generate',
        'header-second' => 'ლოკალური ცვლილებები, შეიძლება, ჩანაცვლდეს შეტყობინების გარეშე, ან მარქაფების აღების გარეშე',
        'header-third' => 'მეტი ინფორმაციისთვის იხილეთ https://docs.librenms.org/Extensions/Smokeping/"',
        'no-devices' => 'შესაბამისი მოწყობილობები აღმოჩენილი არაა - მოწყობილობა გამორთული არ უნდა იყოს.',
        'no-probes' => 'აუცილებელია, სულ ცოტა, ერთი ზონდი.',
        'options' => [
            'probes' => 'ზონდების სიის გენერაცია - გამოიყენება smokeping-ის კონფიგურაციის მრავალ ფაილად დაყოფისთვის. კონფლიქტშია პარამეტრთან "--targets"',
            'targets' => 'სამიზნე სიის გენერაცია - გამოიყენება smokeping-ის კონფიგურაციის მრავალ ფაილად დაყოფისთვის. კონფლიქტშია პარამეტრთან "--probes"',
            'no-header' => 'არ დაამატო boilerplate ბრძანება შექმნილი ფაილის დასაწყისში',
            'no-dns' => 'DNS ამოხსნების გამოტოვება',
            'single-process' => 'smokeping-სთვის, მხოლოდ, ერთი პროცესის გამოყენება',
            'compat' => '[მოძველებული] gen_smokeping.php-ის ქცევის მიმიკა',
        ],
    ],
    'snmp:fetch' => [
        'description' => 'snmp მოთხოვნის გაგზავნა მოწყობილობაზე',
        'arguments' => [
            'device spec' => 'გამოსათხოვი მოწყობილობის სპეციფიკაცია: device_id, hostname, wildcard (*), odd, even, all',
            'oid(s)' => 'ერთი ან მეტი SNMP OID გამოსათხოვად. უნდა იყოს MIB::oid ფორმატში, ან რიცხვითი oid',
        ],
        'failed' => 'SNMP ბრძანება ჩავარდა!',
        'numeric' => 'რიცხვითი',
        'oid' => 'OID',
        'options' => [
            'output' => 'მიუთითეთ გამოტანის ფორმატი :formats',
            'numeric' => 'რიცხვითი OID-ები',
            'depth' => 'სიღრმე, რომელზეც snmp ცხრილის დაჯგუფება მოხდება. ჩვეულებრივ, იგივე რიცხვია, რაც ელემენტების რაოდენობაცხრილის ინდექსში',
        ],
        'not_found' => 'მოწყობილობა აღმოჩენილი არაა',
        'textual' => 'ტექსტური',
        'value' => 'მნიშვნელობა',
    ],
    'translation:generate' => [
        'description' => 'განახლებული JSON ენის ფაილების გენერაცია მათი ვების წინაბოლოში გამოსაყენებლად',
    ],
    'user:add' => [
        'description' => 'ლოკალური მომხმარებლის დამატება. ამ მომხმარებლით, მხოლოდ, მაშინ შეგეძლებათ შესვლა, თუ ავთენტიკაცია mysql-ზეა დაყენებული',
        'arguments' => [
            'username' => 'მომხმარებლის სახელი, რომლითაც სისტემაში შეხვალთ',
        ],
        'options' => [
            'descr' => 'მომხმარებლის აღწერა',
            'email' => 'ელფოსტა ამ მომხმარებლისთვის',
            'password' => ' პაროლი ამ მომხმარებლისთვის. თუ არ მიუთითებთ, გკითხავთ',
            'full-name' => 'მომხმარებლის სრული სახელი',
            'role' => 'დაუყენეთ მომხმარებელს სასურველი როლები :roles',
        ],
        'password-request' => 'შეიყვანეთ მომხმარებლის პაროლი',
        'success' => 'წარმატებით დაემატა მომხმარებელი: :username',
        'wrong-auth' => 'ფრთხილად! You will not be able to log in with this user because you are not using MySQL auth',
    ],
    'maintenance:database-cleanup' => [
        'description' => 'მონაცემთა ბაზის გასუფთავება მიტოვებული ელემენტებისგან.',
    ],
];
