# -*- tcl -*-
#
# _toc_common.tcl
#
# (c) 2003 Andreas Kupries <andreas_kupries@sourceforge.net>

################################################################
# The code here contains general definitions for API functions and
# state information. They are used by several formatters to simplify
# their own code.

proc toc_initialize    {}             {return}
proc toc_shutdown      {}             {return}
proc toc_numpasses     {}             {return 1}
proc toc_postprocess   {text}         {return $text}
proc toc_setup         {n}            {return}
proc toc_listvariables {}             {return {}}
proc toc_varset        {varname text} {return}


proc fmt_plain_text  {text} {return $text}

################################################################
# Functions made available to the formatter to access the common
# state managed here.

proc c_provenance {} {
    return "Generated by tcllib/doctools/toc with format '[dt_format]'"
}

################################################################
