/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import sun.jvm.hotspot.runtime.VM;

public class VMVersionInfoPanel
extends JPanel {
    private JEditorPane versionPane;

    public VMVersionInfoPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.versionPane = new JEditorPane();
        this.versionPane.setContentType("text/html");
        this.versionPane.setEditable(false);
        this.versionPane.setText(this.getVersionInfo());
        this.add((Component)this.versionPane, "Center");
    }

    private String getVersionInfo() {
        String internalInfo;
        VM vm = VM.getVM();
        StringBuffer buf = new StringBuffer();
        buf.append("<html><head><title>VM Version Info</title></head>");
        buf.append("<body><table border='1'>");
        buf.append("<tr><td><b>VM Type</b></td>");
        buf.append("<td>");
        if (vm.isCore()) {
            buf.append("<b>core</b>");
        } else if (vm.isClientCompiler()) {
            buf.append("<b>client</b>");
        } else if (vm.isServerCompiler()) {
            buf.append("<b>server</b>");
        } else {
            buf.append("<b>unknown</b>");
        }
        buf.append("</td></tr>");
        String release = vm.getVMRelease();
        if (release != null) {
            buf.append("<tr><td><b>VM Release</td><td><b>");
            buf.append(release);
            buf.append("</b></td></tr>");
        }
        if ((internalInfo = vm.getVMInternalInfo()) != null) {
            buf.append("<tr><td><b>VM Internal Info</td><td><b>");
            buf.append(internalInfo);
            buf.append("</b></td></tr>");
        }
        buf.append("</table></body></html>");
        return buf.toString();
    }
}

