#!/usr/bin/perl -w

use strict;
use CGI '3.12';
use mod_perl2;
use GD;
use Proxmox::DynGraph;

my $r = Apache2::RequestUtil->request();

my $cgi = CGI->new($r);

my $arglist = $cgi->Vars();

my $colors = {
    highlight => { r => 0x99, g => 0x00, b => 0x00 },
};
        
my $usecache = 1;

my $im;

if ($arglist->{shape} eq 'tarrdown') {
    $im = Proxmox::DynGraph::draw_arrow ($colors, 1, 0, 0);
} elsif ($arglist->{shape} eq 'arrdown') {
    $im =  Proxmox::DynGraph::draw_arrow ($colors, 0, 0, 0);
} elsif ($arglist->{shape} eq 'iarrdown') {
    $im =  Proxmox::DynGraph::draw_arrow ($colors, 0, 1, 0);
} elsif ($arglist->{shape} eq 'arrright') {
    $im =  Proxmox::DynGraph::draw_arrow ($colors, 0, 0, 1);
} elsif ($arglist->{shape} eq 'tarrright') {
    $im =  Proxmox::DynGraph::draw_arrow ($colors, 1, 0, 1);
} elsif ($arglist->{shape} eq 'logo') {
    $im = GD::Image->new ("/var/www/images/logo_proxmox.jpg");
} else {
    $im =  Proxmox::DynGraph::draw_unknown ();
}

Proxmox::DynGraph::send_png_image ($r, $im->png, 1);

exit 0;
