# To get a package list without version numbers from a target system
# rpm -qa --qf "%{n} " > packages.txt
# Put contents of packages.txt after "-y install \" line below

rm -rf /ostemplate ; mkdir /ostemplate

yum -y install --releasever=7 --nogpg --enablerepo=base --enablerepo=extras --enablerepo=updates --installroot /ostemplate \
openssh-server yum yum-utils man wget sudo tar passwd vim-minimal net-tools centos-release net-tools initscripts openssh-clients

# Do some cleanup
rm -rf /ostemplate/var/cache/yum/x86_64

# Copy our script and related files
cp /root/create-centos7*.sh /ostemplate/root/

ln -sf /proc/mounts /ostemplate/etc/mtab
touch /ostemplate/etc/fstab

# I want Mountain time to be the default
ln -sf /usr/share/zoneinfo/America/Denver /ostemplate/etc/localtime

# Now compress that sucker, assumes you have xz installed
cd /ostemplate ; tar -cvJf /root/centos-7-x86_64-minimal-$(date +%Y%m%d).tar.xz . ; cd
ls -lh /root/centos-7-x86_64-minimal-$(date +%Y%m%d).tar.xz
echo "Done building OS Template.  Now test it."
