require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SYSTEM_H)) {
    eval 'sub __ASM_SYSTEM_H () {1;}' unless defined(&__ASM_SYSTEM_H);
    require 'linux/kernel.ph';
    require 'asm/segment.ph';
    require 'asm/alternative.ph';
    if(defined(&__KERNEL__)) {
	eval 'sub __STR {
	    my($x) = @_;
    	    eval q($x);
	}' unless defined(&__STR);
	eval 'sub STR {
	    my($x) = @_;
    	    eval q( &__STR($x));
	}' unless defined(&STR);
	eval 'sub __SAVE {
	    my($reg,$offset) = @_;
    	    eval q(\\"movq %%\\" $reg \\",(14-\\" $offset \\")*8(%%rsp)\\\\n\\\\t\\");
	}' unless defined(&__SAVE);
	eval 'sub __RESTORE {
	    my($reg,$offset) = @_;
    	    eval q(\\"movq (14-\\" $offset \\")*8(%%rsp),%%\\" $reg \\"\\\\n\\\\t\\");
	}' unless defined(&__RESTORE);
	eval 'sub SAVE_CONTEXT () {"pushq %%rbp ; movq %%rsi,%%rbp\\n\\t";}' unless defined(&SAVE_CONTEXT);
	eval 'sub RESTORE_CONTEXT () {"movq %%rbp,%%rsi ; popq %%rbp\\n\\t";}' unless defined(&RESTORE_CONTEXT);
	eval 'sub __EXTRA_CLOBBER () {,"rcx","rbx","rdx","r8","r9","r10","r11","r12","r13","r14","r15";}' unless defined(&__EXTRA_CLOBBER);
	eval 'sub switch_to {
	    my($prev,$next,$last) = @_;
    	    eval q( &asm  &volatile( &SAVE_CONTEXT \\"movq %%rsp,%P[threadrsp](%[prev])\\\\n\\\\t\\" \\"movq %P[threadrsp](%[next]),%%rsp\\\\n\\\\t\\" \\"call __switch_to\\\\n\\\\t\\" \\".globl thread_return\\\\n\\" \\"thread_return:\\\\n\\\\t\\" \\"movq %%gs:%P[pda_pcurrent],%%rsi\\\\n\\\\t\\" \\"movq %P[thread_info](%%rsi),%%r8\\\\n\\\\t\\"  &LOCK_PREFIX \\"btr  %[tif_fork],%P[ti_flags](%%r8)\\\\n\\\\t\\" \\"movq %%rax,%%rdi\\\\n\\\\t\\" \\"jc   ret_from_fork\\\\n\\\\t\\"  &RESTORE_CONTEXT : \\"=a\\" ($last) : [$next] \\"S\\" ($next), [$prev] \\"D\\" ($prev), [ &threadrsp] \\"i\\" ( &offsetof(1;
	}' unless defined(&switch_to);
	eval 'sub loadsegment {
	    my($seg,$value) = @_;
    	    eval q( &asm  &volatile(\\"\\\\n\\" \\"1:\\\\t\\" \\"movl %k0,%%\\" $seg \\"\\\\n\\" \\"2:\\\\n\\" \\".section .fixup,\\\\\\"ax\\\\\\"\\\\n\\" \\"3:\\\\t\\" \\"movl %1,%%\\" $seg \\"\\\\n\\\\t\\" \\"jmp 2b\\\\n\\" \\".previous\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"\\\\n\\\\t\\" \\".align 8\\\\n\\\\t\\" \\".quad 1b,3b\\\\n\\" \\".previous\\" : :\\"r\\" ($value), \\"r\\" (0)));
	}' unless defined(&loadsegment);
	eval 'sub clts () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&clts);
	eval 'sub read_cr0 {
	    my($void) = @_;
    	    eval q({ my $cr0;  &asm  &volatile(\\"movq %%cr0,%0\\" : \\"=r\\" ( $cr0));  $cr0; } );
	}' unless defined(&read_cr0);
	eval 'sub write_cr0 {
	    my($val) = @_;
    	    eval q({  &asm  &volatile(\\"movq %0,%%cr0\\" :: \\"r\\" ($val)); } );
	}' unless defined(&write_cr0);
	eval 'sub read_cr3 {
	    my($void) = @_;
    	    eval q({ my $cr3;  &asm(\\"movq %%cr3,%0\\" : \\"=r\\" ( $cr3));  $cr3; } );
	}' unless defined(&read_cr3);
	eval 'sub read_cr4 {
	    my($void) = @_;
    	    eval q({ my $cr4;  &asm(\\"movq %%cr4,%0\\" : \\"=r\\" ( $cr4));  $cr4; } );
	}' unless defined(&read_cr4);
	eval 'sub write_cr4 {
	    my($val) = @_;
    	    eval q({  &asm  &volatile(\\"movq %0,%%cr4\\" :: \\"r\\" ($val)); } );
	}' unless defined(&write_cr4);
	eval 'sub stts () {
	    eval q( &write_cr0(8|  &read_cr0()));
	}' unless defined(&stts);
	eval 'sub wbinvd () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&wbinvd);
    }
    eval 'sub nop () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&nop);
    eval 'sub xchg {
        my($ptr,$v) = @_;
	    eval q((( &__typeof__(*($ptr))) &__xchg(($v),($ptr),$sizeof{($ptr)})));
    }' unless defined(&xchg);
    eval 'sub tas {
        my($ptr) = @_;
	    eval q(( &xchg(($ptr),1)));
    }' unless defined(&tas);
    eval 'sub __xg {
        my($x) = @_;
	    eval q((( &volatile \'long\' *)($x)));
    }' unless defined(&__xg);
    eval 'sub set_64bit {
        my($ptr,$val) = @_;
	    eval q({ *$ptr = $val; });
    }' unless defined(&set_64bit);
    eval 'sub _set_64bit () { &set_64bit;}' unless defined(&_set_64bit);
    eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
    eval 'sub __cmpxchg {
        my($ptr,$old,$new,$size) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__cmpxchg);
    eval 'sub cmpxchg {
        my($ptr,$o,$n) = @_;
	    eval q((( &__typeof__(*($ptr))) &__cmpxchg(($ptr),($o), ($n),$sizeof{($ptr)})));
    }' unless defined(&cmpxchg);
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &wmb());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do {}  &while(0));
	}' unless defined(&smp_read_barrier_depends);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do {}  &while(0));
	}' unless defined(&smp_read_barrier_depends);
    }
    eval 'sub mb () {
        eval q( &asm  &volatile(\\"mfence\\":::\\"memory\\"));
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q( &asm  &volatile(\\"lfence\\":::\\"memory\\"));
    }' unless defined(&rmb);
    if(defined(&CONFIG_UNORDERED_IO)) {
	eval 'sub wmb () {
	    eval q( &asm  &volatile(\\"sfence\\" ::: \\"memory\\"));
	}' unless defined(&wmb);
    } else {
	eval 'sub wmb () {
	    eval q( &asm  &volatile(\\"\\" ::: \\"memory\\"));
	}' unless defined(&wmb);
    }
    eval 'sub read_barrier_depends () {
        eval q( &do {}  &while(0));
    }' unless defined(&read_barrier_depends);
    eval 'sub set_mb {
        my($var, $value) = @_;
	    eval q( &do { ( &void)  &xchg($var, $value); }  &while (0));
    }' unless defined(&set_mb);
    eval 'sub warn_if_not_ulong {
        my($x) = @_;
	    eval q( &do { \'unsigned long foo\'; ( &void) (($x) ==  &foo); }  &while (0));
    }' unless defined(&warn_if_not_ulong);
    require 'linux/irqflags.ph';
}
1;
