require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPINLOCK_H)) {
    eval 'sub __LINUX_SPINLOCK_H () {1;}' unless defined(&__LINUX_SPINLOCK_H);
    unless(defined(&__KERNEL__)) {
    } else {
	require 'linux/preempt.ph';
	require 'linux/linkage.ph';
	require 'linux/compiler.ph';
	require 'linux/thread_info.ph';
	require 'linux/kernel.ph';
	require 'linux/stringify.ph';
	require 'asm/system.ph';
	eval 'sub LOCK_SECTION_NAME () {".text.lock." &KBUILD_BASENAME;}' unless defined(&LOCK_SECTION_NAME);
	eval 'sub LOCK_SECTION_START {
	    my($extra) = @_;
    	    eval q(\\".subsection 1\\\\n\\\\t\\" $extra \\".ifndef \\"  &LOCK_SECTION_NAME \\"\\\\n\\\\t\\"  &LOCK_SECTION_NAME \\":\\\\n\\\\t\\" \\".endif\\\\n\\");
	}' unless defined(&LOCK_SECTION_START);
	eval 'sub LOCK_SECTION_END () {".previous\\n\\t";}' unless defined(&LOCK_SECTION_END);
	eval 'sub __lockfunc () { &fastcall  &__attribute__(( &section(".spinlock.text")));}' unless defined(&__lockfunc);
	require 'linux/spinlock_types.ph';
	if(defined(&CONFIG_SMP)) {
	    require 'asm/spinlock.ph';
	} else {
	    require 'linux/spinlock_up.ph';
	}
	if(defined(&CONFIG_DEBUG_SPINLOCK)) {
	    eval 'sub spin_lock_init {
	        my($lock) = @_;
    		eval q( &do {  &static 1;  &__spin_lock_init(($lock), $lock, & &__key); }  &while (0));
	    }' unless defined(&spin_lock_init);
	} else {
	    eval 'sub spin_lock_init {
	        my($lock) = @_;
    		eval q( &do { *($lock) =  &SPIN_LOCK_UNLOCKED; }  &while (0));
	    }' unless defined(&spin_lock_init);
	}
	if(defined(&CONFIG_DEBUG_SPINLOCK)) {
	    eval 'sub rwlock_init {
	        my($lock) = @_;
    		eval q( &do {  &static 1;  &__rwlock_init(($lock), $lock, & &__key); }  &while (0));
	    }' unless defined(&rwlock_init);
	} else {
	    eval 'sub rwlock_init {
	        my($lock) = @_;
    		eval q( &do { *($lock) =  &RW_LOCK_UNLOCKED; }  &while (0));
	    }' unless defined(&rwlock_init);
	}
	eval 'sub spin_is_locked {
	    my($lock) = @_;
    	    eval q( &__raw_spin_is_locked(($lock)-> &raw_lock));
	}' unless defined(&spin_is_locked);
	eval 'sub spin_unlock_wait {
	    my($lock) = @_;
    	    eval q( &__raw_spin_unlock_wait(($lock)-> &raw_lock));
	}' unless defined(&spin_unlock_wait);
	if(defined( &CONFIG_SMP) || defined( &CONFIG_DEBUG_SPINLOCK)) {
	    require 'linux/spinlock_api_smp.ph';
	} else {
	    require 'linux/spinlock_api_up.ph';
	}
	if(defined(&CONFIG_DEBUG_SPINLOCK)) {
	    eval 'sub _raw_spin_lock_flags {
	        my($lock, $flags) = @_;
    		eval q( &_raw_spin_lock($lock));
	    }' unless defined(&_raw_spin_lock_flags);
	} else {
	    eval 'sub _raw_spin_lock {
	        my($lock) = @_;
    		eval q( &__raw_spin_lock(($lock)-> &raw_lock));
	    }' unless defined(&_raw_spin_lock);
	    eval 'sub _raw_spin_lock_flags {
	        my($lock, $flags) = @_;
    		eval q( &__raw_spin_lock_flags(($lock)-> &raw_lock, *($flags)));
	    }' unless defined(&_raw_spin_lock_flags);
	    eval 'sub _raw_spin_trylock {
	        my($lock) = @_;
    		eval q( &__raw_spin_trylock(($lock)-> &raw_lock));
	    }' unless defined(&_raw_spin_trylock);
	    eval 'sub _raw_spin_unlock {
	        my($lock) = @_;
    		eval q( &__raw_spin_unlock(($lock)-> &raw_lock));
	    }' unless defined(&_raw_spin_unlock);
	    eval 'sub _raw_read_lock {
	        my($rwlock) = @_;
    		eval q( &__raw_read_lock(($rwlock)-> &raw_lock));
	    }' unless defined(&_raw_read_lock);
	    eval 'sub _raw_read_trylock {
	        my($rwlock) = @_;
    		eval q( &__raw_read_trylock(($rwlock)-> &raw_lock));
	    }' unless defined(&_raw_read_trylock);
	    eval 'sub _raw_read_unlock {
	        my($rwlock) = @_;
    		eval q( &__raw_read_unlock(($rwlock)-> &raw_lock));
	    }' unless defined(&_raw_read_unlock);
	    eval 'sub _raw_write_lock {
	        my($rwlock) = @_;
    		eval q( &__raw_write_lock(($rwlock)-> &raw_lock));
	    }' unless defined(&_raw_write_lock);
	    eval 'sub _raw_write_trylock {
	        my($rwlock) = @_;
    		eval q( &__raw_write_trylock(($rwlock)-> &raw_lock));
	    }' unless defined(&_raw_write_trylock);
	    eval 'sub _raw_write_unlock {
	        my($rwlock) = @_;
    		eval q( &__raw_write_unlock(($rwlock)-> &raw_lock));
	    }' unless defined(&_raw_write_unlock);
	}
	eval 'sub read_can_lock {
	    my($rwlock) = @_;
    	    eval q( &__raw_read_can_lock(($rwlock)-> &raw_lock));
	}' unless defined(&read_can_lock);
	eval 'sub write_can_lock {
	    my($rwlock) = @_;
    	    eval q( &__raw_write_can_lock(($rwlock)-> &raw_lock));
	}' unless defined(&write_can_lock);
	eval 'sub spin_trylock {
	    my($lock) = @_;
    	    eval q( &__cond_lock( &_spin_trylock($lock)));
	}' unless defined(&spin_trylock);
	eval 'sub read_trylock {
	    my($lock) = @_;
    	    eval q( &__cond_lock( &_read_trylock($lock)));
	}' unless defined(&read_trylock);
	eval 'sub write_trylock {
	    my($lock) = @_;
    	    eval q( &__cond_lock( &_write_trylock($lock)));
	}' unless defined(&write_trylock);
	eval 'sub spin_lock {
	    my($lock) = @_;
    	    eval q( &_spin_lock($lock));
	}' unless defined(&spin_lock);
	if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	    eval 'sub spin_lock_nested {
	        my($lock, $subclass) = @_;
    		eval q( &_spin_lock_nested($lock, $subclass));
	    }' unless defined(&spin_lock_nested);
	} else {
	    eval 'sub spin_lock_nested {
	        my($lock, $subclass) = @_;
    		eval q( &_spin_lock($lock));
	    }' unless defined(&spin_lock_nested);
	}
	eval 'sub write_lock {
	    my($lock) = @_;
    	    eval q( &_write_lock($lock));
	}' unless defined(&write_lock);
	eval 'sub read_lock {
	    my($lock) = @_;
    	    eval q( &_read_lock($lock));
	}' unless defined(&read_lock);
	if(defined( &CONFIG_SMP) || defined( &CONFIG_DEBUG_SPINLOCK)) {
	    eval 'sub spin_lock_irqsave {
	        my($lock, $flags) = @_;
    		eval q($flags =  &_spin_lock_irqsave($lock));
	    }' unless defined(&spin_lock_irqsave);
	    eval 'sub read_lock_irqsave {
	        my($lock, $flags) = @_;
    		eval q($flags =  &_read_lock_irqsave($lock));
	    }' unless defined(&read_lock_irqsave);
	    eval 'sub write_lock_irqsave {
	        my($lock, $flags) = @_;
    		eval q($flags =  &_write_lock_irqsave($lock));
	    }' unless defined(&write_lock_irqsave);
	} else {
	    eval 'sub spin_lock_irqsave {
	        my($lock, $flags) = @_;
    		eval q( &_spin_lock_irqsave($lock, $flags));
	    }' unless defined(&spin_lock_irqsave);
	    eval 'sub read_lock_irqsave {
	        my($lock, $flags) = @_;
    		eval q( &_read_lock_irqsave($lock, $flags));
	    }' unless defined(&read_lock_irqsave);
	    eval 'sub write_lock_irqsave {
	        my($lock, $flags) = @_;
    		eval q( &_write_lock_irqsave($lock, $flags));
	    }' unless defined(&write_lock_irqsave);
	}
	eval 'sub spin_lock_irq {
	    my($lock) = @_;
    	    eval q( &_spin_lock_irq($lock));
	}' unless defined(&spin_lock_irq);
	eval 'sub spin_lock_bh {
	    my($lock) = @_;
    	    eval q( &_spin_lock_bh($lock));
	}' unless defined(&spin_lock_bh);
	eval 'sub read_lock_irq {
	    my($lock) = @_;
    	    eval q( &_read_lock_irq($lock));
	}' unless defined(&read_lock_irq);
	eval 'sub read_lock_bh {
	    my($lock) = @_;
    	    eval q( &_read_lock_bh($lock));
	}' unless defined(&read_lock_bh);
	eval 'sub write_lock_irq {
	    my($lock) = @_;
    	    eval q( &_write_lock_irq($lock));
	}' unless defined(&write_lock_irq);
	eval 'sub write_lock_bh {
	    my($lock) = @_;
    	    eval q( &_write_lock_bh($lock));
	}' unless defined(&write_lock_bh);
	if(defined( &CONFIG_DEBUG_SPINLOCK) || defined( &CONFIG_PREEMPT) || !defined( &CONFIG_SMP)) {
	    eval 'sub spin_unlock {
	        my($lock) = @_;
    		eval q( &_spin_unlock($lock));
	    }' unless defined(&spin_unlock);
	    eval 'sub read_unlock {
	        my($lock) = @_;
    		eval q( &_read_unlock($lock));
	    }' unless defined(&read_unlock);
	    eval 'sub write_unlock {
	        my($lock) = @_;
    		eval q( &_write_unlock($lock));
	    }' unless defined(&write_unlock);
	    eval 'sub spin_unlock_irq {
	        my($lock) = @_;
    		eval q( &_spin_unlock_irq($lock));
	    }' unless defined(&spin_unlock_irq);
	    eval 'sub read_unlock_irq {
	        my($lock) = @_;
    		eval q( &_read_unlock_irq($lock));
	    }' unless defined(&read_unlock_irq);
	    eval 'sub write_unlock_irq {
	        my($lock) = @_;
    		eval q( &_write_unlock_irq($lock));
	    }' unless defined(&write_unlock_irq);
	} else {
	    eval 'sub spin_unlock {
	        my($lock) = @_;
    		eval q( &__raw_spin_unlock(($lock)-> &raw_lock));
	    }' unless defined(&spin_unlock);
	    eval 'sub read_unlock {
	        my($lock) = @_;
    		eval q( &__raw_read_unlock(($lock)-> &raw_lock));
	    }' unless defined(&read_unlock);
	    eval 'sub write_unlock {
	        my($lock) = @_;
    		eval q( &__raw_write_unlock(($lock)-> &raw_lock));
	    }' unless defined(&write_unlock);
	    eval 'sub spin_unlock_irq {
	        my($lock) = @_;
    		eval q( &do {  &__raw_spin_unlock(($lock)-> &raw_lock);  &local_irq_enable(); }  &while (0));
	    }' unless defined(&spin_unlock_irq);
	    eval 'sub read_unlock_irq {
	        my($lock) = @_;
    		eval q( &do {  &__raw_read_unlock(($lock)-> &raw_lock);  &local_irq_enable(); }  &while (0));
	    }' unless defined(&read_unlock_irq);
	    eval 'sub write_unlock_irq {
	        my($lock) = @_;
    		eval q( &do {  &__raw_write_unlock(($lock)-> &raw_lock);  &local_irq_enable(); }  &while (0));
	    }' unless defined(&write_unlock_irq);
	}
	eval 'sub spin_unlock_irqrestore {
	    my($lock, $flags) = @_;
    	    eval q( &_spin_unlock_irqrestore($lock, $flags));
	}' unless defined(&spin_unlock_irqrestore);
	eval 'sub spin_unlock_bh {
	    my($lock) = @_;
    	    eval q( &_spin_unlock_bh($lock));
	}' unless defined(&spin_unlock_bh);
	eval 'sub read_unlock_irqrestore {
	    my($lock, $flags) = @_;
    	    eval q( &_read_unlock_irqrestore($lock, $flags));
	}' unless defined(&read_unlock_irqrestore);
	eval 'sub read_unlock_bh {
	    my($lock) = @_;
    	    eval q( &_read_unlock_bh($lock));
	}' unless defined(&read_unlock_bh);
	eval 'sub write_unlock_irqrestore {
	    my($lock, $flags) = @_;
    	    eval q( &_write_unlock_irqrestore($lock, $flags));
	}' unless defined(&write_unlock_irqrestore);
	eval 'sub write_unlock_bh {
	    my($lock) = @_;
    	    eval q( &_write_unlock_bh($lock));
	}' unless defined(&write_unlock_bh);
	eval 'sub spin_trylock_bh {
	    my($lock) = @_;
    	    eval q( &__cond_lock( &_spin_trylock_bh($lock)));
	}' unless defined(&spin_trylock_bh);
	eval 'sub spin_trylock_irq {
	    my($lock) = @_;
    	    eval q(({  &local_irq_disable();  &_spin_trylock($lock) ? 1: ({  &local_irq_enable(); 0; }); }));
	}' unless defined(&spin_trylock_irq);
	eval 'sub spin_trylock_irqsave {
	    my($lock, $flags) = @_;
    	    eval q(({  &local_irq_save($flags);  &_spin_trylock($lock) ? 1: ({  &local_irq_restore($flags); 0; }); }));
	}' unless defined(&spin_trylock_irqsave);
	require 'asm/atomic.ph';
	eval 'sub atomic_dec_and_lock {
	    my($atomic, $lock) = @_;
    	    eval q( &__cond_lock( &_atomic_dec_and_lock($atomic, $lock)));
	}' unless defined(&atomic_dec_and_lock);
	eval 'sub spin_can_lock {
	    my($lock) = @_;
    	    eval q((! &spin_is_locked($lock)));
	}' unless defined(&spin_can_lock);
    }
}
1;
