# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-video/vstrip/vstrip-0.8f.ebuild,v 1.6 2008/12/19 12:42:48 aballier Exp $

inherit eutils toolchain-funcs

DESCRIPTION="A program to split non-css dvd vobs into individual chapters"
HOMEPAGE="http://www.maven.de/code"
SRC_URI="http://files.digital-digest.com/downloads/files/encode/vStrip_${PV/./}.zip"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~ppc ~x86"
IUSE=""

DEPEND="app-arch/unzip"
RDEPEND=""

S="${WORKDIR}/${PN}"

src_unpack() {
	unpack ${A}
	cd "${S}"

	epatch "${FILESDIR}"/${P}-gentoo.patch
	edos2unix *.c *.h

	for file in *.c *.h ; do
		echo >>$file
	done
}

src_compile() {
	emake CFLAGS="${CFLAGS} -D__UNIX__" CC="$(tc-getCC)" || die "emake failed."
}

src_install() {
	dobin vstrip
}
