/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class GenericGrowableArray
extends VMObject {
    private static AddressField _arena_field;
    private static CIntField _max_field;
    private static CIntField _len_field;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("GenericGrowableArray");
        _arena_field = type.getAddressField("_arena");
        _max_field = new CIntField(type.getCIntegerField("_max"), 0L);
        _len_field = new CIntField(type.getCIntegerField("_len"), 0L);
    }

    public int max() {
        return (int)_max_field.getValue(this.getAddress());
    }

    public int length() {
        return (int)_len_field.getValue(this.getAddress());
    }

    public GenericGrowableArray(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                GenericGrowableArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

