# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("dsprop.dll")
prototypes = \
    {
        #
        'ADsPropCreateNotifyObj': SimTypeFunction([SimTypeBottom(label="IDataObject"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAppThdDataObj", "pwzADsObjName", "phNotifyObj"]),
        #
        'ADsPropGetInitInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hr": SimTypeInt(signed=True, label="Int32"), "pDsObj": SimTypeBottom(label="IDirectoryObject"), "pwzCN": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pWritableAttrs": SimTypePointer(SimStruct({"pszAttrName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwControlCode": SimTypeInt(signed=False, label="UInt32"), "dwADsType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "pADsValues": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "Anonymous": SimUnion({"DNString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseExactString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseIgnoreString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PrintableString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "NumericString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Boolean": SimTypeInt(signed=False, label="UInt32"), "Integer": SimTypeInt(signed=False, label="UInt32"), "OctetString": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_STRING", pack=False, align=None), "UTCTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "LargeInteger": SimTypeBottom(label="LARGE_INTEGER"), "ClassName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ProviderSpecific": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_PROV_SPECIFIC", pack=False, align=None), "pCaseIgnoreList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_CASEIGNORE_LIST"), offset=0), "String": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_CASEIGNORE_LIST", pack=False, align=None), offset=0), "pOctetList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_OCTET_LIST"), offset=0), "Length": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_LIST", pack=False, align=None), offset=0), "pPath": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "VolumeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Path": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_PATH", pack=False, align=None), offset=0), "pPostalAddress": SimTypePointer(SimStruct({"PostalAddress": SimTypeFixedSizeArray(SimTypePointer(SimTypeChar(label="Char"), offset=0), 6)}, name="ADS_POSTALADDRESS", pack=False, align=None), offset=0), "Timestamp": SimStruct({"WholeSeconds": SimTypeInt(signed=False, label="UInt32"), "EventID": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TIMESTAMP", pack=False, align=None), "BackLink": SimStruct({"RemoteID": SimTypeInt(signed=False, label="UInt32"), "ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_BACKLINK", pack=False, align=None), "pTypedName": SimTypePointer(SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Level": SimTypeInt(signed=False, label="UInt32"), "Interval": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TYPEDNAME", pack=False, align=None), offset=0), "Hold": SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Amount": SimTypeInt(signed=False, label="UInt32")}, name="ADS_HOLD", pack=False, align=None), "pNetAddress": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0), "pReplicaPointer": SimTypePointer(SimStruct({"ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ReplicaType": SimTypeInt(signed=False, label="UInt32"), "ReplicaNumber": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "ReplicaAddressHints": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0)}, name="ADS_REPLICAPOINTER", pack=False, align=None), offset=0), "pFaxNumber": SimTypePointer(SimStruct({"TelephoneNumber": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NumberOfBits": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_FAXNUMBER", pack=False, align=None), offset=0), "Email": SimStruct({"Address": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Type": SimTypeInt(signed=False, label="UInt32")}, name="ADS_EMAIL", pack=False, align=None), "SecurityDescriptor": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NT_SECURITY_DESCRIPTOR", pack=False, align=None), "pDNWithBinary": SimTypePointer(SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpBinaryValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_BINARY", pack=False, align=None), offset=0), "pDNWithString": SimTypePointer(SimStruct({"pszStringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_STRING", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="ADSVALUE", pack=False, align=None), offset=0), "dwNumValues": SimTypeInt(signed=False, label="UInt32")}, name="ADS_ATTR_INFO", pack=False, align=None), offset=0)}, name="ADSPROPINITPARAMS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNotifyObj", "pInitParams"]),
        #
        'ADsPropSetHwndWithTitle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNotifyObj", "hPage", "ptzTitle"]),
        #
        'ADsPropSetHwnd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNotifyObj", "hPage"]),
        #
        'ADsPropCheckIfWritable': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pszAttrName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwControlCode": SimTypeInt(signed=False, label="UInt32"), "dwADsType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "pADsValues": SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "Anonymous": SimUnion({"DNString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseExactString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseIgnoreString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PrintableString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "NumericString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Boolean": SimTypeInt(signed=False, label="UInt32"), "Integer": SimTypeInt(signed=False, label="UInt32"), "OctetString": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_STRING", pack=False, align=None), "UTCTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "LargeInteger": SimTypeBottom(label="LARGE_INTEGER"), "ClassName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ProviderSpecific": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_PROV_SPECIFIC", pack=False, align=None), "pCaseIgnoreList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_CASEIGNORE_LIST"), offset=0), "String": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_CASEIGNORE_LIST", pack=False, align=None), offset=0), "pOctetList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_OCTET_LIST"), offset=0), "Length": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_LIST", pack=False, align=None), offset=0), "pPath": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "VolumeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Path": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_PATH", pack=False, align=None), offset=0), "pPostalAddress": SimTypePointer(SimStruct({"PostalAddress": SimTypeFixedSizeArray(SimTypePointer(SimTypeChar(label="Char"), offset=0), 6)}, name="ADS_POSTALADDRESS", pack=False, align=None), offset=0), "Timestamp": SimStruct({"WholeSeconds": SimTypeInt(signed=False, label="UInt32"), "EventID": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TIMESTAMP", pack=False, align=None), "BackLink": SimStruct({"RemoteID": SimTypeInt(signed=False, label="UInt32"), "ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_BACKLINK", pack=False, align=None), "pTypedName": SimTypePointer(SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Level": SimTypeInt(signed=False, label="UInt32"), "Interval": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TYPEDNAME", pack=False, align=None), offset=0), "Hold": SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Amount": SimTypeInt(signed=False, label="UInt32")}, name="ADS_HOLD", pack=False, align=None), "pNetAddress": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0), "pReplicaPointer": SimTypePointer(SimStruct({"ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ReplicaType": SimTypeInt(signed=False, label="UInt32"), "ReplicaNumber": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "ReplicaAddressHints": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0)}, name="ADS_REPLICAPOINTER", pack=False, align=None), offset=0), "pFaxNumber": SimTypePointer(SimStruct({"TelephoneNumber": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NumberOfBits": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_FAXNUMBER", pack=False, align=None), offset=0), "Email": SimStruct({"Address": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Type": SimTypeInt(signed=False, label="UInt32")}, name="ADS_EMAIL", pack=False, align=None), "SecurityDescriptor": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NT_SECURITY_DESCRIPTOR", pack=False, align=None), "pDNWithBinary": SimTypePointer(SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpBinaryValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_BINARY", pack=False, align=None), offset=0), "pDNWithString": SimTypePointer(SimStruct({"pszStringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_STRING", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="ADSVALUE", pack=False, align=None), offset=0), "dwNumValues": SimTypeInt(signed=False, label="UInt32")}, name="ADS_ATTR_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzAttr", "pWritableAttrs"]),
        #
        'ADsPropSendErrorMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"hwndPage": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszPageTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszObjPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszObjClass": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hr": SimTypeInt(signed=True, label="Int32"), "pszError": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADSPROPERROR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNotifyObj", "pError"]),
        #
        'ADsPropShowErrorDialog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hNotifyObj", "hPage"]),
    }

lib.set_prototypes(prototypes)
