/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.exportrepository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.exportrepository.Messages;
import org.pentaho.di.job.entries.sftp.JobEntrySFTP;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.UserInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryExportRepository
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String repositoryname;
    private String username;
    private String password;
    private String targetfilename;
    private String iffileexists;
    private String export_type;
    private String directoryPath;
    public String If_FileExists_Skip = "if_file_exists_skip";
    public String If_FileExists_Fail = "if_file_exists_fail";
    public String If_FileExists_Overwrite = "if_file_exists_overwrite";
    public String If_FileExists_Uniquename = "if_file_exists_uniquename";
    public String Export_All = "export_all";
    public String Export_Jobs = "export_jobs";
    public String Export_Trans = "export_trans";
    public String Export_By_Folder = "export_by_folder";
    public String Export_One_Folder = "export_one_folder";
    private boolean add_date;
    private boolean add_time;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean createfolder;
    private boolean newfolder;
    private boolean add_result_filesname;
    private String nr_errors_less_than;
    private String success_condition;
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    FileObject file = null;
    RepositoriesMeta repsinfo = null;
    Repository repo = null;
    RepositoryMeta repinfo = null;
    UserInfo userinfo = null;
    int NrErrors = 0;
    boolean successConditionBroken = false;
    int limitErr = 0;

    public JobEntryExportRepository(String n) {
        super(n, "");
        this.repositoryname = null;
        this.targetfilename = null;
        this.username = null;
        this.iffileexists = this.If_FileExists_Skip;
        this.export_type = this.Export_All;
        this.add_date = false;
        this.add_time = false;
        this.SpecifyFormat = false;
        this.date_time_format = null;
        this.createfolder = false;
        this.newfolder = false;
        this.add_result_filesname = false;
        this.nr_errors_less_than = "10";
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.EXPORT_REPOSITORY);
    }

    public JobEntryExportRepository() {
        this("");
    }

    public JobEntryExportRepository(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryExportRepository je = (JobEntryExportRepository)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"repositoryname", (String)this.repositoryname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetfilename", (String)this.targetfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"export_type", (String)this.export_type));
        retval.append("      ").append(XMLHandler.addTagValue((String)"directoryPath", (String)this.directoryPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createfolder", (boolean)this.createfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"newfolder", (boolean)this.newfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.repositoryname = XMLHandler.getTagValue((Node)entrynode, (String)"repositoryname");
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.targetfilename = XMLHandler.getTagValue((Node)entrynode, (String)"targetfilename");
            this.iffileexists = XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists");
            this.export_type = XMLHandler.getTagValue((Node)entrynode, (String)"export_type");
            this.directoryPath = XMLHandler.getTagValue((Node)entrynode, (String)"directoryPath");
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.createfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createfolder"));
            this.newfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"newfolder"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobExportRepository.Meta.UnableLoadXML"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.repositoryname = rep.getJobEntryAttributeString(id_jobentry, "repositoryname");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.targetfilename = rep.getJobEntryAttributeString(id_jobentry, "targetfilename");
            this.iffileexists = rep.getJobEntryAttributeString(id_jobentry, "iffileexists");
            this.export_type = rep.getJobEntryAttributeString(id_jobentry, "export_type");
            this.directoryPath = rep.getJobEntryAttributeString(id_jobentry, "directoryPath");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.createfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createfolder");
            this.newfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "newfolder");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobExportRepository.Meta.UnableLoadRep", "" + id_jobentry), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "repositoryname", this.repositoryname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.username);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "targetfilename", this.targetfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "export_type", this.export_type);
            rep.saveJobEntryAttribute(id_job, this.getID(), "directoryPath", this.directoryPath);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createfolder", this.createfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "newfolder", this.newfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobExportRepository.Meta.UnableSaveRep", "" + id_job), (Throwable)dbe);
        }
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setRepositoryname(String repositoryname) {
        this.repositoryname = repositoryname;
    }

    public String getRepositoryname() {
        return this.repositoryname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setExportType(String export_type) {
        this.export_type = export_type;
    }

    public String getExportType() {
        return this.export_type;
    }

    public void setIfFileExists(String iffileexists) {
        this.iffileexists = iffileexists;
    }

    public String getIfFileExists() {
        return this.iffileexists;
    }

    public void setTargetfilename(String targetfilename) {
        this.targetfilename = targetfilename;
    }

    public String getTargetfilename() {
        return this.targetfilename;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDirectory() {
        return this.directoryPath;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public boolean isCreateFolder() {
        return this.createfolder;
    }

    public void setCreateFolder(boolean createfolder) {
        this.createfolder = createfolder;
    }

    public void setNewFolder(boolean newfolder) {
        this.newfolder = newfolder;
    }

    public boolean isNewFolder() {
        return this.newfolder;
    }

    public void setDirectory(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public boolean isAddresultfilesname() {
        return this.add_result_filesname;
    }

    public void setNrLimit(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrLimit() {
        return this.nr_errors_less_than;
    }

    public String buildFilename(String filename) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        int lenstring = filename.length();
        int lastindexOfDot = filename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = filename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    public String buildUniqueFilename(String filename) {
        String retval = "";
        if (Const.isEmpty((String)filename)) {
            return null;
        }
        int lenstring = filename.length();
        int lastindexOfDot = filename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = filename.substring(0, lastindexOfDot);
        retval = retval + StringUtil.getFormattedDateTimeNow();
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block101: {
            block98: {
                block99: {
                    block100: {
                        block93: {
                            block97: {
                                block95: {
                                    block96: {
                                        block88: {
                                            block94: {
                                                block91: {
                                                    block92: {
                                                        block89: {
                                                            block90: {
                                                                log = LogWriter.getInstance();
                                                                result = previousResult;
                                                                result.setNrErrors(1L);
                                                                result.setResult(false);
                                                                realrepName = this.environmentSubstitute(this.repositoryname);
                                                                realusername = this.environmentSubstitute(this.username);
                                                                realpassword = this.environmentSubstitute(this.password);
                                                                realfoldername = this.environmentSubstitute(this.directoryPath);
                                                                realoutfilename = this.environmentSubstitute(this.targetfilename);
                                                                if (this.export_type.equals(this.Export_All) || this.export_type.equals(this.Export_Jobs) || this.export_type.equals(this.Export_Trans) || this.export_type.equals(this.Export_One_Folder)) {
                                                                    realoutfilename = this.buildFilename(realoutfilename);
                                                                }
                                                                this.NrErrors = 0;
                                                                this.successConditionBroken = false;
                                                                this.limitErr = Const.toInt((String)this.environmentSubstitute(this.getNrLimit()), (int)10);
                                                                this.file = KettleVFS.getFileObject((String)realoutfilename);
                                                                if (!this.file.exists()) break block88;
                                                                if (!this.export_type.equals(this.Export_All) && !this.export_type.equals(this.Export_Jobs) && !this.export_type.equals(this.Export_Trans) && !this.export_type.equals(this.Export_One_Folder)) ** GOTO lbl82
                                                                if (!this.iffileexists.equals(this.If_FileExists_Fail)) break block89;
                                                                log.logError(this.toString(), Messages.getString("JobExportRepository.Log.Failing", realoutfilename), new Object[0]);
                                                                var12_12 = result;
                                                                var17_19 = null;
                                                                if (this.repo != null) {
                                                                    this.repo.disconnect();
                                                                    this.repo = null;
                                                                }
                                                                if (this.repinfo != null) {
                                                                    this.repinfo = null;
                                                                }
                                                                if (this.userinfo != null) {
                                                                    this.userinfo = null;
                                                                }
                                                                if (this.repsinfo != null) {
                                                                    this.repsinfo.clear();
                                                                    this.repsinfo = null;
                                                                }
                                                                if (this.file == null) break block90;
                                                                try {
                                                                    this.file.close();
                                                                    this.file = null;
                                                                }
                                                                catch (Exception e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            return var12_12;
                                                        }
                                                        if (!this.iffileexists.equals(this.If_FileExists_Skip)) break block91;
                                                        if (log.isDetailed()) {
                                                            log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.Exit", realoutfilename), new Object[0]);
                                                        }
                                                        result.setResult(true);
                                                        result.setNrErrors(0L);
                                                        var12_13 = result;
                                                        var17_20 = null;
                                                        if (this.repo != null) {
                                                            this.repo.disconnect();
                                                            this.repo = null;
                                                        }
                                                        if (this.repinfo != null) {
                                                            this.repinfo = null;
                                                        }
                                                        if (this.userinfo != null) {
                                                            this.userinfo = null;
                                                        }
                                                        if (this.repsinfo != null) {
                                                            this.repsinfo.clear();
                                                            this.repsinfo = null;
                                                        }
                                                        if (this.file == null) break block92;
                                                        try {
                                                            this.file.close();
                                                            this.file = null;
                                                        }
                                                        catch (Exception e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    return var12_13;
                                                }
                                                if (this.iffileexists.equals(this.If_FileExists_Uniquename)) {
                                                    parentFolder = KettleVFS.getFilename((FileObject)this.file.getParent());
                                                    shortFilename = this.file.getName().getBaseName();
                                                    shortFilename = this.buildUniqueFilename(shortFilename);
                                                    this.file = KettleVFS.getFileObject((String)(parentFolder + Const.FILE_SEPARATOR + shortFilename));
                                                    if (log.isDetailed()) {
                                                        log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.NewFilename", this.file.toString()), new Object[0]);
                                                    }
                                                }
                                                break block93;
lbl82:
                                                // 1 sources

                                                if (!this.export_type.equals(this.Export_By_Folder) || this.file.getType() == FileType.FOLDER) break block93;
                                                log.logError(this.toString(), Messages.getString("JobExportRepository.Log.NotFolder", "" + this.file.getName()), new Object[0]);
                                                parentFolder = result;
                                                var17_21 = null;
                                                if (this.repo != null) {
                                                    this.repo.disconnect();
                                                    this.repo = null;
                                                }
                                                if (this.repinfo != null) {
                                                    this.repinfo = null;
                                                }
                                                if (this.userinfo != null) {
                                                    this.userinfo = null;
                                                }
                                                if (this.repsinfo != null) {
                                                    this.repsinfo.clear();
                                                    this.repsinfo = null;
                                                }
                                                if (this.file == null) break block94;
                                                try {
                                                    this.file.close();
                                                    this.file = null;
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                            }
                                            return parentFolder;
                                        }
                                        if (!this.export_type.equals(this.Export_By_Folder)) ** GOTO lbl140
                                        if (log.isDetailed()) {
                                            log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.FolderNotExists", "" + this.file.getName()), new Object[0]);
                                        }
                                        if (this.createfolder) break block95;
                                        parentFolder = result;
                                        var17_22 = null;
                                        if (this.repo != null) {
                                            this.repo.disconnect();
                                            this.repo = null;
                                        }
                                        if (this.repinfo != null) {
                                            this.repinfo = null;
                                        }
                                        if (this.userinfo != null) {
                                            this.userinfo = null;
                                        }
                                        if (this.repsinfo != null) {
                                            this.repsinfo.clear();
                                            this.repsinfo = null;
                                        }
                                        if (this.file == null) break block96;
                                        try {
                                            this.file.close();
                                            this.file = null;
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    return parentFolder;
                                }
                                this.file.createFolder();
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.FolderCreated", this.file.toString()), new Object[0]);
                                }
                                break block93;
lbl140:
                                // 1 sources

                                if (!this.export_type.equals(this.Export_All) && !this.export_type.equals(this.Export_Jobs) && !this.export_type.equals(this.Export_Trans) && !this.export_type.equals(this.Export_One_Folder) || this.file.getParent().exists()) break block93;
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.FolderNotExists", "" + this.file.getParent().toString()), new Object[0]);
                                }
                                if (this.createfolder) {
                                    this.file.getParent().createFolder();
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.FolderCreated", this.file.getParent().toString()), new Object[0]);
                                    }
                                    break block93;
                                }
                                parentFolder = result;
                                var17_23 = null;
                                if (this.repo != null) {
                                    this.repo.disconnect();
                                    this.repo = null;
                                }
                                if (this.repinfo != null) {
                                    this.repinfo = null;
                                }
                                if (this.userinfo != null) {
                                    this.userinfo = null;
                                }
                                if (this.repsinfo != null) {
                                    this.repsinfo.clear();
                                    this.repsinfo = null;
                                }
                                if (this.file == null) break block97;
                                try {
                                    this.file.close();
                                    this.file = null;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            return parentFolder;
                        }
                        realoutfilename = KettleVFS.getFilename((FileObject)this.file);
                        this.connectRep(log, realrepName, realusername, realpassword);
                        if (this.export_type.equals(this.Export_All)) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.StartingExportAllRep", realoutfilename), new Object[0]);
                            }
                            this.repo.exportAllObjects(null, realoutfilename, null, "all");
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.EndExportAllRep", realoutfilename), new Object[0]);
                            }
                            if (this.add_result_filesname) {
                                this.addFileToResultFilenames(realoutfilename, log, result, parentJob);
                            }
                            break block98;
                        }
                        if (this.export_type.equals(this.Export_Jobs)) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.StartingExportJobsRep", realoutfilename), new Object[0]);
                            }
                            this.repo.exportAllObjects(null, realoutfilename, null, "jobs");
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.EndExportJobsRep", realoutfilename), new Object[0]);
                            }
                            if (this.add_result_filesname) {
                                this.addFileToResultFilenames(realoutfilename, log, result, parentJob);
                            }
                            break block98;
                        }
                        if (this.export_type.equals(this.Export_Trans)) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.StartingExportTransRep", realoutfilename), new Object[0]);
                            }
                            this.repo.exportAllObjects(null, realoutfilename, null, "trans");
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.EndExportTransRep", realoutfilename), new Object[0]);
                            }
                            if (this.add_result_filesname) {
                                this.addFileToResultFilenames(realoutfilename, log, result, parentJob);
                            }
                            break block98;
                        }
                        if (!this.export_type.equals(this.Export_One_Folder)) ** GOTO lbl240
                        directory = new RepositoryDirectory();
                        directory = this.repo.getDirectoryTree().findDirectory(realfoldername);
                        if (directory != null) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.ExpAllFolderRep", this.directoryPath, realoutfilename), new Object[0]);
                            }
                            this.repo.exportAllObjects(null, realoutfilename, directory, "all");
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.EndExpAllFolderRep", this.directoryPath, realoutfilename), new Object[0]);
                            }
                            if (this.add_result_filesname) {
                                this.addFileToResultFilenames(realoutfilename, log, result, parentJob);
                            }
                            break block99;
                        }
                        log.logError(this.toString(), Messages.getString("JobExportRepository.Error.CanNotFindFolderInRep", realfoldername, realrepName), new Object[0]);
                        shortFilename = result;
                        var17_24 = null;
                        if (this.repo != null) {
                            this.repo.disconnect();
                            this.repo = null;
                        }
                        if (this.repinfo != null) {
                            this.repinfo = null;
                        }
                        if (this.userinfo != null) {
                            this.userinfo = null;
                        }
                        if (this.repsinfo != null) {
                            this.repsinfo.clear();
                            this.repsinfo = null;
                        }
                        if (this.file == null) break block100;
                        try {
                            this.file.close();
                            this.file = null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return shortFilename;
                }
                try {
                    break block98;
lbl240:
                    // 1 sources

                    if (!this.export_type.equals(this.Export_By_Folder)) break block98;
                    directory = new RepositoryDirectory();
                    directory = this.repo.getDirectoryTree().findRoot();
                    dirids = directory.getDirectoryIDs();
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.TotalFolders", "" + dirids.length), new Object[0]);
                    }
                    for (d = 0; d < dirids.length && !parentJob.isStopped(); ++d) {
                        if (this.successConditionBroken) {
                            log.logError(this.toString(), Messages.getString("JobExportRepository.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                            throw new Exception(Messages.getString("JobExportRepository.Error.SuccessConditionbroken", "" + this.NrErrors));
                        }
                        repdir = directory.findDirectory(dirids[d]);
                        if (this.processOneFolder(parentJob, result, log, repdir, realoutfilename, d, dirids.length)) continue;
                        this.updateErrors();
                    }
                }
                catch (Throwable var16_40) {
                    var17_27 = null;
                    if (this.repo != null) {
                        this.repo.disconnect();
                        this.repo = null;
                    }
                    if (this.repinfo != null) {
                        this.repinfo = null;
                    }
                    if (this.userinfo != null) {
                        this.userinfo = null;
                    }
                    if (this.repsinfo != null) {
                        this.repsinfo.clear();
                        this.repsinfo = null;
                    }
                    if (this.file != null) {
                        try {
                            this.file.close();
                            this.file = null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var16_40;
                }
            }
            var17_25 = null;
            if (this.repo != null) {
                this.repo.disconnect();
                this.repo = null;
            }
            if (this.repinfo != null) {
                this.repinfo = null;
            }
            if (this.userinfo != null) {
                this.userinfo = null;
            }
            if (this.repsinfo != null) {
                this.repsinfo.clear();
                this.repsinfo = null;
            }
            if (this.file != null) {
                try {
                    this.file.close();
                    this.file = null;
                }
                catch (Exception e) {}
            }
            break block101;
            {
                catch (Exception e) {
                    this.updateErrors();
                    log.logError(this.toString(), Messages.getString("JobExportRepository.UnExpectedError", e.toString()), new Object[0]);
                    log.logError(this.toString(), "Stack trace: " + Const.CR + Const.getStackTracker((Throwable)e), new Object[0]);
                    var17_26 = null;
                    if (this.repo != null) {
                        this.repo.disconnect();
                        this.repo = null;
                    }
                    if (this.repinfo != null) {
                        this.repinfo = null;
                    }
                    if (this.userinfo != null) {
                        this.userinfo = null;
                    }
                    if (this.repsinfo != null) {
                        this.repsinfo.clear();
                        this.repsinfo = null;
                    }
                    if (this.file != null) {
                        try {
                            this.file.close();
                            this.file = null;
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        result.setNrErrors((long)this.NrErrors);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors <= this.limitErr && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean processOneFolder(Job parentJob, Result result, LogWriter log, RepositoryDirectory repdir, String realoutfilename, int folderno, int totalfolders) {
        boolean retval = false;
        try {
            if (!repdir.isRoot() && repdir.toString().lastIndexOf("/") == 0) {
                String filename = repdir.toString().replace("/", "");
                String foldername = realoutfilename;
                if (this.newfolder) {
                    foldername = realoutfilename + Const.FILE_SEPARATOR + filename;
                    this.file = KettleVFS.getFileObject((String)foldername);
                    if (!this.file.exists()) {
                        this.file.createFolder();
                    }
                }
                filename = foldername + Const.FILE_SEPARATOR + this.buildFilename(filename) + ".xml";
                this.file = KettleVFS.getFileObject((String)filename);
                if (this.file.exists()) {
                    if (this.iffileexists.equals(this.If_FileExists_Skip)) {
                        return true;
                    }
                    if (this.iffileexists.equals(this.If_FileExists_Uniquename)) {
                        filename = realoutfilename + Const.FILE_SEPARATOR + this.buildUniqueFilename(filename) + ".xml";
                    } else if (this.iffileexists.equals(this.If_FileExists_Fail)) {
                        return false;
                    }
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "---", new Object[0]);
                    log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.FolderProcessing", "" + folderno, "" + totalfolders), new Object[0]);
                    log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.OutFilename", repdir.toString(), filename), new Object[0]);
                }
                this.repo.exportAllObjects(null, filename, repdir, "all");
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobExportRepository.Log.OutFilenameEnd", repdir.toString(), filename), new Object[0]);
                }
                if (this.add_result_filesname) {
                    this.addFileToResultFilenames(filename, log, result, parentJob);
                }
            }
            retval = true;
        }
        catch (Exception e) {
            this.updateErrors();
            log.logError(this.toString(), Messages.getString("JobExportRepository.ErrorExportingFolder", repdir.toString(), e.toString()), new Object[0]);
        }
        return retval;
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitErr && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void connectRep(LogWriter log, String realrepName, String realusername, String realpassword) throws Exception {
        this.repsinfo = new RepositoriesMeta(log);
        if (!this.repsinfo.readData()) {
            log.logError(this.toString(), Messages.getString("JobExportRepository.Error.NoRep"), new Object[0]);
            throw new Exception(Messages.getString("JobExportRepository.Error.NoRep"));
        }
        this.repinfo = this.repsinfo.findRepository(realrepName);
        if (this.repinfo == null) {
            log.logError(this.toString(), Messages.getString("JobExportRepository.Error.NoRepSystem"), new Object[0]);
            throw new Exception(Messages.getString("JobExportRepository.Error.NoRepSystem"));
        }
        this.repo = new Repository(log, this.repinfo, this.userinfo);
        if (!this.repo.connect("Export job entry")) {
            log.logError(this.toString(), Messages.getString("JobExportRepository.Error.CanNotConnectRep"), new Object[0]);
            throw new Exception(Messages.getString("JobExportRepository.Error.CanNotConnectRep"));
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("JobExportRepository.Log.CheckSuppliedUserPass"), new Object[0]);
        }
        this.userinfo = new UserInfo(this.repo, realusername, realpassword);
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("JobExportRepository.Log.CheckingUser", this.userinfo.getName()), new Object[0]);
        }
        if (this.userinfo.getID() <= 0L) {
            log.logError(this.toString(), Messages.getString("JobExportRepository.Error.CanNotVerifyUserPass"), new Object[0]);
            throw new Exception(Messages.getString("JobExportRepository.Error.CanNotVerifyUserPass"));
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("JobExportRepository.Log.SuppliedUserPassVerified"), new Object[0]);
        }
    }

    private void addFileToResultFilenames(String fileaddentry, LogWriter log, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobExportRepository.Log.FileAddedToResultFilesName", fileaddentry), new Object[0]);
            }
        }
        catch (Exception e) {
            log.logError(Messages.getString("JobExportRepository.Error.AddingToFilenameResult"), fileaddentry + "" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "repositoryname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "targetfilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "username", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntrySFTP().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }
}

