/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.AddRemoveIcon;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPDataSourceTypeListCellRenderer;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.db.DataSourceTypeEditorPanel;
import ca.sqlpower.swingui.db.DataSourceTypeEditorTabPanel;
import ca.sqlpower.swingui.db.NewDataSourceTypePanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;

public class DataSourceTypeEditor
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(DataSourceTypeEditor.class);
    private final JPanel panel;
    private final DataSourceCollection<JDBCDataSource> dataSourceCollection;
    private final JList dsTypeList;
    private final JButton addDsTypeButton;
    private final JButton removeDsTypeButton;
    private final DataSourceTypeEditorPanel dsTypePanel;
    private final UndoManager undoManager = new UndoManager();
    private DefaultListModel dsTypeListModel;
    private final boolean enterprise;

    public DataSourceTypeEditor(DataSourceCollection<JDBCDataSource> dataSourceCollection, final Window owner, boolean enterprise) {
        this.dataSourceCollection = dataSourceCollection;
        this.enterprise = enterprise;
        this.dsTypeListModel = new DefaultListModel();
        dataSourceCollection.addUndoableEditListener(this.undoManager);
        for (JDBCDataSourceType type : dataSourceCollection.getDataSourceTypes()) {
            this.dsTypeListModel.addElement(type);
            type.addUndoableEditListener(this.undoManager);
        }
        this.dsTypeList = new JList(this.dsTypeListModel);
        this.dsTypeList.setCellRenderer(new SPDataSourceTypeListCellRenderer());
        this.addDsTypeButton = new JButton(new AddRemoveIcon(AddRemoveIcon.Type.ADD));
        this.addDsTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDataSourceTypePanel copyPropertiesPanel = new NewDataSourceTypePanel(DataSourceTypeEditor.this, DataSourceTypeEditor.this.dataSourceCollection);
                JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog(copyPropertiesPanel, owner, "Copy Properties", DataEntryPanelBuilder.OK_BUTTON_LABEL);
                d.pack();
                d.setLocationRelativeTo(owner);
                d.setVisible(true);
            }
        });
        this.removeDsTypeButton = new JButton(new AddRemoveIcon(AddRemoveIcon.Type.REMOVE));
        this.removeDsTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceTypeEditor.this.removeSelectedDsType();
            }
        });
        this.removeDsTypeButton.setEnabled(false);
        this.dsTypePanel = new DataSourceTypeEditorPanel(dataSourceCollection, owner);
        this.dsTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JDBCDataSourceType dst = (JDBCDataSourceType)DataSourceTypeEditor.this.dsTypeList.getSelectedValue();
                    DataSourceTypeEditor.this.switchToDsType(dst);
                }
                DataSourceTypeEditor.this.removeDsTypeButton.setEnabled(DataSourceTypeEditor.this.dsTypeList.getSelectedIndex() != -1);
            }
        });
        this.panel = this.createPanel();
    }

    public DataSourceTypeEditor(DataSourceCollection<JDBCDataSource> dataSourceCollection, Window owner) {
        this(dataSourceCollection, owner, false);
    }

    private void removeSelectedDsType() {
        JDBCDataSourceType type = (JDBCDataSourceType)this.dsTypeList.getSelectedValue();
        if (type != null) {
            ((DefaultListModel)this.dsTypeList.getModel()).removeElement(type);
            this.dataSourceCollection.removeDataSourceType(type);
        }
    }

    public void addDsType(JDBCDataSourceType type) {
        if (type == null) {
            throw new NullPointerException("Don't add null data source types, silly!");
        }
        this.dataSourceCollection.addDataSourceType(type);
        ((DefaultListModel)this.dsTypeList.getModel()).addElement(type);
        this.dsTypeList.setSelectedValue(type, true);
    }

    private JPanel createPanel() {
        FormLayout layout = new FormLayout("fill:max(60dlu;pref), 6dlu, pref:grow", "pref, 6dlu, pref:grow, 3dlu, pref");
        DefaultFormBuilder fb = new DefaultFormBuilder(layout);
        fb.setDefaultDialogBorder();
        JPanel addRemoveBar = new JPanel(new FlowLayout(0));
        addRemoveBar.add(this.addDsTypeButton);
        addRemoveBar.add(this.removeDsTypeButton);
        JScrollPane dsTypePane = new JScrollPane(this.dsTypeList);
        dsTypePane.setPreferredSize(new Dimension(0, 0));
        fb.add((Component)dsTypePane, "1, 1, 1, 3");
        fb.add((Component)addRemoveBar, "1, 5");
        fb.add((Component)this.dsTypePanel.getPanel(), "3, 1");
        return fb.getPanel();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public boolean applyChanges() {
        logger.debug((Object)"Applying changes to all data source types");
        this.applyCurrentChanges();
        ListModel lm = this.dsTypeList.getModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            JDBCDataSourceType dst = (JDBCDataSourceType)lm.getElementAt(i);
            this.dataSourceCollection.mergeDataSourceType(dst);
        }
        if (!this.enterprise) {
            try {
                this.dataSourceCollection.write();
            }
            catch (IOException ex) {
                SPSUtils.showExceptionDialogNoReport(this.panel, Messages.getString("DataSourceTypeEditor.errorSavingToPlDotIni"), ex);
            }
        }
        this.undoManager.discardAllEdits();
        return true;
    }

    @Override
    public void discardChanges() {
        logger.debug((Object)"Discarding changes to all data source types.");
        int undoCount = 0;
        while (this.undoManager.canUndo()) {
            ++undoCount;
            this.undoManager.undo();
        }
        logger.debug((Object)("There were " + undoCount + " changes."));
        this.dsTypePanel.discardChanges();
        this.dsTypeListModel.clear();
        for (JDBCDataSourceType type : this.dataSourceCollection.getDataSourceTypes()) {
            this.dsTypeListModel.addElement(type);
        }
    }

    public void cleanup() {
        for (JDBCDataSourceType type : this.dataSourceCollection.getDataSourceTypes()) {
            type.removeUndoableEditListener(this.undoManager);
        }
        this.dataSourceCollection.removeUndoableEditListener(this.undoManager);
    }

    public void switchToDsType(JDBCDataSourceType dst) {
        this.applyCurrentChanges();
        this.dsTypeList.setSelectedValue(dst, true);
        this.dsTypePanel.editDsType(dst);
    }

    private void applyCurrentChanges() {
        this.dsTypePanel.applyChanges();
    }

    public void addTab(String title, DataSourceTypeEditorTabPanel dataEntryPanel) {
        this.dsTypePanel.addTab(title, dataEntryPanel);
    }

    @Override
    public boolean hasUnsavedChanges() {
        return this.undoManager.canUndo();
    }
}

