/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.logging.LogFactory;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.util.StringUtils;

public class ClassLoaderResourceAccessor
extends AbstractResourceAccessor {
    private ClassLoader classLoader;

    public ClassLoaderResourceAccessor() {
        this.classLoader = this.getClass().getClassLoader();
        this.init();
    }

    public ClassLoaderResourceAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.init();
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        Enumeration<URL> resources = this.classLoader.getResources(path);
        if (resources == null || !resources.hasMoreElements()) {
            return null;
        }
        HashSet<String> seenUrls = new HashSet<String>();
        HashSet<InputStream> returnSet = new HashSet<InputStream>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (seenUrls.contains(url.toExternalForm())) continue;
            seenUrls.add(url.toExternalForm());
            LogFactory.getInstance().getLog().debug("Opening " + url.toExternalForm() + " as " + path);
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            InputStream resourceAsStream = connection.getInputStream();
            if (resourceAsStream == null) continue;
            returnSet.add(resourceAsStream);
        }
        return returnSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        path = this.convertToPath(relativeTo, path);
        Enumeration<URL> fileUrls = this.classLoader.getResources(path);
        HashSet<String> returnSet = new HashSet<String>();
        if (!fileUrls.hasMoreElements() && (path.startsWith("jar:") || path.startsWith("file:"))) {
            fileUrls = new Vector<URL>(Arrays.asList(new URL(path))).elements();
        }
        block3: while (true) {
            block13: {
                Enumeration<JarEntry> entries;
                block16: {
                    block14: {
                        URL fileUrl;
                        block15: {
                            if (!fileUrls.hasMoreElements()) break block14;
                            fileUrl = fileUrls.nextElement();
                            if (!fileUrl.toExternalForm().startsWith("jar:file:") && !fileUrl.toExternalForm().startsWith("wsjar:file:") && !fileUrl.toExternalForm().startsWith("zip:")) break block15;
                            String[] zipAndFile = fileUrl.getFile().split("!");
                            String zipFilePath = zipAndFile[0];
                            zipFilePath = zipFilePath.matches("file:\\/[A-Za-z]:\\/.*") ? zipFilePath.replaceFirst("file:\\/", "") : zipFilePath.replaceFirst("file:", "");
                            zipFilePath = URLDecoder.decode(zipFilePath, "UTF-8");
                            if (path.startsWith("classpath:")) {
                                path = path.replaceFirst("classpath:", "");
                            }
                            if (path.startsWith("classpath*:")) {
                                path = path.replaceFirst("classpath\\*:", "");
                            }
                            JarFile zipfile = new JarFile(zipFilePath, false);
                            entries = zipfile.entries();
                            break block16;
                        }
                        try {
                            File file = new File(fileUrl.toURI());
                            if (file.exists()) {
                                this.getContents(file, recursive, includeFiles, includeDirectories, path, returnSet);
                            }
                            break block13;
                        }
                        catch (URISyntaxException e) {
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        break block13;
                    }
                    if (returnSet.size() == 0) {
                        return null;
                    }
                    return returnSet;
                }
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(path)) continue;
                    if (!recursive) {
                        String pathAsDir;
                        String string = pathAsDir = path.endsWith("/") ? path : path + "/";
                        if (!entry.getName().startsWith(pathAsDir) || entry.getName().substring(pathAsDir.length()).contains("/")) continue;
                    }
                    if (entry.isDirectory() && includeDirectories) {
                        returnSet.add(entry.getName());
                        continue;
                    }
                    if (!includeFiles) continue;
                    returnSet.add(entry.getName());
                }
            }
            Enumeration<URL> resources = this.classLoader.getResources(path);
            while (true) {
                if (!resources.hasMoreElements()) continue block3;
                String url = resources.nextElement().toExternalForm();
                url = url.replaceFirst("^\\Q" + path + "\\E", "");
                returnSet.add(url);
            }
            break;
        }
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        String description;
        if (this.classLoader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            for (URL url : ((URLClassLoader)this.classLoader).getURLs()) {
                urls.add(url.toExternalForm());
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.classLoader.getClass().getName();
        }
        return this.getClass().getName() + "(" + description + ")";
    }
}

