/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) ^ (~ 0u)) => uvec3(4294967259u, 4294967263u, 4294967207u)
 * (uvec3(36u, 32u, 88u) ^ (~ 6u)) => uvec3(4294967261u, 4294967257u, 4294967201u)
 * (uvec3(36u, 32u, 88u) ^ (~ 12u)) => uvec3(4294967255u, 4294967251u, 4294967211u)
 * (uvec3(36u, 32u, 88u) ^ (~ 32u)) => uvec3(4294967291u, 4294967295u, 4294967175u)
 * (uvec3(36u, 32u, 88u) ^ (~ 74u)) => uvec3(4294967185u, 4294967189u, 4294967277u)
 * (uvec3(59u, 77u, 68u) ^ (~ 0u)) => uvec3(4294967236u, 4294967218u, 4294967227u)
 * (uvec3(59u, 77u, 68u) ^ (~ 6u)) => uvec3(4294967234u, 4294967220u, 4294967229u)
 * (uvec3(59u, 77u, 68u) ^ (~ 12u)) => uvec3(4294967240u, 4294967230u, 4294967223u)
 * (uvec3(59u, 77u, 68u) ^ (~ 32u)) => uvec3(4294967268u, 4294967186u, 4294967195u)
 * (uvec3(59u, 77u, 68u) ^ (~ 74u)) => uvec3(4294967182u, 4294967288u, 4294967281u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) ^ (~ 0u)), uvec3(4294967259u, 4294967263u, 4294967207u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (~ 6u)), uvec3(4294967261u, 4294967257u, 4294967201u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (~ 12u)), uvec3(4294967255u, 4294967251u, 4294967211u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (~ 32u)), uvec3(4294967291u, 4294967295u, 4294967175u))) ? 1 : -1] array3;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (~ 74u)), uvec3(4294967185u, 4294967189u, 4294967277u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (~ 0u)), uvec3(4294967236u, 4294967218u, 4294967227u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (~ 6u)), uvec3(4294967234u, 4294967220u, 4294967229u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (~ 12u)), uvec3(4294967240u, 4294967230u, 4294967223u))) ? 1 : -1] array7;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (~ 32u)), uvec3(4294967268u, 4294967186u, 4294967195u))) ? 1 : -1] array8;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (~ 74u)), uvec3(4294967182u, 4294967288u, 4294967281u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
