/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResAttr
extends ResBagValue {
    private final int mType;
    private final Integer mMin;
    private final Integer mMax;
    private final Boolean mL10n;

    ResAttr(ResReferenceValue parentVal, int type, Integer min, Integer max, Boolean l10n) {
        super(parentVal);
        this.mType = type;
        this.mMin = min;
        this.mMax = max;
        this.mL10n = l10n;
    }

    public String convertToResXmlFormat(ResScalarValue value) throws AndrolibException {
        return null;
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        String type = this.getTypeAsString();
        serializer.startTag(null, "attr");
        serializer.attribute(null, "name", res.getResSpec().getName());
        if (type != null) {
            serializer.attribute(null, "format", type);
        }
        if (this.mMin != null) {
            serializer.attribute(null, "min", this.mMin.toString());
        }
        if (this.mMax != null) {
            serializer.attribute(null, "max", this.mMax.toString());
        }
        if (this.mL10n != null && this.mL10n.booleanValue()) {
            serializer.attribute(null, "localization", "suggested");
        }
        this.serializeBody(serializer, res);
        serializer.endTag(null, "attr");
    }

    public static ResAttr factory(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items, ResValueFactory factory, ResPackage pkg) throws AndrolibException {
        int i;
        Integer min = null;
        Integer max = null;
        Boolean l10n = null;
        block9: for (i = 1; i < items.length; ++i) {
            switch ((Integer)items[i].m1) {
                case 0x1000001: {
                    min = ((ResScalarValue)items[i].m2).getRawIntValue();
                    continue block9;
                }
                case 0x1000002: {
                    max = ((ResScalarValue)items[i].m2).getRawIntValue();
                    continue block9;
                }
                case 0x1000003: {
                    l10n = ((ResScalarValue)items[i].m2).getRawIntValue() != 0;
                    continue block9;
                }
            }
        }
        int rawValue = ((ResScalarValue)items[0].m2).getRawIntValue();
        int scalarType = rawValue & 0xFFFF;
        if (i == items.length) {
            return new ResAttr(parent, scalarType, min, max, l10n);
        }
        Duo[] attrItems = new Duo[items.length - i];
        int j = 0;
        while (i < items.length) {
            int resId = (Integer)items[i].m1;
            pkg.addSynthesizedRes(resId);
            attrItems[j++] = new Duo<ResReferenceValue, ResScalarValue>(factory.newReference(resId, null), (ResScalarValue)items[i].m2);
            ++i;
        }
        switch (rawValue & 0xFF0000) {
            case 65536: {
                return new ResEnumAttr(parent, scalarType, min, max, l10n, attrItems);
            }
            case 131072: {
                return new ResFlagsAttr(parent, scalarType, min, max, l10n, attrItems);
            }
        }
        throw new AndrolibException("Could not decode attr value");
    }

    protected void serializeBody(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
    }

    protected String getTypeAsString() {
        String s = "";
        if ((this.mType & 1) != 0) {
            s = s + "|reference";
        }
        if ((this.mType & 2) != 0) {
            s = s + "|string";
        }
        if ((this.mType & 4) != 0) {
            s = s + "|integer";
        }
        if ((this.mType & 8) != 0) {
            s = s + "|boolean";
        }
        if ((this.mType & 0x10) != 0) {
            s = s + "|color";
        }
        if ((this.mType & 0x20) != 0) {
            s = s + "|float";
        }
        if ((this.mType & 0x40) != 0) {
            s = s + "|dimension";
        }
        if ((this.mType & 0x80) != 0) {
            s = s + "|fraction";
        }
        if (s.isEmpty()) {
            return null;
        }
        return s.substring(1);
    }
}

