/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class CreationTool
extends AbstractTool {
    protected Map<AttributeKey, Object> prototypeAttributes;
    protected String presentationName;
    protected Dimension minimalSizeTreshold = new Dimension(2, 2);
    protected Dimension minimalSize = new Dimension(40, 40);
    protected Figure prototype;
    protected Figure createdFigure;
    private boolean isToolDoneAfterCreation = true;

    public CreationTool(String string) {
        this(string, null, null);
    }

    public CreationTool(String string, Map<AttributeKey, Object> map) {
        this(string, map, null);
    }

    public CreationTool(String string, Map<AttributeKey, Object> map, String string2) {
        try {
            this.prototype = (Figure)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to create Figure from " + string);
            internalError.initCause(exception);
            throw internalError;
        }
        this.prototypeAttributes = map;
        if (string2 == null) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            string2 = resourceBundleUtil.getString("edit.createFigure.text");
        }
        this.presentationName = string2;
    }

    public CreationTool(Figure figure) {
        this(figure, null, null);
    }

    public CreationTool(Figure figure, Map<AttributeKey, Object> map) {
        this(figure, map, null);
    }

    public CreationTool(Figure figure, Map<AttributeKey, Object> map, String string) {
        this.prototype = figure;
        this.prototypeAttributes = map;
        if (string == null) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            string = resourceBundleUtil.getString("edit.createFigure.text");
        }
        this.presentationName = string;
    }

    public Figure getPrototype() {
        return this.prototype;
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        if (this.getView() != null) {
            this.getView().setCursor(Cursor.getDefaultCursor());
        }
        if (this.createdFigure != null) {
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.getView().clearSelection();
        this.createdFigure = this.createFigure();
        Point2D.Double double_ = this.constrainPoint(this.viewToDrawing(this.anchor));
        this.anchor.x = mouseEvent.getX();
        this.anchor.y = mouseEvent.getY();
        this.createdFigure.setBounds(double_, double_);
        this.getDrawing().add(this.createdFigure);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            Point2D.Double double_ = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.createdFigure.willChange();
            this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), double_);
            this.createdFigure.changed();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            Rectangle2D.Double double_ = this.createdFigure.getBounds();
            if (double_.width == 0.0 && double_.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
                if (this.isToolDoneAfterCreation()) {
                    this.fireToolDone();
                }
            } else {
                if (Math.abs(this.anchor.x - mouseEvent.getX()) < this.minimalSizeTreshold.width && Math.abs(this.anchor.y - mouseEvent.getY()) < this.minimalSizeTreshold.height) {
                    this.createdFigure.willChange();
                    this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(double_.width, (double)this.minimalSize.width), this.anchor.y + (int)Math.max(double_.height, (double)this.minimalSize.height))));
                    this.createdFigure.changed();
                }
                if (this.createdFigure instanceof CompositeFigure) {
                    ((CompositeFigure)this.createdFigure).layout();
                }
                final Figure figure = this.createdFigure;
                final Drawing drawing = this.getDrawing();
                this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        return CreationTool.this.presentationName;
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        drawing.remove(figure);
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        drawing.add(figure);
                    }
                });
                this.creationFinished(this.createdFigure);
                this.createdFigure = null;
            }
        } else if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    protected Figure createFigure() {
        Figure figure = (Figure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(figure);
        if (this.prototypeAttributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.prototypeAttributes.entrySet()) {
                figure.set(entry.getKey(), entry.getValue());
            }
        }
        return figure;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void creationFinished(Figure figure) {
        if (figure.isSelectable()) {
            this.getView().addToSelection(figure);
        }
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    public void setToolDoneAfterCreation(boolean bl) {
        boolean bl2 = this.isToolDoneAfterCreation;
        this.isToolDoneAfterCreation = bl;
    }

    public boolean isToolDoneAfterCreation() {
        return this.isToolDoneAfterCreation;
    }

    @Override
    public void updateCursor(DrawingView drawingView, Point point) {
        if (drawingView.isEnabled()) {
            drawingView.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            drawingView.setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

