/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey.io.internal;

import com.oracle.bmc.http.client.jersey.io.internal.ContentLengthVerifyingInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableContentLengthVerifyingInputStream
extends ContentLengthVerifyingInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCloseableContentLengthVerifyingInputStream.class);
    private boolean isStreamClosed = false;

    public AutoCloseableContentLengthVerifyingInputStream(InputStream delegate, long contentLength) {
        super(delegate, contentLength);
    }

    @Override
    public int read() throws IOException {
        if (this.isStreamClosed) {
            return -1;
        }
        int byteRead = super.read();
        this.autoCloseStream();
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.isStreamClosed) {
            return -1;
        }
        int bytesRead = super.read(b);
        this.autoCloseStream();
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isStreamClosed) {
            return -1;
        }
        int bytesRead = super.read(b, off, len);
        this.autoCloseStream();
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.isStreamClosed) {
            return -1L;
        }
        long bytesSkipped = super.skip(n);
        this.autoCloseStream();
        return bytesSkipped;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Reset not supported for AutoCloseableContentLengthVerifyingInputStream, to supportreset, please disable auto-close by calling Options.shouldAutoCloseResponseInputStream(false)");
    }

    private void autoCloseStream() throws IOException {
        if (this.totalBytesProcessed >= this.contentLength) {
            this.close();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.isStreamClosed) {
            return 0;
        }
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        this.isStreamClosed = true;
    }
}

