/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.impl;

import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.spi.ConsoleDataDisplayerImpl;
import org.netbeans.modules.hudson.ui.actions.Hyperlinker;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class HudsonConsoleDisplayer
extends ConsoleDataDisplayerImpl {
    private final HudsonJob job;
    private final String displayName;
    private OutputWriter out;
    private OutputWriter err;
    private Hyperlinker hyperlinker;
    private InputOutput io;

    public HudsonConsoleDisplayer(HudsonJobBuild build) {
        this.job = build.getJob();
        this.displayName = build.getDisplayName();
    }

    public HudsonConsoleDisplayer(HudsonMavenModuleBuild moduleBuild) {
        this.job = moduleBuild.getBuild().getJob();
        this.displayName = moduleBuild.getDisplayName();
    }

    public synchronized void open() {
        this.hyperlinker = new Hyperlinker(this.job);
        this.io = IOProvider.getDefault().getIO(this.displayName, new Action[0]);
        this.io.select();
        this.out = this.io.getOut();
        this.err = this.io.getErr();
    }

    public synchronized boolean writeLine(String line) {
        if (this.out.checkError() || this.err.checkError() || this.io.isClosed()) {
            return false;
        }
        OutputWriter stream = line.matches("(?i).*((warn(ing)?|err(or)?)[]:]|failed).*") ? this.err : this.out;
        this.hyperlinker.handleLine(line, stream);
        return true;
    }

    public void close() {
        this.out.close();
        this.err.close();
    }
}

