/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.editor.lsp.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cpplite.editor.Utils;
import org.netbeans.modules.cpplite.editor.lsp.options.CPPLiteOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CPPLitePanel
extends JPanel {
    private final ResourceBundle bundle = NbBundle.getBundle(CPPLitePanel.class);
    private final CPPLiteOptionsPanelController controller;
    private JButton cclsBrowse;
    private JLabel cclsLabel;
    private JTextField cclsPath;
    private JButton clangdBrowse;
    private JLabel clangdLabel;
    private JTextField clangdPath;
    private Box.Filler filler1;
    private JLabel jLabel3;
    private JComboBox<String> preferredLsChooser;
    private JLabel preferredLsLabel;

    CPPLitePanel(final CPPLiteOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.preferredLsChooser.setModel(new DefaultComboBoxModel<String>(Utils.AVAILABLE_LS));
        this.preferredLsChooser.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String translatedValue = String.valueOf(value);
                String translationKey = "languageServer." + value;
                if (CPPLitePanel.this.bundle.containsKey(translationKey)) {
                    translatedValue = CPPLitePanel.this.bundle.getString(translationKey);
                }
                return super.getListCellRendererComponent(list, translatedValue, index, isSelected, cellHasFocus);
            }
        });
        DocumentListener pathsModified = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                controller.changed();
            }
        };
        this.cclsPath.getDocument().addDocumentListener(pathsModified);
        this.clangdPath.getDocument().addDocumentListener(pathsModified);
    }

    private void initComponents() {
        this.cclsLabel = new JLabel();
        this.cclsPath = new JTextField();
        this.cclsBrowse = new JButton();
        this.clangdLabel = new JLabel();
        this.clangdPath = new JTextField();
        this.clangdBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.preferredLsLabel = new JLabel();
        this.preferredLsChooser = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.cclsLabel, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.cclsLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.cclsLabel, gridBagConstraints);
        this.cclsPath.setText(NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.cclsPath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.cclsPath, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cclsBrowse, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.cclsBrowse.text"));
        this.cclsBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPPLitePanel.this.cclsBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.cclsBrowse, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.clangdLabel, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.clangdLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.clangdLabel, gridBagConstraints);
        this.clangdPath.setText(NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.clangdPath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.clangdPath, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.clangdBrowse, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.clangdBrowse.text"));
        this.clangdBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPPLitePanel.this.clangdBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.clangdBrowse, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.preferredLsLabel, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.preferredLsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.preferredLsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add(this.preferredLsChooser, gridBagConstraints);
    }

    private void cclsBrowseActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.cclsPath);
    }

    private void clangdBrowseActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.clangdPath);
    }

    private void showFileChooser(JTextField path) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File(path.getText()));
        if (fc.showDialog(this, "Select") == 0) {
            path.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    void load() {
        this.cclsPath.setText(Utils.getCCLSPath());
        this.clangdPath.setText(Utils.getCLANGDPath());
        this.preferredLsChooser.setSelectedItem(Utils.getPreferredLs());
    }

    void store() {
        Utils.settings().put("ccls", this.cclsPath.getText());
        Utils.settings().put("clangd", this.clangdPath.getText());
        Utils.settings().put("preferredLS", (String)this.preferredLsChooser.getSelectedItem());
    }

    boolean valid() {
        return true;
    }
}

