/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.sync;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.xml.XMLDataObjectLook;
import org.netbeans.modules.xml.cookies.CookieManagerCookie;
import org.netbeans.modules.xml.sync.FileRepresentation;
import org.netbeans.modules.xml.sync.Representation;
import org.netbeans.modules.xml.sync.SyncSupport;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.util.Util;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class DataObjectSyncSupport
extends SyncSupport
implements Synchronizator {
    private final List<Representation> reps = new ArrayList<Representation>(3);
    private final CookieManagerCookie cookieMgr;

    public DataObjectSyncSupport(XMLDataObjectLook dobj) {
        super((DataObject)dobj);
        this.cookieMgr = dobj.getCookieManager();
        FileRepresentation basic = new FileRepresentation(this.getDO(), this);
        this.reps.add(basic);
    }

    @Override
    public void representationChanged(Class type) {
        super.representationChanged(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Representation[] getRepresentations() {
        List<Representation> list = this.reps;
        synchronized (list) {
            return this.reps.toArray(new Representation[0]);
        }
    }

    @Override
    public Representation getPrimaryRepresentation() {
        Class[] priority = new Class[]{Document.class, FileObject.class};
        Representation[] all = this.getRepresentations();
        for (int i = 0; i < priority.length; ++i) {
            for (int r = 0; r < all.length; ++r) {
                Representation rep = all[r];
                if (!rep.isValid() || !rep.represents(priority[i])) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Primary rep = " + rep);
                }
                return rep;
            }
        }
        throw new IllegalStateException("No primary representation found: " + this.reps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepresentation(Representation rep) {
        List<Representation> list;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Sync addRepresentation " + rep);
        }
        if (rep.represents(Document.class)) {
            list = this.reps;
            synchronized (list) {
                Iterator<Representation> it = this.reps.iterator();
                while (it.hasNext()) {
                    Representation next = it.next();
                    if (!next.represents(FileObject.class)) continue;
                    it.remove();
                }
            }
        } else if (rep.level() > 1) {
            this.loadTextRepresentation();
        }
        list = this.reps;
        synchronized (list) {
            this.reps.add(rep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRepresentation(Representation rep) {
        List<Representation> list;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Sync removeRepresentation " + rep);
        }
        boolean modelLoaded = false;
        if (rep.represents(Document.class)) {
            list = this.reps;
            synchronized (list) {
                for (Representation next : this.reps) {
                    if (next.level() <= 1) continue;
                    modelLoaded = true;
                }
                if (!modelLoaded) {
                    FileRepresentation basic = new FileRepresentation(this.getDO(), this);
                    this.reps.add(basic);
                }
            }
            if (modelLoaded) {
                this.loadTextRepresentation();
            }
        }
        list = this.reps;
        synchronized (list) {
            this.reps.remove(rep);
        }
        if (modelLoaded) {
            this.representationChanged(Document.class);
        }
    }

    private void loadTextRepresentation() {
        if (this.getDO().isValid()) {
            try {
                EditorCookie editor = (EditorCookie)this.getDO().getCookie(EditorCookie.class);
                editor.openDocument();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

