/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.completion;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.web.beans.completion.ContextUtilities;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentContext {
    private static final Logger LOGGER = Logger.getLogger(DocumentContext.class.getName());
    private Document document;
    private XMLSyntaxSupport syntaxSupport;
    private int caretOffset = -1;
    private SyntaxElement element;
    private Token<XMLTokenId> token;
    private int tokenOffset;
    private boolean valid = false;
    private SyntaxElement docRoot;
    private String defaultNamespace;
    private HashMap<String, String> declaredNamespaces = new HashMap();
    private String schemaLocation;
    private String noNamespaceSchemaLocation;

    DocumentContext(Document document) {
        this.document = document;
        try {
            this.syntaxSupport = XMLSyntaxSupport.getSyntaxSupport((Document)document);
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.FINE, cce.getMessage());
            this.syntaxSupport = XMLSyntaxSupport.createSyntaxSupport((Document)document);
        }
    }

    public void reset(int caretOffset) {
        this.caretOffset = caretOffset;
        this.initialize();
    }

    private void initialize() {
        this.valid = true;
        this.declaredNamespaces.clear();
        try {
            this.element = this.syntaxSupport.getElementChain(this.caretOffset);
            int[] bounds = new int[1];
            this.token = this.syntaxSupport.getTokenAtPosition(this.caretOffset, bounds);
            this.tokenOffset = bounds[0];
            this.docRoot = ContextUtilities.getRoot(this.element);
            this.populateNamespaces();
        }
        catch (BadLocationException ex) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public XMLTokenId getCurrentTokenId() {
        if (this.isValid()) {
            return (XMLTokenId)this.token.id();
        }
        return null;
    }

    public Token<XMLTokenId> getCurrentToken() {
        if (this.isValid()) {
            return this.token;
        }
        return null;
    }

    public String getCurrentTokenImage() {
        if (this.isValid()) {
            return this.token.text().toString();
        }
        return null;
    }

    public SyntaxElement getCurrentElement() {
        return this.element;
    }

    public Document getDocument() {
        return this.document;
    }

    public String lookupNamespacePrefix(String prefix) {
        return this.declaredNamespaces.get(prefix);
    }

    public String getNamespacePrefix(String namespace) {
        for (Map.Entry<String, String> entry : this.declaredNamespaces.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<String> getDeclaredNamespaces() {
        return this.declaredNamespaces.values();
    }

    public SyntaxElement getDocRoot() {
        return this.docRoot;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public int getCurrentTokenOffset() {
        return this.tokenOffset;
    }

    private void populateNamespaces() {
        SyntaxElement element;
        for (element = this.element; element != null && !this.syntaxSupport.isStartTag(element) && !this.syntaxSupport.isEmptyTag(element); element = element.getPrevious()) {
        }
        if (element == null) {
            return;
        }
        for (Node node = (Node)element; node != null && element != null; node = node.getParentNode()) {
            if (!this.syntaxSupport.isStartTag(element) && !this.syntaxSupport.isEmptyTag(element)) continue;
            NamedNodeMap attributes = node.getAttributes();
            for (int index = 0; index < attributes.getLength(); ++index) {
                String prefix;
                Attr attr = (Attr)attributes.item(index);
                String attrName = attr.getName();
                String attrValue = attr.getValue();
                if (attrName == null || attrValue == null || (prefix = ContextUtilities.getPrefixFromNamespaceDeclaration(attrName)) == null || this.declaredNamespaces.containsKey(prefix)) continue;
                this.declaredNamespaces.put(prefix, attrValue);
            }
        }
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentContext other = (DocumentContext)obj;
        return this.document == other.document || this.document != null && this.document.equals(other.document);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.document != null ? this.document.hashCode() : 0);
        return hash;
    }

    public XMLSyntaxSupport getSyntaxSupport() {
        return this.syntaxSupport;
    }
}

