/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.chardata.UnicodeCharacterAliases;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.errors.PyErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonLocaleData;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonREMode;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class PythonRegexLexer
extends RegexLexer {
    private static final CodePointSet ASCII_WHITESPACE = CodePointSet.createNoDedup(9, 13, 32, 32);
    private static final CodePointSet ASCII_NON_WHITESPACE = CodePointSet.createNoDedup(0, 8, 14, 31, 33, 0x10FFFF);
    private static final CodePointSet XID_START = UnicodeProperties.getProperty("XID_Start").union(CodePointSet.create(95));
    private static final CodePointSet XID_CONTINUE = UnicodeProperties.getProperty("XID_Continue");
    private static final Map<Character, CodePointSet> UNICODE_CHAR_CLASS_SETS;
    private static final CodePointSet PYTHON_DOT;
    private final PythonREMode mode;
    private final Deque<PythonFlags> flagsStack = new ArrayDeque<PythonFlags>();
    private PythonFlags globalFlags;
    private final CodePointSetAccumulator caseFoldTmp = new CodePointSetAccumulator();
    private PythonLocaleData localeData;

    public PythonRegexLexer(RegexSource source, PythonREMode mode, CompilationBuffer compilationBuffer) {
        super(source, compilationBuffer);
        this.mode = mode;
        this.globalFlags = new PythonFlags(source.getFlags());
    }

    private static int lookupCharacterByName(String characterName) {
        String normalizedName = characterName.trim().toUpperCase(Locale.ROOT);
        if (UnicodeCharacterAliases.CHARACTER_ALIASES.containsKey((Object)normalizedName)) {
            return (Integer)UnicodeCharacterAliases.CHARACTER_ALIASES.get((Object)normalizedName);
        }
        return UCharacter.getCharFromName((String)characterName);
    }

    public PythonLocaleData getLocaleData() {
        if (this.localeData == null) {
            try {
                this.localeData = PythonLocaleData.getLocaleData(this.source.getOptions().getPythonLocale());
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedRegexException(e.getMessage(), this.source);
            }
        }
        return this.localeData;
    }

    public void fixFlags() {
        this.globalFlags = this.globalFlags.fixFlags(this.source, this.mode);
    }

    public PythonFlags getGlobalFlags() {
        return this.globalFlags;
    }

    public void addGlobalFlags(PythonFlags newGlobalFlags) {
        this.globalFlags = this.globalFlags.addFlags(newGlobalFlags);
    }

    public PythonFlags getLocalFlags() {
        return this.flagsStack.isEmpty() ? this.globalFlags : this.flagsStack.peek();
    }

    public void pushLocalFlags(PythonFlags localFlags) {
        this.flagsStack.push(localFlags);
    }

    public void popLocalFlags() {
        this.flagsStack.pop();
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.getLocalFlags().isIgnoreCase();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return true;
    }

    @Override
    protected boolean featureEnabledZLowerCaseAssertion() {
        return false;
    }

    @Override
    protected boolean featureEnabledWordBoundaries() {
        return true;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return true;
    }

    @Override
    protected boolean featureEnabledPossessiveQuantifiers() {
        return true;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return true;
    }

    @Override
    protected boolean featureEnabledNestedCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledPOSIXCharClasses() {
        return false;
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return false;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return true;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return this.getLocalFlags().isVerbose();
    }

    @Override
    protected boolean featureEnabledIgnoreWhiteSpace() {
        return false;
    }

    @Override
    protected TBitSet getWhitespace() {
        return DEFAULT_WHITESPACE;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return true;
    }

    @Override
    protected boolean featureEnabledSpecialGroups() {
        return true;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return false;
    }

    @Override
    protected boolean featureEnabledClassSetExpressions() {
        return false;
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.getLocalFlags().isDotAll() ? Constants.DOT_ALL : PYTHON_DOT;
    }

    @Override
    protected CodePointSet getIdContinue() {
        return XID_CONTINUE;
    }

    @Override
    protected CodePointSet getIdStart() {
        return XID_START;
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return 2;
    }

    @Override
    protected void caseFoldUnfold(CodePointSetAccumulator charClass) {
        if (this.getLocalFlags().isLocale()) {
            this.getLocaleData().caseFoldUnfold(charClass, this.caseFoldTmp);
        } else {
            CaseFoldData.CaseFoldUnfoldAlgorithm caseFolding = this.getLocalFlags().isUnicode(this.mode) ? CaseFoldData.CaseFoldUnfoldAlgorithm.PythonUnicode : CaseFoldData.CaseFoldUnfoldAlgorithm.PythonAscii;
            CaseFoldData.applyCaseFoldUnfold(charClass, this.caseFoldTmp, caseFolding);
        }
    }

    @Override
    protected CodePointSet complementClassSet(CodePointSet codePointSet) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected ClassSetContents caseFoldClassSetAtom(ClassSetContents classSetContents) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        if (this.getLocalFlags().isUnicode(this.mode)) {
            return UNICODE_CHAR_CLASS_SETS.get(Character.valueOf(c));
        }
        switch (c) {
            case 'd': {
                return Constants.DIGITS;
            }
            case 'D': {
                return Constants.NON_DIGITS;
            }
            case 's': {
                if (this.mode == PythonREMode.Bytes || this.getLocalFlags().isAscii()) {
                    return ASCII_WHITESPACE;
                }
                return Constants.WHITE_SPACE;
            }
            case 'S': {
                if (this.mode == PythonREMode.Bytes || this.getLocalFlags().isAscii()) {
                    return ASCII_NON_WHITESPACE;
                }
                return Constants.NON_WHITE_SPACE;
            }
            case 'w': {
                if (this.getLocalFlags().isLocale()) {
                    return this.getLocaleData().getWordCharacters();
                }
                return Constants.WORD_CHARS;
            }
            case 'W': {
                if (this.getLocalFlags().isLocale()) {
                    return this.getLocaleData().getNonWordCharacters();
                }
                return Constants.NON_WORD_CHARS;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void checkClassSetCharacter(int codePoint) throws RegexSyntaxException {
    }

    @Override
    protected long boundedQuantifierMaxValue() {
        return Integer.MAX_VALUE;
    }

    private RegexSyntaxException handleBadCharacterInGroupName(RegexLexer.ParseGroupNameResult result) {
        return this.syntaxErrorAtRel(PyErrorMessages.badCharacterInGroupName(result.groupName), result.groupName.length() + 1);
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxErrorAtAbs("min repeat greater than max repeat", this.getLastTokenPosition() + 1);
    }

    @Override
    protected Token handleBoundedQuantifierSyntaxError() throws RegexSyntaxException {
        this.position = this.getLastTokenPosition() + 1;
        return this.literalChar(123);
    }

    @Override
    protected Token handleBoundedQuantifierOverflow(long min, long max) {
        return null;
    }

    @Override
    protected Token handleBoundedQuantifierOverflowMin(long min, long max) {
        return null;
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int rangeStart) {
        return this.syntaxErrorAtAbs(PyErrorMessages.badCharacterRange(this.pattern.substring(rangeStart, this.position)), rangeStart);
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int rangeStart, ClassSetContents firstAtom, ClassSetContents secondAtom) {
        throw this.syntaxErrorAtAbs(PyErrorMessages.badCharacterRange(this.pattern.substring(rangeStart, this.position)), rangeStart);
    }

    @Override
    protected CodePointSet getPOSIXCharClass(String name) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXCollationElement(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void validatePOSIXEquivalenceClass(String sequence) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleComplementOfStringSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleEmptyGroupName() {
        return this.syntaxErrorHere("missing group name");
    }

    @Override
    protected void handleGroupRedefinition(String name, int newId, int oldId) {
        throw this.syntaxErrorAtRel(PyErrorMessages.redefinitionOfGroupName(name, newId, oldId), name.length() + 1);
    }

    @Override
    protected void handleIncompleteEscapeX() {
        throw this.syntaxError(PyErrorMessages.incompleteEscape(this.substring(2 + this.count(RegexLexer::isHexDigit))));
    }

    @Override
    protected void handleInvalidBackReference(int reference) {
        String ref = Integer.toString(reference);
        throw this.syntaxErrorAtRel(PyErrorMessages.invalidGroupReference(ref), ref.length());
    }

    @Override
    protected void handleInvalidBackReference(String reference) {
        throw this.syntaxErrorAtRel(PyErrorMessages.invalidGroupReference(reference), reference.length());
    }

    @Override
    protected RegexSyntaxException handleInvalidCharInCharClass() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        this.retreat();
        return this.syntaxErrorAtAbs(PyErrorMessages.unknownExtensionQ(this.curChar()), this.getLastTokenPosition() + 1);
    }

    @Override
    protected RegexSyntaxException handleMixedClassSetOperators(RegexLexer.ClassSetOperator leftOperator, RegexLexer.ClassSetOperator rightOperator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleMissingClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleOctalOutOfRange() {
        throw this.syntaxError(PyErrorMessages.invalidOctalEscape(this.substring(4)));
    }

    @Override
    protected RegexSyntaxException handleRangeAsClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw this.syntaxError("bad escape (end of pattern)");
    }

    @Override
    protected void handleUnfinishedGroupComment() {
        throw this.syntaxError("missing ), unterminated comment");
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        return this.syntaxErrorHere("unexpected end of pattern");
    }

    @Override
    protected RegexSyntaxException handleUnfinishedRangeInClassSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnmatchedRightBrace() {
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxErrorAtAbs("unterminated character set", this.getLastCharacterClassBeginPosition());
    }

    @Override
    protected void handleUnmatchedRightBracket() {
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        int c = this.consumeChar();
        return Character.isHighSurrogate((char)c) ? this.finishSurrogatePair((char)c) : c;
    }

    @Override
    protected Token parseCustomEscape(char c) {
        if (PythonRegexLexer.isOctalDigit(c) && this.lookahead(RegexLexer::isOctalDigit, 2)) {
            int codePoint = (c - 48) * 64 + (this.consumeChar() - 48) * 8 + (this.consumeChar() - 48);
            if (codePoint > 255) {
                this.handleOctalOutOfRange();
            }
            return this.literalChar(codePoint);
        }
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        switch (c) {
            case 'a': {
                return 7;
            }
            case 'U': 
            case 'u': {
                if (this.mode == PythonREMode.Str) {
                    int escapeLength = switch (c) {
                        case 'u' -> 4;
                        case 'U' -> 8;
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    int length = this.countUpTo(RegexLexer::isHexDigit, escapeLength);
                    if (length != escapeLength) {
                        throw this.syntaxError(PyErrorMessages.incompleteEscape(this.substring(2 + length)));
                    }
                    this.advance(length);
                    try {
                        int codePoint = Integer.parseInt(this.pattern, this.position - length, this.position, 16);
                        if (codePoint > 0x10FFFF) {
                            throw this.syntaxError(PyErrorMessages.invalidUnicodeEscape(this.substring(2 + length)));
                        }
                        return codePoint;
                    }
                    catch (NumberFormatException e) {
                        throw this.syntaxError(PyErrorMessages.incompleteEscape(this.substring(2 + length)));
                    }
                }
                throw this.syntaxError(PyErrorMessages.badEscape(c));
            }
            case 'N': {
                if (this.mode != PythonREMode.Str) {
                    throw this.syntaxError(PyErrorMessages.badEscape(c));
                }
                if (!this.consumingLookahead("{")) {
                    throw this.syntaxErrorHere(PyErrorMessages.missing("{"));
                }
                int nameStart = this.position;
                int nameEnd = this.pattern.indexOf(125, this.position);
                if (this.atEnd() || nameEnd == this.position) {
                    throw this.syntaxErrorHere(PyErrorMessages.missing("character name"));
                }
                if (nameEnd < 0) {
                    throw this.syntaxErrorHere(PyErrorMessages.missingUnterminatedName('}'));
                }
                String characterName = this.pattern.substring(nameStart, nameEnd);
                this.position = nameEnd + 1;
                int codePoint = PythonRegexLexer.lookupCharacterByName(characterName);
                if (codePoint == -1) {
                    throw this.syntaxError(PyErrorMessages.undefinedCharacterName(characterName));
                }
                return codePoint;
            }
        }
        return -1;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
            throw this.syntaxError(PyErrorMessages.badEscape(c));
        }
        return c;
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        switch (charAfterQuestionMark) {
            case 'P': {
                this.mustHaveMore();
                char ch2 = this.consumeChar();
                switch (ch2) {
                    case '<': {
                        int pos = this.position;
                        RegexLexer.ParseGroupNameResult result = this.parseGroupName('>');
                        switch (result.state) {
                            case empty: {
                                throw this.syntaxErrorHere("missing group name");
                            }
                            case unterminated: {
                                throw this.syntaxErrorAtAbs("missing >, unterminated name", pos);
                            }
                            case invalidStart: 
                            case invalidRest: {
                                throw this.handleBadCharacterInGroupName(result);
                            }
                            case valid: {
                                this.registerNamedCaptureGroup(result.groupName);
                                break;
                            }
                            default: {
                                throw CompilerDirectives.shouldNotReachHere();
                            }
                        }
                        return Token.createCaptureGroupBegin();
                    }
                    case '=': {
                        return this.parseNamedBackReference();
                    }
                }
                throw this.syntaxErrorAtRel(PyErrorMessages.unknownExtensionP(ch2), 3);
            }
            case '>': {
                return Token.createAtomicGroupBegin();
            }
            case '(': {
                return this.parseConditionalBackReference();
            }
            case '-': 
            case 'L': 
            case 'a': 
            case 'i': 
            case 'm': 
            case 's': 
            case 't': 
            case 'u': 
            case 'x': {
                return this.parseInlineFlags(charAfterQuestionMark);
            }
        }
        return null;
    }

    @Override
    protected Token parseGroupLt() {
        if (this.atEnd()) {
            throw this.syntaxErrorHere("unexpected end of pattern");
        }
        throw this.syntaxErrorAtAbs(PyErrorMessages.unknownExtensionLt(this.curChar()), this.getLastTokenPosition() + 1);
    }

    private Token parseConditionalBackReference() {
        boolean namedReference;
        int groupNumber;
        RegexLexer.ParseGroupNameResult result = this.parseGroupName(')');
        switch (result.state) {
            case empty: {
                throw this.syntaxErrorHere("missing group name");
            }
            case unterminated: {
                throw this.syntaxErrorAtRel("missing ), unterminated name", result.groupName.length());
            }
            case invalidStart: 
            case invalidRest: {
                this.position -= result.groupName.length() + 1;
                assert (this.lookahead(result.groupName + ")"));
                int groupNumberLength = this.countDecimalDigits();
                if (groupNumberLength != result.groupName.length()) {
                    this.position += result.groupName.length() + 1;
                    throw this.handleBadCharacterInGroupName(result);
                }
                groupNumber = this.parseIntSaturated(0, result.groupName.length(), -1);
                namedReference = false;
                assert (this.curChar() == ')');
                this.advance();
                if (groupNumber == 0) {
                    throw this.syntaxErrorAtRel("bad group number", result.groupName.length() + 1);
                }
                if (groupNumber != -1) break;
                throw this.syntaxErrorAtRel(PyErrorMessages.invalidGroupReference(result.groupName), result.groupName.length() + 1);
            }
            case valid: {
                if (this.namedCaptureGroups != null && this.namedCaptureGroups.containsKey(result.groupName)) {
                    assert (((List)this.namedCaptureGroups.get(result.groupName)).size() == 1);
                    groupNumber = (Integer)((List)this.namedCaptureGroups.get(result.groupName)).get(0);
                    namedReference = true;
                    break;
                }
                throw this.syntaxErrorAtRel(PyErrorMessages.unknownGroupName(result.groupName, this.mode), result.groupName.length() + 1);
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        return Token.createConditionalBackReference(groupNumber, namedReference);
    }

    private Token parseInlineFlags(int ch0) {
        int ch = ch0;
        PythonFlags positiveFlags = PythonFlags.EMPTY_INSTANCE;
        while (PythonFlags.isValidFlagChar(ch)) {
            positiveFlags = this.addFlag(positiveFlags, ch);
            ch = this.consumeChar();
        }
        switch (ch) {
            case 41: {
                return Token.createInlineFlags(positiveFlags, true);
            }
            case 58: {
                if (positiveFlags.includesGlobalFlags()) {
                    throw this.syntaxErrorAtRel("bad inline flags: cannot turn on global flag", 1);
                }
                return this.parseLocalFlags(positiveFlags, PythonFlags.EMPTY_INSTANCE);
            }
            case 45: {
                if (positiveFlags.includesGlobalFlags()) {
                    throw this.syntaxErrorAtRel("bad inline flags: cannot turn on global flag", 1);
                }
                if (this.atEnd()) {
                    throw this.syntaxErrorHere("missing flag");
                }
                ch = this.consumeChar();
                if (!PythonFlags.isValidFlagChar(ch)) {
                    if (Character.isAlphabetic(ch)) {
                        throw this.syntaxErrorAtRel("unknown flag", 1);
                    }
                    throw this.syntaxErrorAtRel("missing flag", 1);
                }
                PythonFlags negativeFlags = PythonFlags.EMPTY_INSTANCE;
                while (PythonFlags.isValidFlagChar(ch)) {
                    negativeFlags = negativeFlags.addFlag(ch);
                    if (PythonFlags.isTypeFlagChar(ch)) {
                        throw this.syntaxErrorHere("bad inline flags: cannot turn off flags 'a', 'u' and 'L'");
                    }
                    if (this.atEnd()) {
                        throw this.syntaxErrorHere("missing :");
                    }
                    ch = this.consumeChar();
                }
                if (ch != 58) {
                    if (Character.isAlphabetic(ch)) {
                        throw this.syntaxErrorAtRel("unknown flag", 1);
                    }
                    throw this.syntaxErrorAtRel("missing :", 1);
                }
                if (negativeFlags.includesGlobalFlags()) {
                    throw this.syntaxErrorAtRel("bad inline flags: cannot turn off global flag", 1);
                }
                return this.parseLocalFlags(positiveFlags, negativeFlags);
            }
        }
        if (Character.isAlphabetic(ch)) {
            throw this.syntaxErrorAtRel("unknown flag", 1);
        }
        throw this.syntaxErrorAtRel("missing -, : or )", 1);
    }

    private PythonFlags addFlag(PythonFlags flagsArg, int ch) {
        PythonFlags flags = flagsArg.addFlag(ch);
        if (this.mode == PythonREMode.Str && ch == 76) {
            throw this.syntaxErrorHere("bad inline flags: cannot use 'L' flag with a str pattern");
        }
        if (this.mode == PythonREMode.Bytes && ch == 117) {
            throw this.syntaxErrorHere("bad inline flags: cannot use 'u' flag with a bytes pattern");
        }
        if (flags.numberOfTypeFlags() > 1) {
            throw this.syntaxErrorHere("bad inline flags: flags 'a', 'u' and 'L' are incompatible");
        }
        if (this.atEnd()) {
            throw this.syntaxErrorHere("missing -, : or )");
        }
        return flags;
    }

    private Token parseLocalFlags(PythonFlags positiveFlags, PythonFlags negativeFlags) {
        if (positiveFlags.overlaps(negativeFlags)) {
            throw this.syntaxErrorAtRel("bad inline flags: flag turned on and off", 1);
        }
        PythonFlags newFlags = this.getLocalFlags().addFlags(positiveFlags).delFlags(negativeFlags);
        if (positiveFlags.numberOfTypeFlags() > 0) {
            PythonFlags otherTypes = PythonFlags.TYPE_FLAGS_INSTANCE.delFlags(positiveFlags);
            newFlags = newFlags.delFlags(otherTypes);
        }
        return Token.createInlineFlags(newFlags, false);
    }

    private void mustHaveMore() {
        if (this.atEnd()) {
            throw this.syntaxErrorHere("unexpected end of pattern");
        }
    }

    private Token parseNamedBackReference() {
        RegexLexer.ParseGroupNameResult result = this.parseGroupName(')');
        switch (result.state) {
            case empty: {
                throw this.syntaxErrorHere("missing group name");
            }
            case unterminated: {
                throw this.syntaxErrorAtRel("missing ), unterminated name", result.groupName.length());
            }
            case invalidStart: 
            case invalidRest: {
                throw this.handleBadCharacterInGroupName(result);
            }
            case valid: {
                if (this.namedCaptureGroups != null && this.namedCaptureGroups.containsKey(result.groupName)) {
                    assert (((List)this.namedCaptureGroups.get(result.groupName)).size() == 1);
                    return Token.createBackReference((Integer)((List)this.namedCaptureGroups.get(result.groupName)).get(0), true);
                }
                throw this.syntaxErrorAtRel(PyErrorMessages.unknownGroupName(result.groupName, this.mode), result.groupName.length() + 1);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private String substring(int length) {
        return this.pattern.substring(this.getLastAtomPosition(), this.getLastAtomPosition() + length);
    }

    public RegexSyntaxException syntaxErrorAtAbs(String msg, int i) {
        return RegexSyntaxException.createPattern(this.source, msg, i);
    }

    private RegexSyntaxException syntaxErrorAtRel(String msg, int i) {
        return RegexSyntaxException.createPattern(this.source, msg, this.position - i);
    }

    public RegexSyntaxException syntaxErrorHere(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.position);
    }

    static {
        PYTHON_DOT = CodePointSet.createNoDedup(0, 9, 11, 0x10FFFF);
        UNICODE_CHAR_CLASS_SETS = new HashMap<Character, CodePointSet>();
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('d'), UnicodeProperties.getProperty("General_Category=Decimal_Number"));
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('D'), UnicodeProperties.getProperty("General_Category=Decimal_Number").createInverse(Encodings.UTF_32));
        CodePointSet unicodeSpaces = UnicodeProperties.getProperty("White_Space");
        CodePointSet spaces = unicodeSpaces.union(CodePointSet.createNoDedup(28, 31));
        CodePointSet nonSpaces = spaces.createInverse(Encodings.UTF_32);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('s'), spaces);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('S'), nonSpaces);
        CodePointSet alpha = UnicodeProperties.getProperty("General_Category=Letter");
        CodePointSet numericExtras = CodePointSet.createNoDedup(63851, 63859, 63864, 63922, 63953, 63955, 63997, 194704);
        CodePointSet numeric = UnicodeProperties.getProperty("General_Category=Number").union(numericExtras);
        CodePointSet wordChars = alpha.union(numeric).union(CodePointSet.create(95));
        CodePointSet nonWordChars = wordChars.createInverse(Encodings.UTF_32);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('w'), wordChars);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('W'), nonWordChars);
    }
}

