/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.context.index.processor.CandidateComponentsMetadata;
import org.springframework.context.index.processor.PropertiesMarshaller;

class MetadataStore {
    static final String METADATA_PATH = "META-INF/spring.components";
    private final ProcessingEnvironment environment;

    public MetadataStore(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    public CandidateComponentsMetadata readMetadata() {
        try {
            return this.readMetadata(this.getMetadataResource().openInputStream());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void writeMetadata(CandidateComponentsMetadata metadata) throws IOException {
        if (!metadata.getItems().isEmpty()) {
            try (OutputStream outputStream = this.createMetadataResource().openOutputStream();){
                PropertiesMarshaller.write(metadata, outputStream);
            }
        }
    }

    private CandidateComponentsMetadata readMetadata(InputStream in) throws IOException {
        try {
            CandidateComponentsMetadata candidateComponentsMetadata = PropertiesMarshaller.read(in);
            return candidateComponentsMetadata;
        }
        finally {
            in.close();
        }
    }

    private FileObject getMetadataResource() throws IOException {
        return this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", METADATA_PATH);
    }

    private FileObject createMetadataResource() throws IOException {
        return this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", METADATA_PATH, new Element[0]);
    }
}

