/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient;

import io.foojay.api.discoclient.util.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public enum PropertyManager {
    INSTANCE;

    private Properties properties = new Properties();

    private PropertyManager() {
        String propFilePath = Constants.HOME_FOLDER + File.separator + "discoclient.properties";
        Path path = Paths.get(propFilePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            this.createProperties(this.properties);
        }
        try (FileInputStream propFile = new FileInputStream(propFilePath);){
            this.properties.load(propFile);
        }
        catch (IOException ex) {
            System.out.println("Error reading properties file. " + ex);
        }
        if (this.properties.isEmpty()) {
            this.createProperties(this.properties);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object get(String KEY) {
        return this.properties.getOrDefault((Object)KEY, "");
    }

    public void set(String KEY, String VALUE) {
        this.properties.setProperty(KEY, VALUE);
        try {
            this.properties.store(new FileOutputStream(String.join((CharSequence)File.separator, System.getProperty("user.dir"), "discoclient.properties")), null);
        }
        catch (IOException exception) {
            System.out.println("Error writing properties file: " + exception);
        }
    }

    public String getString(String key) {
        return this.properties.getOrDefault((Object)key, "").toString();
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return Double.parseDouble(this.properties.getOrDefault((Object)key, Double.toString(defaultValue)).toString());
    }

    public void setDouble(String key, double value) {
        this.properties.setProperty(key, Double.toString(value));
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return Float.parseFloat(this.properties.getOrDefault((Object)key, Float.toString(defaultValue)).toString());
    }

    public void setFloat(String key, float value) {
        this.properties.setProperty(key, Float.toString(value));
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return Integer.parseInt(this.properties.getOrDefault((Object)key, Integer.toString(defaultValue)).toString());
    }

    public void setInt(String key, int value) {
        this.properties.setProperty(key, Integer.toString(value));
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return Long.parseLong(this.properties.getOrDefault((Object)key, Long.toString(defaultValue)).toString());
    }

    public void setLong(String key, long value) {
        this.properties.setProperty(key, Long.toString(value));
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.properties.getOrDefault((Object)key, Boolean.toString(defaultValue)).toString());
    }

    public void setBoolean(String key, boolean value) {
        this.properties.setProperty(key, Boolean.toString(value));
    }

    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public String getApiVersion() {
        return this.properties.getOrDefault((Object)"api_version", "3.0").toString();
    }

    public String getPackagesPath() {
        String apiVersion = this.getApiVersion();
        return "/disco/v" + apiVersion + "/packages";
    }

    public String getEphemeralIdsPath() {
        String apiVersion = this.getApiVersion();
        return "/disco/v" + apiVersion + "/ephemeral_ids";
    }

    public String getMajorVersionsPath() {
        String apiVersion = this.getApiVersion();
        return "/disco/v" + apiVersion + "/major_versions";
    }

    public String getIdsPath() {
        String apiVersion = this.getApiVersion();
        return "/disco/v" + apiVersion + "/ids";
    }

    public String getDistributionsPath() {
        String apiVersion = this.getApiVersion();
        return "/disco/v" + apiVersion + "/distributions";
    }

    public void storeProperties() {
        if (null == this.properties) {
            return;
        }
        String propFilePath = Constants.HOME_FOLDER + "discoclient.properties";
        try (FileOutputStream output = new FileOutputStream(propFilePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createProperties(Properties properties) {
        String propFilePath = Constants.HOME_FOLDER + File.separator + "discoclient.properties";
        try (FileOutputStream output = new FileOutputStream(propFilePath);){
            properties.put("url", "https://api.foojay.io");
            properties.put("api_version", "3.0");
            properties.put("distro_url", "https://github.com/foojayio/distributions/raw/main/distributions.json");
            properties.store(output, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

