/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.specs.support.api.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;

public final class JndiNamespacesDefinition {
    public static final String MODULE_NAMESPACE = "java:module";
    public static final String APPLICATION_NAMESPACE = "java:app";
    public static final String GLOBAL_NAMESPACE = "java:global";
    private static final Set<String> PREFIXES = new HashSet<String>();
    private static final String DEFAULT_PREFIX = "java:comp/env/";

    private JndiNamespacesDefinition() {
    }

    public static String normalize(String jndi, String defaultNamespace) {
        for (String p : PREFIXES) {
            if (!jndi.startsWith(p)) continue;
            return jndi;
        }
        if (jndi.startsWith("java:/") || jndi.startsWith("java:jboss/")) {
            return jndi;
        }
        return defaultNamespace == null ? DEFAULT_PREFIX + jndi : defaultNamespace + "/" + jndi;
    }

    @CheckForNull
    public static String getNamespace(@NonNull String jndi) {
        for (String p : PREFIXES) {
            if (!jndi.startsWith(p)) continue;
            return p.substring(0, p.length() - 1);
        }
        if (jndi.startsWith("java:/") || jndi.startsWith("java:jboss/")) {
            return jndi.substring(0, jndi.indexOf(47));
        }
        return null;
    }

    static {
        Collections.addAll(PREFIXES, "java:comp/", "java:module/", "java:app/", "java:global/");
    }
}

