/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.editor.ClassNamePanel;
import org.netbeans.modules.jshell.editor.ShellActionBase;
import org.netbeans.modules.jshell.editor.SnippetClassGenerator;
import org.netbeans.modules.jshell.support.ShellSession;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class GenerateClassAction
extends ShellActionBase {
    public static final String NAME = "jshell-save-to-class";
    private static final String CLASSNAME_PROPERTY = GenerateClassAction.class.getName() + ".classname";
    private static final String FOLDER_PROPERTY = GenerateClassAction.class.getName() + ".folder";

    public GenerateClassAction() {
        super(NAME);
    }

    @Override
    protected void doPerformAction(ActionEvent evt, JTextComponent target, ShellSession s) {
        Node sel = (Node)Utilities.actionsGlobalContext().lookup(Node.class);
        FileObject anchor = null;
        if (sel != null) {
            anchor = (FileObject)sel.getLookup().lookup(FileObject.class);
        }
        this.doGenerateForSession(target, s, anchor);
    }

    private void doGenerateForSession(JTextComponent target, ShellSession s, FileObject anchor) {
        Project p = s.getEnv().getProject();
        String n = (String)target.getClientProperty(CLASSNAME_PROPERTY);
        if (anchor == null) {
            anchor = (FileObject)target.getClientProperty(FOLDER_PROPERTY);
        }
        ClassNamePanel panel = new ClassNamePanel(p, anchor, n);
        JButton b = new JButton(Bundle.BTN_OK());
        Object[] opts = new Object[]{b, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.TITLE_GenerateClassFromSnippets(), true, opts, (Object)b, 1, new HelpCtx(GenerateClassAction.class.getName()), null);
        panel.setNotifier(desc.createNotificationLineSupport());
        desc.setClosingOptions(opts);
        panel.addChangeListener(e -> b.setEnabled(!panel.hasErrors()));
        Object r = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (r != b) {
            return;
        }
        String cn = panel.getClassName();
        FileObject folder = panel.getTarget();
        target.putClientProperty(CLASSNAME_PROPERTY, cn);
        target.putClientProperty(FOLDER_PROPERTY, folder);
        SnippetClassGenerator task = new SnippetClassGenerator(p, s, folder, cn);
        RequestProcessor.getDefault().post((Runnable)task).addTaskListener(e -> this.finishGeneration(task));
    }

    private void finishGeneration(SnippetClassGenerator task) {
        if (task.getJavaFile() != null) {
            OpenCookie cake = (OpenCookie)task.getJavaFile().getLookup().lookup(OpenCookie.class);
            if (cake != null) {
                cake.open();
            } else {
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_CouldNotOpenTargetFile(task.getJavaFile().getName()));
            }
        }
        if (task.getError() != null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.ERR_GenerationError(task.getError().getLocalizedMessage()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }
}

