/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DoubleCheck {
    public static ErrorDescription run(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Tree e = treePath.getLeaf();
        SynchronizedTree synch = (SynchronizedTree)e;
        TreePath outer = DoubleCheck.findOuterIf(ctx, treePath);
        if (outer == null) {
            return null;
        }
        IfTree same = null;
        TreePath samePath = null;
        TreePath block = new TreePath(treePath, synch.getBlock());
        TreePath exprPath = null;
        TreePath[] fieldPath = new TreePath[1];
        for (StatementTree statementTree : synch.getBlock().getStatements()) {
            samePath = new TreePath(block, statementTree);
            exprPath = DoubleCheck.sameIfAndValidate(compilationInfo, samePath, outer, fieldPath);
            if (exprPath != null) {
                same = (IfTree)statementTree;
                break;
            }
            if (!ctx.isCanceled()) continue;
            return null;
        }
        if (same == null) {
            return null;
        }
        Element el = compilationInfo.getTrees().getElement(fieldPath[0]);
        if (el == null) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(exprPath);
        boolean jdk5 = compilationInfo.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
        boolean checkLocalVar = element != null && element.getKind() == ElementKind.LOCAL_VARIABLE;
        boolean varVolatile = el.getModifiers().contains((Object)Modifier.VOLATILE);
        boolean field = el.getKind() == ElementKind.FIELD;
        Fix fix = null;
        if (!(varVolatile && jdk5 && field)) {
            fix = new SynchronizeFix(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)outer, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()).toEditorFix();
        }
        Fix fix2 = null;
        if (jdk5 && field && (!checkLocalVar || !varVolatile)) {
            int style = checkLocalVar && !varVolatile ? 0 : (varVolatile && !checkLocalVar ? 2 : 1);
            fix2 = new DoubleCheckJDK5Fix(TreePathHandle.create((TreePath)outer, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)exprPath, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)fieldPath[0], (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)samePath, (CompilationInfo)compilationInfo), style).toEditorFix();
        }
        int span = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), synch);
        if (fix == null && fix2 == null) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(DoubleCheck.class, (String)"ERR_DoubleCheck"), (Fix[])new Fix[]{fix2, fix});
    }

    private static TreePath findOuterIf(HintContext ctx, TreePath treePath) {
        while (!ctx.isCanceled() && (treePath = treePath.getParentPath()) != null) {
            BlockTree b;
            Tree leaf = treePath.getLeaf();
            if (leaf.getKind() == Tree.Kind.IF) {
                return treePath;
            }
            if (leaf.getKind() == Tree.Kind.BLOCK && (b = (BlockTree)leaf).getStatements().size() == 1) continue;
            return null;
        }
        return null;
    }

    private static TreePath findParentOfKind(TreePath p, Tree.Kind kind) {
        while (p != null) {
            if (p.getLeaf().getKind() == kind) {
                return p;
            }
            p = p.getParentPath();
        }
        return p;
    }

    private static boolean sameCompilationUnit(TreePath first, TreePath second) {
        TreePath one = DoubleCheck.findParentOfKind(first, Tree.Kind.COMPILATION_UNIT);
        TreePath two = DoubleCheck.findParentOfKind(second, Tree.Kind.COMPILATION_UNIT);
        return one != null && two != null && one.getLeaf() == two.getLeaf();
    }

    private static TreePath sameIfAndValidate(CompilationInfo info, TreePath statementTP, TreePath secondTP, TreePath[] fieldRef) {
        StatementTree statement = (StatementTree)statementTP.getLeaf();
        if (statement.getKind() != Tree.Kind.IF) {
            return null;
        }
        IfTree first = (IfTree)statement;
        IfTree second = (IfTree)secondTP.getLeaf();
        if (first.getElseStatement() != null) {
            return null;
        }
        if (second.getElseStatement() != null) {
            return null;
        }
        TreePath varFirst = DoubleCheck.equalToNull(new TreePath(statementTP, first.getCondition()));
        TreePath varSecond = DoubleCheck.equalToNull(new TreePath(secondTP, second.getCondition()));
        if (varFirst == null || varSecond == null) {
            return null;
        }
        Element firstVariable = info.getTrees().getElement(varFirst);
        Element secondVariable = info.getTrees().getElement(varSecond);
        Element target = firstVariable;
        if (firstVariable != null && firstVariable.equals(secondVariable)) {
            Iterator<? extends TreePath> i;
            TreePath methodPath;
            Flow.FlowResult fr;
            Iterable<? extends TreePath> itp;
            TreePath var = info.getTrees().getPath(firstVariable);
            if (info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) < 0) {
                fieldRef[0] = var;
                return varFirst;
            }
            if (firstVariable.getKind() == ElementKind.LOCAL_VARIABLE && (itp = (fr = Flow.assignmentsForUse(info, methodPath = Utilities.findTopLevelBlock(varFirst), new AtomicBoolean(false))).getAssignmentsForUse().get(varFirst.getLeaf())) != null && (i = itp.iterator()).hasNext()) {
                TreePath v = i.next();
                if (!i.hasNext() && (target = info.getTrees().getElement(v)) != null && target.getKind() == ElementKind.FIELD && !DoubleCheck.sameCompilationUnit(var = info.getTrees().getPath(target), varFirst)) {
                    var = info.getTrees().getPath(firstVariable);
                }
            }
            fieldRef[0] = var;
            return varFirst;
        }
        return null;
    }

    private static TreePath equalToNull(TreePath tp) {
        ExpressionTree t = (ExpressionTree)tp.getLeaf();
        if (t.getKind() == Tree.Kind.PARENTHESIZED) {
            ParenthesizedTree p = (ParenthesizedTree)t;
            t = p.getExpression();
            tp = new TreePath(tp, t);
        }
        if (t.getKind() != Tree.Kind.EQUAL_TO) {
            return null;
        }
        BinaryTree bt = (BinaryTree)t;
        if (bt.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL && bt.getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return new TreePath(tp, bt.getRightOperand());
        }
        if (bt.getLeftOperand().getKind() != Tree.Kind.NULL_LITERAL && bt.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            return new TreePath(tp, bt.getLeftOperand());
        }
        return null;
    }

    private static final class SynchronizeFix
    extends JavaFix {
        private TreePathHandle synchHandle;
        private FileObject file;

        public SynchronizeFix(TreePathHandle synchHandle, TreePathHandle ifHandle, FileObject file) {
            super(ifHandle);
            this.synchHandle = synchHandle;
            this.file = file;
        }

        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"FIX_DoubleCheck");
        }

        public String toString() {
            return "FixDoubleCheck";
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath ifTreePath = ctx.getPath();
            Tree syncTree = this.synchHandle.resolve((CompilationInfo)wc).getLeaf();
            wc.rewrite(ifTreePath.getLeaf(), syncTree);
        }
    }

    private static final class DoubleCheckJDK5Fix
    extends JavaFix {
        private final TreePathHandle fieldAccessHandle;
        private final TreePathHandle fieldHandle;
        private final TreePathHandle innerIfHandle;
        private final int justVolatile;
        private Flow.FlowResult flow;

        public DoubleCheckJDK5Fix(TreePathHandle handle, TreePathHandle fieldAccessHandle, TreePathHandle fieldHandle, TreePathHandle innerIfHandle, int justVolatile) {
            super(handle);
            this.fieldAccessHandle = fieldAccessHandle;
            this.fieldHandle = fieldHandle;
            this.innerIfHandle = innerIfHandle;
            this.justVolatile = justVolatile;
        }

        protected String getText() {
            switch (this.justVolatile) {
                case 0: {
                    return NbBundle.getMessage(DoubleCheck.class, (String)"FIX_DoubleCheck_Volatile");
                }
                case 1: {
                    return NbBundle.getMessage(DoubleCheck.class, (String)"FIX_DoubleCheck_5");
                }
                case 2: {
                    return NbBundle.getMessage(DoubleCheck.class, (String)"FIX_DoubleCheck_Local");
                }
            }
            throw new IllegalStateException();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker mk = wc.getTreeMaker();
            TreePath varPath = this.fieldAccessHandle.resolve((CompilationInfo)wc);
            TreePath fieldPath = this.fieldHandle.resolve((CompilationInfo)wc);
            Element ve = wc.getTrees().getElement(fieldPath);
            if (ve == null) {
                return;
            }
            VariableTree vt = (VariableTree)fieldPath.getLeaf();
            if (!vt.getModifiers().getFlags().contains((Object)Modifier.VOLATILE)) {
                ModifiersTree mt = wc.getTreeMaker().addModifiersModifier(vt.getModifiers(), Modifier.VOLATILE);
                wc.rewrite((Tree)vt.getModifiers(), (Tree)mt);
            }
            Element classEl = ((VariableElement)ve).getEnclosingElement();
            if (this.justVolatile == 0) {
                return;
            }
            ExpressionTree fieldAccess = (ExpressionTree)varPath.getLeaf();
            if (fieldAccess.getKind() == Tree.Kind.IDENTIFIER) {
                fieldAccess = ve.getModifiers().contains((Object)Modifier.STATIC) ? mk.MemberSelect(mk.QualIdent(classEl), (CharSequence)vt.getName()) : mk.MemberSelect((ExpressionTree)mk.Identifier((CharSequence)"this"), (CharSequence)vt.getName());
            }
            TreePath ifStatement = ctx.getPath();
            TreePath ifParent = ifStatement.getParentPath();
            BlockTree blTree = (BlockTree)ifParent.getLeaf();
            VariableTree localCopy = mk.Variable(mk.Modifiers(Collections.emptySet()), (CharSequence)vt.getName(), vt.getType(), fieldAccess);
            int ifIndex = blTree.getStatements().indexOf(ifStatement.getLeaf());
            BlockTree newBlock = mk.insertBlockStatement(blTree, ifIndex, (StatementTree)localCopy);
            wc.rewrite((Tree)blTree, (Tree)newBlock);
            TreePath innerIf = this.innerIfHandle.resolve((CompilationInfo)wc);
            TreePath innerBlock = innerIf.getParentPath();
            assert (innerBlock.getLeaf().getKind() == Tree.Kind.BLOCK);
            BlockTree bt = (BlockTree)innerBlock.getLeaf();
            int innerIfIndex = bt.getStatements().indexOf(innerIf.getLeaf());
            BlockTree nbt = mk.insertBlockStatement(bt, innerIfIndex, (StatementTree)mk.ExpressionStatement((ExpressionTree)mk.Assignment((ExpressionTree)mk.Identifier((CharSequence)vt.getName()), fieldAccess)));
            wc.rewrite((Tree)bt, (Tree)nbt);
            TreePath topLevel = Utilities.findTopLevelBlock(ifParent);
            this.flow = Flow.assignmentsForUse((CompilationInfo)wc, topLevel, new AtomicBoolean(false));
            VariableAccessWalker walker = new VariableAccessWalker((VariableElement)ve, fieldAccess, mk.Identifier((CharSequence)localCopy.getName()), ifStatement, wc);
            walker.scan(topLevel, null);
        }
    }

    private static final class VariableAccessWalker
    extends ErrorAwareTreePathScanner {
        private final VariableElement originalVariable;
        private final ExpressionTree fieldAccessTree;
        private final ExpressionTree localVarTree;
        private final TreePath ifPath;
        private final WorkingCopy wc;
        private final TreeMaker mk;
        private boolean ifEncountered;

        public VariableAccessWalker(VariableElement originalVariable, ExpressionTree fieldAccessTree, ExpressionTree localVarTree, TreePath ifPath, WorkingCopy wc) {
            this.originalVariable = originalVariable;
            this.fieldAccessTree = fieldAccessTree;
            this.localVarTree = localVarTree;
            this.ifPath = ifPath;
            this.wc = wc;
            this.mk = wc.getTreeMaker();
        }

        public Object scan(Tree p, Object o) {
            this.ifEncountered |= p == this.ifPath.getLeaf();
            return super.scan(p, o);
        }

        public Object visitIdentifier(IdentifierTree node, Object p) {
            Element el;
            if (this.ifEncountered && (el = this.wc.getTrees().getElement(this.getCurrentPath())) == this.originalVariable) {
                this.wc.rewrite((Tree)node, (Tree)this.localVarTree);
                return null;
            }
            return super.visitIdentifier(node, p);
        }

        public Object visitMemberSelect(MemberSelectTree node, Object p) {
            Element el;
            if (this.ifEncountered && (el = this.wc.getTrees().getElement(this.getCurrentPath())) == this.originalVariable) {
                this.wc.rewrite((Tree)node, (Tree)this.localVarTree);
                return null;
            }
            return super.visitMemberSelect(node, p);
        }

        public Object visitCompoundAssignment(CompoundAssignmentTree node, Object p) {
            return super.visitCompoundAssignment(node, p);
        }

        public Object visitAssignment(AssignmentTree node, Object p) {
            if (!this.ifEncountered) {
                return super.visitAssignment(node, p);
            }
            Element el = this.wc.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            if (el == this.originalVariable) {
                AssignmentTree et = this.mk.Assignment(this.fieldAccessTree, (ExpressionTree)this.mk.Assignment(this.localVarTree, node.getExpression()));
                this.wc.rewrite((Tree)node, (Tree)et);
            }
            return this.scan(node.getExpression(), p);
        }
    }
}

